/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;

public class ZUGFeRDVisualizer {
    static final ClassLoader CLASS_LOADER = ZUGFeRDVisualizer.class.getClassLoader();
    private static final String RESOURCE_PATH = "";
    private static final Logger LOG = Logger.getLogger(ZUGFeRDVisualizer.class.getName());
    private TransformerFactory mFactory = new TransformerFactoryImpl();
    private Templates mXsltXRTemplate = null;
    private Templates mXsltUBLTemplate = null;
    private Templates mXsltHTMLTemplate = null;
    private Templates mXsltZF1HTMLTemplate = null;

    public ZUGFeRDVisualizer() {
        this.mFactory.setURIResolver(new ClasspathResourceURIResolver());
    }

    public String visualize(String xmlFilename, Language lang) throws FileNotFoundException, TransformerException, UnsupportedEncodingException {
        try {
            if (this.mXsltXRTemplate == null) {
                this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
            }
            this.mXsltHTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xrechnung-html." + lang.name().toLowerCase() + ".xsl")));
            if (this.mXsltZF1HTMLTemplate == null) {
                this.mXsltZF1HTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ZUGFeRD_1p0_c1p0_s1p0.xslt")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        FileInputStream fis = new FileInputStream(xmlFilename);
        String fileContent = RESOURCE_PATH;
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(xmlFilename, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            LOG.log(Level.SEVERE, null, e2);
        }
        final ByteArrayOutputStream iaos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String zf1Signature = "rsm:CrossIndustryDocument";
        String zf2Signature = "rsm:CrossIndustryInvoice";
        String ublSignature = "ubl:Invoice";
        String ublCreditNoteSignature = "ubl:CreditNote";
        boolean doPostProcessing = false;
        if (fileContent.contains(zf1Signature)) {
            this.applyZF1XSLT(fis, baos);
        } else if (fileContent.contains(zf2Signature)) {
            this.applyZF2XSLT(fis, iaos);
            doPostProcessing = true;
        } else if (fileContent.contains(ublSignature)) {
            this.applyUBL2XSLT(fis, iaos);
            doPostProcessing = true;
        } else if (fileContent.contains(ublCreditNoteSignature)) {
            this.applyUBLCreditNote2XSLT(fis, iaos);
            doPostProcessing = true;
        }
        if (doPostProcessing) {
            PipedInputStream in = new PipedInputStream();
            try {
                final PipedOutputStream out = new PipedOutputStream(in);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            iaos.writeTo(out);
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, null, e);
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException e) {
                                    LOG.log(Level.SEVERE, null, e);
                                }
                            }
                        }
                    }
                }).start();
                this.applyXSLTToHTML(in, baos);
            }
            catch (IOException e1) {
                LOG.log(Level.SEVERE, null, e1);
            }
        }
        return baos.toString("UTF-8");
    }

    public void applyZF2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltXRTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    public void applyUBL2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-invoice-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    public void applyUBLCreditNote2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-creditnote-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    public void applyZF1XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltZF1HTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    public void applyXSLTToHTML(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltHTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/" + href));
        }
    }

    public static enum Language {
        EN,
        FR,
        DE;

    }
}

