/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.AbstractHasText;
import com.helger.commons.text.IMultilingualText;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadOnlyMapBasedMultilingualText
extends AbstractHasText
implements IMultilingualText,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReadOnlyMapBasedMultilingualText.class);
    private static final AtomicBoolean CONSISTENCY_CHECK_ENABED = new AtomicBoolean(GlobalDebug.isDebugMode());
    private final ICommonsOrderedMap<Locale, String> m_aTexts;

    protected AbstractReadOnlyMapBasedMultilingualText() {
        this(new CommonsLinkedHashMap<Locale, String>());
    }

    protected AbstractReadOnlyMapBasedMultilingualText(@Nonnull ICommonsOrderedMap<Locale, String> iCommonsOrderedMap) {
        this.m_aTexts = ValueEnforcer.notNull(iCommonsOrderedMap, "MapToUse");
    }

    public static void setPerformConsistencyChecks(boolean bl) {
        CONSISTENCY_CHECK_ENABED.set(bl);
    }

    public static boolean isPerformConsistencyChecks() {
        return CONSISTENCY_CHECK_ENABED.get();
    }

    private static void _performConsistencyChecks(@Nonnull String string) {
        if (string.contains("\\n")) {
            LOGGER.warn("Passed string contains a masked newline - replace with an inline one:\n" + string);
        }
        if (string.contains("{0}")) {
            if (RegExHelper.stringMatchesPattern("^'[^'].*", string)) {
                throw new IllegalArgumentException("The passed string seems to start with unclosed single quotes: " + string);
            }
            if (RegExHelper.stringMatchesPattern(".*[^']'[^'].*", string)) {
                throw new IllegalArgumentException("The passed string seems to contain unclosed single quotes: " + string);
            }
        } else if (RegExHelper.stringMatchesPattern(".*''.*", string)) {
            throw new IllegalArgumentException("The passed string seems to contain 2 single quotes: " + string);
        }
    }

    protected final void internalAddText(@Nonnull Map.Entry<Locale, String> entry) {
        this.internalAddText(entry.getKey(), entry.getValue());
    }

    protected final void internalAddText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (this.m_aTexts.containsKey(locale)) {
            throw new IllegalArgumentException("Locale '" + locale + "' already contained: " + this.toString());
        }
        this.internalSetText(locale, string);
    }

    protected final void internalSetText(@Nonnull Locale locale, @Nullable String string) {
        if (string != null && CONSISTENCY_CHECK_ENABED.get()) {
            AbstractReadOnlyMapBasedMultilingualText._performConsistencyChecks(string);
        }
        this.m_aTexts.put(locale, string);
    }

    @Override
    @Nullable
    protected final String internalGetText(@Nonnull Locale locale) {
        return (String)this.m_aTexts.get(locale);
    }

    @Override
    @Nullable
    protected final Locale internalGetLocaleToUseWithFallback(@Nonnull Locale locale) {
        return LocaleHelper.getLocaleToUseOrNull(locale, this.m_aTexts.keySet());
    }

    @Override
    public final boolean containsLocaleWithFallback(@Nullable Locale locale) {
        if (locale != null) {
            for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
                if (!this.m_aTexts.containsKey(locale2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedMap<Locale, String> texts() {
        return this.m_aTexts;
    }

    @OverridingMethodsMustInvokeSuper
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractReadOnlyMapBasedMultilingualText abstractReadOnlyMapBasedMultilingualText = (AbstractReadOnlyMapBasedMultilingualText)object;
        return this.m_aTexts.equals(abstractReadOnlyMapBasedMultilingualText.m_aTexts);
    }

    @OverridingMethodsMustInvokeSuper
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aTexts)).getHashCode();
    }

    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return new ToStringGenerator(this).append("texts", this.m_aTexts).getToString();
    }
}

