/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl22.helper;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.LineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ProjectReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.SignatureType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.CreditNoteTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.InvoiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NoteType;
import oasis.names.specification.ubl.schema.xsd.creditnote_22.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_22.InvoiceType;

@Immutable
public final class UBL22CreditNoteHelper {
    private UBL22CreditNoteHelper() {
    }

    @Nonnull
    public static InvoicedQuantityType cloneToInvoicedQuantity(@Nonnull CreditedQuantityType creditedQuantityType) {
        InvoicedQuantityType invoicedQuantityType = new InvoicedQuantityType();
        creditedQuantityType.cloneTo(invoicedQuantityType);
        return invoicedQuantityType;
    }

    @Nullable
    public static InvoiceTypeCodeType cloneToInvoiceTypeCode(@Nullable CreditNoteTypeCodeType creditNoteTypeCodeType) {
        if (creditNoteTypeCodeType == null) {
            return null;
        }
        InvoiceTypeCodeType invoiceTypeCodeType = new InvoiceTypeCodeType();
        creditNoteTypeCodeType.cloneTo(invoiceTypeCodeType);
        return invoiceTypeCodeType;
    }

    public static void cloneToInvoiceLine(@Nonnull CreditNoteLineType creditNoteLineType, @Nonnull InvoiceLineType invoiceLineType) {
        invoiceLineType.setAccountingCost(creditNoteLineType.getAccountingCost() == null ? null : creditNoteLineType.getAccountingCost().clone());
        invoiceLineType.setAccountingCostCode(creditNoteLineType.getAccountingCostCode() == null ? null : creditNoteLineType.getAccountingCostCode().clone());
        ArrayList<AllowanceChargeType> arrayList = new ArrayList<AllowanceChargeType>();
        for (AllowanceChargeType iExplicitlyCloneable : creditNoteLineType.getAllowanceCharge()) {
            arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
        }
        invoiceLineType.setAllowanceCharge(arrayList);
        arrayList = new ArrayList();
        for (BillingReferenceType billingReferenceType : creditNoteLineType.getBillingReference()) {
            arrayList.add((AllowanceChargeType)((Object)(billingReferenceType == null ? null : billingReferenceType.clone())));
        }
        invoiceLineType.setBillingReference(arrayList);
        arrayList = new ArrayList();
        for (DeliveryType deliveryType : creditNoteLineType.getDelivery()) {
            arrayList.add((AllowanceChargeType)((Object)(deliveryType == null ? null : deliveryType.clone())));
        }
        invoiceLineType.setDelivery(arrayList);
        invoiceLineType.setDeliveryTerms(creditNoteLineType.hasDeliveryTermsEntries() ? creditNoteLineType.getDeliveryTermsAtIndex(0).clone() : null);
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : creditNoteLineType.getDespatchLineReference()) {
            arrayList.add((AllowanceChargeType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        invoiceLineType.setDespatchLineReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteLineType.getDocumentReference()) {
            arrayList.add((AllowanceChargeType)((Object)(documentReferenceType == null ? null : documentReferenceType.clone())));
        }
        invoiceLineType.setDocumentReference(arrayList);
        invoiceLineType.setFreeOfChargeIndicator(creditNoteLineType.getFreeOfChargeIndicator() == null ? null : creditNoteLineType.getFreeOfChargeIndicator().clone());
        invoiceLineType.setID(creditNoteLineType.getID() == null ? null : creditNoteLineType.getID().clone());
        arrayList = new ArrayList();
        for (PeriodType periodType : creditNoteLineType.getInvoicePeriod()) {
            arrayList.add((AllowanceChargeType)((Object)(periodType == null ? null : periodType.clone())));
        }
        invoiceLineType.setInvoicePeriod(arrayList);
        invoiceLineType.setInvoicedQuantity(creditNoteLineType.getCreditedQuantity() == null ? null : UBL22CreditNoteHelper.cloneToInvoicedQuantity(creditNoteLineType.getCreditedQuantity()));
        invoiceLineType.setItem(creditNoteLineType.getItem() == null ? null : creditNoteLineType.getItem().clone());
        invoiceLineType.setItemPriceExtension(creditNoteLineType.getItemPriceExtension() == null ? null : creditNoteLineType.getItemPriceExtension().clone());
        invoiceLineType.setLineExtensionAmount(creditNoteLineType.getLineExtensionAmount() == null ? null : creditNoteLineType.getLineExtensionAmount().clone());
        arrayList = new ArrayList();
        for (NoteType noteType : creditNoteLineType.getNote()) {
            arrayList.add((AllowanceChargeType)((Object)(noteType == null ? null : noteType.clone())));
        }
        invoiceLineType.setNote(arrayList);
        arrayList = new ArrayList();
        for (OrderLineReferenceType orderLineReferenceType : creditNoteLineType.getOrderLineReference()) {
            arrayList.add((AllowanceChargeType)((Object)(orderLineReferenceType == null ? null : orderLineReferenceType.clone())));
        }
        invoiceLineType.setOrderLineReference(arrayList);
        invoiceLineType.setOriginatorParty(creditNoteLineType.getOriginatorParty() == null ? null : creditNoteLineType.getOriginatorParty().clone());
        invoiceLineType.setPaymentPurposeCode(creditNoteLineType.getPaymentPurposeCode() == null ? null : creditNoteLineType.getPaymentPurposeCode().clone());
        arrayList = new ArrayList();
        for (PaymentTermsType paymentTermsType : creditNoteLineType.getPaymentTerms()) {
            arrayList.add((AllowanceChargeType)((Object)(paymentTermsType == null ? null : paymentTermsType.clone())));
        }
        invoiceLineType.setPaymentTerms(arrayList);
        invoiceLineType.setPrice(creditNoteLineType.getPrice() == null ? null : creditNoteLineType.getPrice().clone());
        invoiceLineType.setPricingReference(creditNoteLineType.getPricingReference() == null ? null : creditNoteLineType.getPricingReference().clone());
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : creditNoteLineType.getReceiptLineReference()) {
            arrayList.add((AllowanceChargeType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        invoiceLineType.setReceiptLineReference(arrayList);
        arrayList = new ArrayList();
        for (CreditNoteLineType creditNoteLineType2 : creditNoteLineType.getSubCreditNoteLine()) {
            if (creditNoteLineType2 == null) {
                arrayList.add(null);
                continue;
            }
            InvoiceLineType invoiceLineType2 = new InvoiceLineType();
            UBL22CreditNoteHelper.cloneToInvoiceLine(creditNoteLineType2, invoiceLineType2);
            arrayList.add((AllowanceChargeType)((Object)invoiceLineType2));
        }
        invoiceLineType.setSubInvoiceLine(arrayList);
        invoiceLineType.setTaxPointDate(creditNoteLineType.getTaxPointDate() == null ? null : creditNoteLineType.getTaxPointDate().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : creditNoteLineType.getTaxTotal()) {
            arrayList.add((AllowanceChargeType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        invoiceLineType.setTaxTotal(arrayList);
        invoiceLineType.setUUID(creditNoteLineType.getUUID() == null ? null : creditNoteLineType.getUUID().clone());
    }

    public static void cloneCreditNoteToInvoice(@Nonnull CreditNoteType creditNoteType, @Nonnull InvoiceType invoiceType) {
        invoiceType.setAccountingCost(creditNoteType.getAccountingCost() == null ? null : creditNoteType.getAccountingCost().clone());
        invoiceType.setAccountingCostCode(creditNoteType.getAccountingCostCode() == null ? null : creditNoteType.getAccountingCostCode().clone());
        invoiceType.setAccountingCustomerParty(creditNoteType.getAccountingCustomerParty() == null ? null : creditNoteType.getAccountingCustomerParty().clone());
        invoiceType.setAccountingSupplierParty(creditNoteType.getAccountingSupplierParty() == null ? null : creditNoteType.getAccountingSupplierParty().clone());
        ArrayList<DocumentReferenceType> arrayList = new ArrayList<DocumentReferenceType>();
        for (DocumentReferenceType iExplicitlyCloneable : creditNoteType.getAdditionalDocumentReference()) {
            arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
        }
        invoiceType.setAdditionalDocumentReference(arrayList);
        arrayList = new ArrayList();
        for (AllowanceChargeType allowanceChargeType : creditNoteType.getAllowanceCharge()) {
            arrayList.add((DocumentReferenceType)((Object)(allowanceChargeType == null ? null : allowanceChargeType.clone())));
        }
        invoiceType.setAllowanceCharge(arrayList);
        arrayList = new ArrayList();
        for (BillingReferenceType billingReferenceType : creditNoteType.getBillingReference()) {
            arrayList.add((DocumentReferenceType)((Object)(billingReferenceType == null ? null : billingReferenceType.clone())));
        }
        invoiceType.setBillingReference(arrayList);
        invoiceType.setBuyerCustomerParty(creditNoteType.getBuyerCustomerParty() == null ? null : creditNoteType.getBuyerCustomerParty().clone());
        invoiceType.setBuyerReference(creditNoteType.getBuyerReference() == null ? null : creditNoteType.getBuyerReference().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getContractDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setContractDocumentReference(arrayList);
        invoiceType.setCopyIndicator(creditNoteType.getCopyIndicator() == null ? null : creditNoteType.getCopyIndicator().clone());
        invoiceType.setCustomizationID(creditNoteType.getCustomizationID() == null ? null : creditNoteType.getCustomizationID().clone());
        arrayList = new ArrayList();
        for (DeliveryType deliveryType : creditNoteType.getDelivery()) {
            arrayList.add((DocumentReferenceType)((Object)(deliveryType == null ? null : deliveryType.clone())));
        }
        invoiceType.setDelivery(arrayList);
        invoiceType.setDeliveryTerms(creditNoteType.hasDeliveryTermsEntries() ? creditNoteType.getDeliveryTermsAtIndex(0).clone() : null);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getDespatchDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setDespatchDocumentReference(arrayList);
        invoiceType.setDocumentCurrencyCode(creditNoteType.getDocumentCurrencyCode() == null ? null : creditNoteType.getDocumentCurrencyCode().clone());
        invoiceType.setDueDate(creditNoteType.getDueDate() == null ? null : creditNoteType.getDueDate().clone());
        invoiceType.setID(creditNoteType.getID() == null ? null : creditNoteType.getID().clone());
        arrayList = new ArrayList();
        for (CreditNoteLineType creditNoteLineType : creditNoteType.getCreditNoteLine()) {
            if (creditNoteLineType == null) {
                arrayList.add(null);
                continue;
            }
            InvoiceLineType invoiceLineType = new InvoiceLineType();
            UBL22CreditNoteHelper.cloneToInvoiceLine(creditNoteLineType, invoiceLineType);
            arrayList.add((DocumentReferenceType)((Object)invoiceLineType));
        }
        invoiceType.setInvoiceLine(arrayList);
        arrayList = new ArrayList();
        for (PeriodType periodType : creditNoteType.getInvoicePeriod()) {
            arrayList.add((DocumentReferenceType)((Object)(periodType == null ? null : periodType.clone())));
        }
        invoiceType.setInvoicePeriod(arrayList);
        invoiceType.setInvoiceTypeCode(UBL22CreditNoteHelper.cloneToInvoiceTypeCode(creditNoteType.getCreditNoteTypeCode()));
        invoiceType.setIssueDate(creditNoteType.getIssueDate() == null ? null : creditNoteType.getIssueDate().clone());
        invoiceType.setIssueTime(creditNoteType.getIssueTime() == null ? null : creditNoteType.getIssueTime().clone());
        invoiceType.setLegalMonetaryTotal(creditNoteType.getLegalMonetaryTotal() == null ? null : creditNoteType.getLegalMonetaryTotal().clone());
        invoiceType.setLineCountNumeric(creditNoteType.getLineCountNumeric() == null ? null : creditNoteType.getLineCountNumeric().clone());
        arrayList = new ArrayList();
        for (NoteType noteType : creditNoteType.getNote()) {
            arrayList.add((DocumentReferenceType)((Object)(noteType == null ? null : noteType.clone())));
        }
        invoiceType.setNote(arrayList);
        invoiceType.setOrderReference(creditNoteType.getOrderReference() == null ? null : creditNoteType.getOrderReference().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getOriginatorDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setOriginatorDocumentReference(arrayList);
        invoiceType.setPayeeParty(creditNoteType.getPayeeParty() == null ? null : creditNoteType.getPayeeParty().clone());
        invoiceType.setPaymentAlternativeCurrencyCode(creditNoteType.getPaymentAlternativeCurrencyCode() == null ? null : creditNoteType.getPaymentAlternativeCurrencyCode().clone());
        invoiceType.setPaymentAlternativeExchangeRate(creditNoteType.getPaymentAlternativeExchangeRate() == null ? null : creditNoteType.getPaymentAlternativeExchangeRate().clone());
        invoiceType.setPaymentCurrencyCode(creditNoteType.getPaymentCurrencyCode() == null ? null : creditNoteType.getPaymentCurrencyCode().clone());
        invoiceType.setPaymentExchangeRate(creditNoteType.getPaymentExchangeRate() == null ? null : creditNoteType.getPaymentExchangeRate().clone());
        arrayList = new ArrayList();
        for (PaymentMeansType paymentMeansType : creditNoteType.getPaymentMeans()) {
            arrayList.add((DocumentReferenceType)((Object)(paymentMeansType == null ? null : paymentMeansType.clone())));
        }
        invoiceType.setPaymentMeans(arrayList);
        arrayList = new ArrayList();
        for (PaymentTermsType paymentTermsType : creditNoteType.getPaymentTerms()) {
            arrayList.add((DocumentReferenceType)((Object)(paymentTermsType == null ? null : paymentTermsType.clone())));
        }
        invoiceType.setPaymentTerms(arrayList);
        invoiceType.setPricingCurrencyCode(creditNoteType.getPricingCurrencyCode() == null ? null : creditNoteType.getPricingCurrencyCode().clone());
        invoiceType.setPricingExchangeRate(creditNoteType.getPricingExchangeRate() == null ? null : creditNoteType.getPricingExchangeRate().clone());
        invoiceType.setProfileExecutionID(creditNoteType.getProfileExecutionID() == null ? null : creditNoteType.getProfileExecutionID().clone());
        invoiceType.setProfileID(creditNoteType.getProfileID() == null ? null : creditNoteType.getProfileID().clone());
        arrayList = new ArrayList();
        for (ProjectReferenceType projectReferenceType : creditNoteType.getProjectReference()) {
            arrayList.add((DocumentReferenceType)((Object)(projectReferenceType == null ? null : projectReferenceType.clone())));
        }
        invoiceType.setProjectReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getReceiptDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setReceiptDocumentReference(arrayList);
        invoiceType.setSellerSupplierParty(creditNoteType.getSellerSupplierParty() == null ? null : creditNoteType.getSellerSupplierParty().clone());
        arrayList = new ArrayList();
        for (SignatureType signatureType : creditNoteType.getSignature()) {
            arrayList.add((DocumentReferenceType)((Object)(signatureType == null ? null : signatureType.clone())));
        }
        invoiceType.setSignature(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getStatementDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setStatementDocumentReference(arrayList);
        invoiceType.setTaxCurrencyCode(creditNoteType.getTaxCurrencyCode() == null ? null : creditNoteType.getTaxCurrencyCode().clone());
        invoiceType.setTaxExchangeRate(creditNoteType.getTaxExchangeRate() == null ? null : creditNoteType.getTaxExchangeRate().clone());
        invoiceType.setTaxPointDate(creditNoteType.getTaxPointDate() == null ? null : creditNoteType.getTaxPointDate().clone());
        invoiceType.setTaxRepresentativeParty(creditNoteType.getTaxRepresentativeParty() == null ? null : creditNoteType.getTaxRepresentativeParty().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : creditNoteType.getTaxTotal()) {
            arrayList.add((DocumentReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        invoiceType.setTaxTotal(arrayList);
        invoiceType.setUBLExtensions(creditNoteType.getUBLExtensions() == null ? null : creditNoteType.getUBLExtensions().clone());
        invoiceType.setUBLVersionID(creditNoteType.getUBLVersionID() == null ? null : creditNoteType.getUBLVersionID().clone());
        invoiceType.setUUID(creditNoteType.getUUID() == null ? null : creditNoteType.getUUID().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : creditNoteType.getWithholdingTaxTotal()) {
            arrayList.add((DocumentReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        invoiceType.setWithholdingTaxTotal(arrayList);
    }
}

