/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

import java.io.File;
import org.verapdf.core.utils.AbstractFileOutputMapper;

public class SingleOutputDirMapper
extends AbstractFileOutputMapper {
    private final File outputDir;

    private SingleOutputDirMapper(File outputDir) {
        this(outputDir, "veraPDF_");
    }

    private SingleOutputDirMapper(File outputDir, String prefix) {
        this(outputDir, prefix, "");
    }

    private SingleOutputDirMapper(File outputDir, String prefix, String suffix) {
        super(prefix, suffix);
        this.outputDir = outputDir;
    }

    @Override
    protected File doMapFile(File orig) {
        String newName = SingleOutputDirMapper.addPrefixAndSuffix(orig, this);
        return new File(this.outputDir, newName);
    }

    static SingleOutputDirMapper fromValues(File outputDir, String prefix, String suffix) {
        return new SingleOutputDirMapper(outputDir, prefix, suffix);
    }
}

