/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

public enum TaskType {
    NONE("NONE"),
    PARSE("parsing", "PDF Parsing"),
    VALIDATE("validation", "PDF/A Validation"),
    EXTRACT_FEATURES("features", "Feature Extraction"),
    FIX_METADATA("metadata", "Metadata Repair");

    private final String value;
    private final String fullName;

    private TaskType(String value) {
        this(value, value);
    }

    private TaskType(String value, String fullName) {
        this.value = value;
        this.fullName = fullName;
    }

    public static TaskType fromString(String toParse) {
        for (TaskType processingType : TaskType.values()) {
            if (!processingType.toString().equalsIgnoreCase(toParse)) continue;
            return processingType;
        }
        throw new IllegalArgumentException("String can't be parsed into ProcessingType");
    }

    public String getValue() {
        return this.value;
    }

    public String fullName() {
        return this.fullName;
    }

    public String toString() {
        return this.value;
    }
}

