/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.validation.profiles.ErrorArgument;
import org.verapdf.processor.reports.Check;

final class CheckImpl
implements Check {
    @XmlAttribute
    private final String status;
    @XmlElement
    private final String location;
    @XmlElement
    private final String context;
    @XmlElement
    private final String errorMessage;
    private final List<String> errorArguments;

    private CheckImpl(TestAssertion.Status status, String context, String location, String errorMessage, List<String> errorArguments) {
        this.status = status.toString();
        this.context = context;
        this.location = location;
        this.errorMessage = errorMessage;
        this.errorArguments = Collections.unmodifiableList(errorArguments);
    }

    private CheckImpl() {
        this(TestAssertion.Status.PASSED, "", null, null, null);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public List<String> getErrorArguments() {
        return this.errorArguments;
    }

    static final Check fromValue(TestAssertion assertion) {
        if (assertion == null) {
            throw new IllegalArgumentException("Argument assertion con not be null");
        }
        return new CheckImpl(assertion.getStatus(), CheckImpl.getStringWithoutInvalidXmlChars(assertion.getLocation().getContext()), assertion.getLocationContext(), CheckImpl.getStringWithoutInvalidXmlChars(assertion.getErrorMessage()), assertion.getErrorArguments().stream().map(ErrorArgument::getArgumentValue).collect(Collectors.toList()));
    }

    private static String getStringWithoutInvalidXmlChars(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        Pattern xmlInvalidChars = Pattern.compile("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]");
        return xmlInvalidChars.matcher(string).replaceAll("");
    }

    static class Adapter
    extends XmlAdapter<CheckImpl, Check> {
        Adapter() {
        }

        @Override
        public Check unmarshal(CheckImpl check) {
            return check;
        }

        @Override
        public CheckImpl marshal(Check check) {
            return (CheckImpl)check;
        }
    }
}

