/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.ERandomAccessFileMode;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperations;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.misc.SizeHelper;
import com.helger.commons.io.stream.CountingFileInputStream;
import com.helger.commons.io.stream.CountingFileOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedInputStream;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EValidity;
import com.helger.commons.system.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHelper.class);
    private static final FileHelper INSTANCE = new FileHelper();

    private FileHelper() {
    }

    public static boolean existsFile(@Nullable File file) {
        return file != null && file.isFile();
    }

    public static boolean existsDir(@Nullable File file) {
        return file != null && file.isDirectory();
    }

    public static boolean canReadAndWriteFile(@Nullable File file) {
        File file2;
        if (file == null) {
            return false;
        }
        return !(file.exists() ? !file.canRead() || !file.canWrite() : (file2 = file.getAbsoluteFile().getParentFile()) == null || !file2.isDirectory() || !file2.canRead() || !file2.canWrite());
    }

    @Nonnull
    public static EChange ensureParentDirectoryIsPresent(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        File file2 = file.getParentFile();
        if (file2 == null || file2.exists()) {
            if (file2 != null && !file2.isDirectory()) {
                LOGGER.warn("Parent object specified is not a directory: '" + file2 + "'");
            }
            return EChange.UNCHANGED;
        }
        FileIOError fileIOError = FileOperations.createDirRecursive(file2);
        if (fileIOError.isFailure()) {
            throw new IllegalStateException("Failed to create parent of " + file.getAbsolutePath() + ": " + fileIOError);
        }
        if (!file2.exists()) {
            throw new IllegalStateException("Parent of " + file.getAbsolutePath() + " is still not existing!");
        }
        return EChange.CHANGED;
    }

    @Nullable
    public static File getCanonicalFile(@Nullable File file) throws IOException {
        return file == null ? null : file.getCanonicalFile();
    }

    @Nullable
    public static File getCanonicalFileOrNull(@Nullable File file) {
        if (file != null) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String getCanonicalPath(@Nullable File file) throws IOException {
        return file == null ? null : file.getCanonicalPath();
    }

    @Nullable
    public static String getCanonicalPathOrNull(@Nullable File file) {
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static boolean isParentDirectory(@Nonnull File file, @Nonnull File file2) {
        ValueEnforcer.notNull(file, "SearchDirectory");
        ValueEnforcer.notNull(file2, "StartDirectory");
        File file3 = file.getAbsoluteFile();
        File file4 = file2.getAbsoluteFile();
        try {
            file3 = FileHelper.getCanonicalFile(file3);
            file4 = FileHelper.getCanonicalFile(file4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file3.isDirectory()) {
            return false;
        }
        for (File file5 = file4; file5 != null; file5 = file5.getParentFile()) {
            if (!file5.equals(file3)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FileInputStream getInputStream(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        try {
            return new CountingFileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static NonBlockingBufferedInputStream getBufferedInputStream(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        if (fileInputStream == null) {
            return null;
        }
        return new NonBlockingBufferedInputStream(fileInputStream);
    }

    @Nullable
    public static InputStreamReader getReader(@Nonnull File file, @Nonnull Charset charset) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.createReader(FileHelper.getInputStream(file), charset);
    }

    @Nullable
    public static NonBlockingBufferedReader getBufferedReader(@Nonnull File file, @Nonnull Charset charset) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(charset, "Charset");
        InputStreamReader inputStreamReader = FileHelper.getReader(file, charset);
        if (inputStreamReader == null) {
            return null;
        }
        return new NonBlockingBufferedReader(inputStreamReader);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull File file) {
        return FileHelper.getOutputStream(file, EAppend.DEFAULT);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull File file, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(eAppend, "Append");
        if (FileHelper.internalCheckParentDirectoryExistanceAndAccess(file).isInvalid()) {
            return null;
        }
        try {
            return new CountingFileOutputStream(file, eAppend);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.warn("Failed to create output stream for '" + file + "'; append: " + eAppend + ": " + fileNotFoundException.getClass().getName() + " - " + fileNotFoundException.getMessage());
            return null;
        }
    }

    @Nullable
    public static NonBlockingBufferedOutputStream getBufferedOutputStream(@Nonnull File file) {
        return FileHelper.getBufferedOutputStream(file, EAppend.DEFAULT);
    }

    @Nullable
    public static NonBlockingBufferedOutputStream getBufferedOutputStream(@Nonnull File file, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(eAppend, "Append");
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file, eAppend);
        if (fileOutputStream == null) {
            return null;
        }
        return new NonBlockingBufferedOutputStream(fileOutputStream);
    }

    @Nullable
    public static OutputStreamWriter getWriter(@Nonnull File file, @Nonnull Charset charset) {
        return FileHelper.getWriter(file, EAppend.DEFAULT, charset);
    }

    @Nullable
    public static OutputStreamWriter getWriter(@Nonnull File file, @Nonnull EAppend eAppend, @Nonnull Charset charset) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.createWriter(FileHelper.getOutputStream(file, eAppend), charset);
    }

    @Nullable
    public static NonBlockingBufferedWriter getBufferedWriter(@Nonnull File file, @Nonnull Charset charset) {
        return FileHelper.getBufferedWriter(file, EAppend.DEFAULT, charset);
    }

    @Nullable
    public static NonBlockingBufferedWriter getBufferedWriter(@Nonnull File file, @Nonnull EAppend eAppend, @Nonnull Charset charset) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(charset, "Charset");
        OutputStreamWriter outputStreamWriter = FileHelper.getWriter(file, eAppend, charset);
        if (outputStreamWriter == null) {
            return null;
        }
        return new NonBlockingBufferedWriter(outputStreamWriter);
    }

    @Nullable
    public static PrintWriter getPrintWriter(@Nonnull File file, @Nonnull Charset charset) {
        return FileHelper.getPrintWriter(file, EAppend.DEFAULT, charset);
    }

    @Nullable
    public static PrintWriter getPrintWriter(@Nonnull File file, @Nonnull EAppend eAppend, @Nonnull Charset charset) {
        return new PrintWriter(FileHelper.getBufferedWriter(file, eAppend, charset));
    }

    @Nonnull
    static EValidity internalCheckParentDirectoryExistanceAndAccess(@Nonnull File file) {
        try {
            FileHelper.ensureParentDirectoryIsPresent(file);
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.warn("Failed to create parent directory of '" + file + "'", illegalStateException);
            return EValidity.INVALID;
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.canWrite()) {
            LOGGER.warn("Parent directory '" + file2 + "' of '" + file + "' is not writable for current user '" + SystemProperties.getUserName() + "'");
            return EValidity.INVALID;
        }
        return EValidity.VALID;
    }

    @Nullable
    public static RandomAccessFile getRandomAccessFile(@Nonnull String string, @Nonnull ERandomAccessFileMode eRandomAccessFileMode) {
        return FileHelper.getRandomAccessFile(new File(string), eRandomAccessFileMode);
    }

    @Nullable
    public static RandomAccessFile getRandomAccessFile(@Nonnull File file, @Nonnull ERandomAccessFileMode eRandomAccessFileMode) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(eRandomAccessFileMode, "Mode");
        try {
            return new RandomAccessFile(file, eRandomAccessFileMode.getMode());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static boolean isFileNewer(@Nonnull File file, @Nonnull File file2) {
        ValueEnforcer.notNull(file, "File1");
        ValueEnforcer.notNull(file2, "aFile2");
        if (file.equals(file2)) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file2.exists()) {
            return true;
        }
        return file.lastModified() > file2.lastModified();
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nullable File file) {
        return FileHelper.getFileSizeDisplay(file, 0);
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nullable File file, @Nonnegative int n) {
        if (file != null && file.exists()) {
            return FileHelper.getFileSizeDisplay(file.length(), n);
        }
        return "";
    }

    @Nonnull
    public static String getFileSizeDisplay(long l) {
        return FileHelper.getFileSizeDisplay(l, 0);
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nonnegative long l, @Nonnegative int n) {
        ValueEnforcer.isGE0(l, "FileSize");
        ValueEnforcer.isGE0(n, "Decimals");
        return SizeHelper.getSizeHelperOfLocale(Locale.ROOT).getAsMatching(l, n);
    }

    @Nullable
    public static File getSecureFile(@Nullable File file) {
        if (file == null) {
            return null;
        }
        String string = null;
        for (File file2 = new File(FilenameHelper.getCleanPath(file)); file2 != null; file2 = file2.getParentFile()) {
            String string2 = file2.getParent() == null ? file2.getPath() : FilenameHelper.getAsSecureValidFilename(file2.getName());
            string = string == null ? string2 : string2 + "/" + string;
        }
        return new File(string);
    }

    @Nonnegative
    public static int getDirectoryObjectCount(@Nonnull File file) {
        ValueEnforcer.notNull(file, "Directory");
        ValueEnforcer.isTrue(file.isDirectory(), "Passed object is not a directory: " + file);
        int n = 0;
        for (File file2 : FileHelper.getDirectoryContent(file)) {
            if (FilenameHelper.isSystemInternalDirectory(file2.getName())) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsList<File> _getDirectoryContent(@Nonnull File file, @Nullable File[] fileArray) {
        if (fileArray == null) {
            if (!file.isDirectory()) {
                LOGGER.warn("Cannot list non-directory: " + file.getAbsolutePath());
            } else if (!file.canExecute()) {
                LOGGER.warn("Existing directory is missing the listing permission: " + file.getAbsolutePath());
            } else if (!file.canRead()) {
                LOGGER.warn("Cannot list directory because of no read-rights: " + file.getAbsolutePath());
            } else {
                LOGGER.warn("Directory listing failed because of IO error: " + file.getAbsolutePath());
            }
        } else if (!file.canExecute()) {
            LOGGER.warn("Directory is missing the listing permission: " + file.getAbsolutePath());
        }
        return new CommonsArrayList<File>(fileArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<File> getDirectoryContent(@Nonnull File file) {
        ValueEnforcer.notNull(file, "Directory");
        return FileHelper._getDirectoryContent(file, file.listFiles());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<File> getDirectoryContent(@Nonnull File file, @Nonnull FilenameFilter filenameFilter) {
        ValueEnforcer.notNull(file, "Directory");
        ValueEnforcer.notNull(filenameFilter, "FilenameFilter");
        return FileHelper._getDirectoryContent(file, file.listFiles(filenameFilter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<File> getDirectoryContent(@Nonnull File file, @Nonnull FileFilter fileFilter) {
        ValueEnforcer.notNull(file, "Directory");
        ValueEnforcer.notNull(fileFilter, "FileFilter");
        return FileHelper._getDirectoryContent(file, file.listFiles(fileFilter));
    }

    @Nullable
    public static URL getAsURL(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Failed to convert file to URL: " + file, malformedURLException);
            return null;
        }
    }

    @Nullable
    public static String getAsURLString(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        try {
            return file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Failed to convert file to URL: " + file, malformedURLException);
            return null;
        }
    }
}

