/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.svrl.jaxb.FailedAssert;
import com.helger.schematron.svrl.jaxb.SuccessfulReport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface ISVRLErrorLevelDeterminator {
    @Nonnull
    public IErrorLevel getErrorLevelFromString(@Nullable String var1);

    @Nonnull
    default public IErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        ValueEnforcer.notNull(failedAssert, "FailedAssert");
        String string = failedAssert.getFlag();
        if (StringHelper.hasNoText(string)) {
            string = failedAssert.getRole();
        }
        return this.getErrorLevelFromString(string);
    }

    @Nonnull
    default public IErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        ValueEnforcer.notNull(successfulReport, "SuccessfulReport");
        String string = successfulReport.getFlag();
        if (StringHelper.hasNoText(string)) {
            string = successfulReport.getRole();
        }
        return this.getErrorLevelFromString(string);
    }
}

