/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.namespace;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.namespace.AbstractNamespaceContext;
import com.helger.xml.namespace.IIterableNamespaceContext;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedNamespaceContext
extends AbstractNamespaceContext
implements ICloneable<MapBasedNamespaceContext> {
    private String m_sDefaultNamespaceURI;
    private final ICommonsOrderedMap<String, String> m_aPrefix2NS = new CommonsLinkedHashMap<String, String>();
    private final ICommonsMap<String, ICommonsSet<String>> m_aNS2Prefix = new CommonsHashMap<String, ICommonsSet<String>>();

    public MapBasedNamespaceContext() {
    }

    public MapBasedNamespaceContext(@Nullable MapBasedNamespaceContext mapBasedNamespaceContext) {
        if (mapBasedNamespaceContext != null) {
            this.m_sDefaultNamespaceURI = mapBasedNamespaceContext.m_sDefaultNamespaceURI;
            this.m_aPrefix2NS.putAll(mapBasedNamespaceContext.m_aPrefix2NS);
            for (Map.Entry entry : mapBasedNamespaceContext.m_aNS2Prefix.entrySet()) {
                this.m_aNS2Prefix.put((String)entry.getKey(), (ICommonsSet)((ICommonsSet)entry.getValue()).getClone());
            }
        }
    }

    public MapBasedNamespaceContext(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        this.addMappings(iIterableNamespaceContext);
    }

    public MapBasedNamespaceContext(@Nullable Map<String, String> map) {
        this.addMappings(map);
    }

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sDefaultNamespaceURI;
    }

    @Nonnull
    private MapBasedNamespaceContext _addMapping(@Nonnull String string2, @Nonnull String string3, boolean bl) {
        ValueEnforcer.notNull(string2, "Prefix");
        ValueEnforcer.notNull(string3, "NamespaceURI");
        if (!bl && this.m_aPrefix2NS.containsKey(string2)) {
            throw new IllegalArgumentException("The prefix '" + string2 + "' is already registered to '" + (String)this.m_aPrefix2NS.get(string2) + "'!");
        }
        if (string2.equals("")) {
            this.m_sDefaultNamespaceURI = string3;
        }
        this.m_aPrefix2NS.put(string2, string3);
        this.m_aNS2Prefix.computeIfAbsent(string3, string -> new CommonsHashSet()).add(string2);
        return this;
    }

    @Nonnull
    public final MapBasedNamespaceContext addMapping(@Nonnull String string, @Nonnull String string2) {
        return this._addMapping(string, string2, false);
    }

    @Nonnull
    public final MapBasedNamespaceContext setMapping(@Nonnull String string, @Nonnull String string2) {
        return this._addMapping(string, string2, true);
    }

    @Nonnull
    public final MapBasedNamespaceContext addMappings(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        if (iIterableNamespaceContext != null) {
            this.addMappings(iIterableNamespaceContext.getPrefixToNamespaceURIMap());
        }
        return this;
    }

    @Nonnull
    public final MapBasedNamespaceContext setMappings(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        if (iIterableNamespaceContext != null) {
            this.setMappings(iIterableNamespaceContext.getPrefixToNamespaceURIMap());
        }
        return this;
    }

    @Nonnull
    public final MapBasedNamespaceContext addMappings(@Nullable Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addMapping(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public final MapBasedNamespaceContext setMappings(@Nullable Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.setMapping(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public final MapBasedNamespaceContext addDefaultNamespaceURI(@Nonnull String string) {
        return this.addMapping("", string);
    }

    @Nonnull
    public final MapBasedNamespaceContext setDefaultNamespaceURI(@Nonnull String string) {
        return this.setMapping("", string);
    }

    @Nonnull
    public MapBasedNamespaceContext removeMapping(@Nullable String string) {
        ICommonsSet iCommonsSet;
        String string2 = (String)this.m_aPrefix2NS.remove(string);
        if (string2 != null && ((iCommonsSet = (ICommonsSet)this.m_aNS2Prefix.get(string2)) == null || iCommonsSet.removeObject(string).isUnchanged())) {
            throw new IllegalStateException("Internal inconsistency removing '" + string + "' and '" + string2 + "'");
        }
        return this;
    }

    public boolean isPrefixMapped(@Nullable String string) {
        return this.m_aPrefix2NS.containsKey(string);
    }

    public boolean isNamespaceURIMapped(@Nullable String string) {
        return this.m_aNS2Prefix.containsKey(string);
    }

    @Nonnull
    public MapBasedNamespaceContext clear() {
        if (this.m_aPrefix2NS.isNotEmpty()) {
            this.m_aPrefix2NS.clear();
            this.m_aNS2Prefix.clear();
            this.m_sDefaultNamespaceURI = null;
        }
        return this;
    }

    @Override
    @Nullable
    public Iterator<String> getCustomPrefixes(@Nonnull String string) {
        ICommonsSet iCommonsSet = (ICommonsSet)this.m_aNS2Prefix.get(string);
        return iCommonsSet == null ? null : iCommonsSet.iterator();
    }

    @Override
    @Nullable
    public String getCustomPrefix(@Nonnull String string) {
        ICommonsSet iCommonsSet = (ICommonsSet)this.m_aNS2Prefix.get(string);
        return (String)CollectionHelper.getFirstElement(iCommonsSet);
    }

    @Override
    @Nullable
    public String getCustomNamespaceURI(@Nonnull String string) {
        return (String)this.m_aPrefix2NS.get(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getPrefixToNamespaceURIMap() {
        return this.m_aPrefix2NS.getClone();
    }

    public boolean hasAnyMapping() {
        return this.m_aPrefix2NS.isNotEmpty();
    }

    @Nonnegative
    public int getMappingCount() {
        return this.m_aPrefix2NS.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedNamespaceContext getClone() {
        return new MapBasedNamespaceContext(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedNamespaceContext mapBasedNamespaceContext = (MapBasedNamespaceContext)object;
        return EqualsHelper.equals(this.m_sDefaultNamespaceURI, mapBasedNamespaceContext.m_sDefaultNamespaceURI) && this.m_aPrefix2NS.equals(mapBasedNamespaceContext.m_aPrefix2NS) && this.m_aNS2Prefix.equals(mapBasedNamespaceContext.m_aNS2Prefix);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sDefaultNamespaceURI).append(this.m_aPrefix2NS)).append(this.m_aNS2Prefix)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("defaultNS", this.m_sDefaultNamespaceURI).append("prefix2NS", this.m_aPrefix2NS).append("ns2Prefix2", this.m_aNS2Prefix).getToString();
    }
}

