/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.xml.EXMLVersion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EXMLSerializeVersion implements IHasID<String>
{
    XML_10("xml10", EXMLVersion.XML_10),
    XML_11("xml11", EXMLVersion.XML_11),
    HTML("html", null);

    private final String m_sID;
    private final EXMLVersion m_eXMLVersion;

    private EXMLSerializeVersion(String string2, EXMLVersion eXMLVersion) {
        this.m_sID = string2;
        this.m_eXMLVersion = eXMLVersion;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    public boolean isXML() {
        return this == XML_10 || this == XML_11;
    }

    public boolean isHTML() {
        return this == HTML;
    }

    @Nullable
    public EXMLVersion getXMLVersionOrDefault(@Nullable EXMLVersion eXMLVersion) {
        return this.m_eXMLVersion == null ? eXMLVersion : this.m_eXMLVersion;
    }

    @Nullable
    public String getXMLVersionString() {
        return this.m_eXMLVersion == null ? null : this.m_eXMLVersion.getVersion();
    }

    @Nonnull
    public static EXMLSerializeVersion getFromXMLVersionOrThrow(@Nonnull EXMLVersion eXMLVersion) {
        switch (eXMLVersion) {
            case XML_10: {
                return XML_10;
            }
            case XML_11: {
                return XML_11;
            }
        }
        throw new IllegalStateException("Unsupported XML version " + eXMLVersion);
    }

    @Nullable
    public static EXMLSerializeVersion getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EXMLSerializeVersion.class, string);
    }
}

