/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mustangproject.ZUGFeRD.IAbsoluteValueProvider;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;

public class TransactionCalculator
implements IAbsoluteValueProvider {
    protected IExportableTransaction trans;

    public TransactionCalculator(IExportableTransaction trans) {
        this.trans = trans;
    }

    protected BigDecimal getTotalPrepaid() {
        if (this.trans.getTotalPrepaidAmount() == null) {
            return BigDecimal.ZERO;
        }
        return this.trans.getTotalPrepaidAmount().setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getGrandTotal() {
        BigDecimal basis = this.getTaxBasis();
        return this.getVATPercentAmountMap().values().stream().map(VATAmount::getCalculated).map(p -> p.setScale(2, RoundingMode.HALF_UP)).reduce(BigDecimal.ZERO, BigDecimal::add).add(basis);
    }

    protected BigDecimal getChargesForPercent(BigDecimal percent) {
        IZUGFeRDAllowanceCharge[] charges = this.trans.getZFCharges();
        return this.sumAllowanceCharge(percent, charges);
    }

    private BigDecimal sumAllowanceCharge(BigDecimal percent, IZUGFeRDAllowanceCharge[] charges) {
        BigDecimal res = BigDecimal.ZERO;
        if (charges != null && charges.length > 0) {
            for (IZUGFeRDAllowanceCharge currentCharge : charges) {
                if (percent != null && currentCharge.getTaxPercent().compareTo(percent) != 0) continue;
                res = res.add(currentCharge.getTotalAmount(this));
            }
        }
        return res;
    }

    protected String getChargeReasonForPercent(BigDecimal percent) {
        IZUGFeRDAllowanceCharge[] charges = this.trans.getZFCharges();
        String res = this.getAllowanceChargeReasonForPercent(percent, charges);
        if ("".equals(res)) {
            res = "Charges";
        }
        return res;
    }

    private String getAllowanceChargeReasonForPercent(BigDecimal percent, IZUGFeRDAllowanceCharge[] charges) {
        if (charges == null) {
            return "";
        }
        return Arrays.stream(charges).filter(currentCharge -> percent == null || currentCharge.getTaxPercent().compareTo(percent) == 0).map(IZUGFeRDAllowanceCharge::getReason).filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    protected String getAllowanceReasonForPercent(BigDecimal percent) {
        IZUGFeRDAllowanceCharge[] allowances = this.trans.getZFAllowances();
        String res = this.getAllowanceChargeReasonForPercent(percent, allowances);
        if ("".equals(res)) {
            res = "Allowances";
        }
        return res;
    }

    protected BigDecimal getAllowancesForPercent(BigDecimal percent) {
        IZUGFeRDAllowanceCharge[] allowances = this.trans.getZFAllowances();
        return this.sumAllowanceCharge(percent, allowances);
    }

    protected BigDecimal getTotal() {
        BigDecimal dec = Stream.of(this.trans.getZFItems()).map(LineCalculator::new).map(LineCalculator::getItemTotalNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return dec;
    }

    public BigDecimal getTaxBasis() {
        return this.getTotal().add(this.getChargesForPercent(null).setScale(2, RoundingMode.HALF_UP)).subtract(this.getAllowancesForPercent(null).setScale(2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
    }

    protected HashMap<BigDecimal, VATAmount> getVATPercentAmountMap() {
        IZUGFeRDAllowanceCharge[] allowances;
        HashMap<BigDecimal, VATAmount> hm = new HashMap<BigDecimal, VATAmount>();
        String vatDueDateTypeCode = this.trans.getVATDueDateTypeCode();
        for (IZUGFeRDExportableItem currentItem : this.trans.getZFItems()) {
            VATAmount current;
            BigDecimal percent = null;
            if (currentItem.getProduct() != null) {
                percent = currentItem.getProduct().getVATPercent();
            }
            if (percent == null) continue;
            LineCalculator lc = new LineCalculator(currentItem);
            VATAmount itemVATAmount = new VATAmount(lc.getItemTotalNetAmount(), lc.getItemTotalVATAmount(), currentItem.getProduct().getTaxCategoryCode(), vatDueDateTypeCode);
            String reasonText = currentItem.getProduct().getTaxExemptionReason();
            if (reasonText != null) {
                itemVATAmount.setVatExemptionReasonText(reasonText);
            }
            if ((current = hm.get(percent.stripTrailingZeros())) == null) {
                hm.put(percent.stripTrailingZeros(), itemVATAmount);
                continue;
            }
            hm.put(percent.stripTrailingZeros(), current.add(itemVATAmount));
        }
        IZUGFeRDAllowanceCharge[] charges = this.trans.getZFCharges();
        if (charges != null && charges.length > 0) {
            for (IZUGFeRDAllowanceCharge currentCharge : charges) {
                BigDecimal taxPercent = currentCharge.getTaxPercent();
                if (taxPercent == null) continue;
                VATAmount theAmount = hm.get(taxPercent.stripTrailingZeros());
                if (theAmount == null) {
                    theAmount = new VATAmount(BigDecimal.ZERO, BigDecimal.ZERO, currentCharge.getCategoryCode() != null ? currentCharge.getCategoryCode() : "S", vatDueDateTypeCode);
                }
                theAmount.setBasis(theAmount.getBasis().add(currentCharge.getTotalAmount(this)));
                BigDecimal factor = taxPercent.divide(new BigDecimal(100));
                theAmount.setCalculated(theAmount.getBasis().multiply(factor));
                hm.put(taxPercent.stripTrailingZeros(), theAmount);
            }
        }
        if ((allowances = this.trans.getZFAllowances()) != null && allowances.length > 0) {
            for (IZUGFeRDAllowanceCharge currentAllowance : allowances) {
                BigDecimal taxPercent = currentAllowance.getTaxPercent();
                if (taxPercent == null) continue;
                VATAmount theAmount = hm.get(taxPercent.stripTrailingZeros());
                if (theAmount == null) {
                    theAmount = new VATAmount(BigDecimal.ZERO, BigDecimal.ZERO, currentAllowance.getCategoryCode() != null ? currentAllowance.getCategoryCode() : "S", vatDueDateTypeCode);
                }
                theAmount.setBasis(theAmount.getBasis().subtract(currentAllowance.getTotalAmount(this)));
                BigDecimal factor = taxPercent.divide(new BigDecimal(100));
                theAmount.setCalculated(theAmount.getBasis().multiply(factor));
                hm.put(taxPercent.stripTrailingZeros(), theAmount);
            }
        }
        return hm;
    }

    @Override
    public BigDecimal getValue() {
        return this.getTotal();
    }

    public BigDecimal getChargeTotal() {
        return this.getChargesForPercent(null).setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getAllowanceTotal() {
        return this.getAllowancesForPercent(null).setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getDuePayable() {
        BigDecimal res = this.getGrandTotal().subtract(this.getTotalPrepaid());
        if (this.trans.getRoundingAmount() != null) {
            res = res.add(this.trans.getRoundingAmount());
        }
        return res;
    }
}

