/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.mustangproject.validator.EPart;
import org.mustangproject.validator.ESeverity;
import org.mustangproject.validator.IrrecoverableValidationError;
import org.mustangproject.validator.ValidationContext;
import org.mustangproject.validator.ValidationResultItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Validator.class.getCanonicalName());
    protected ValidationContext context;
    protected boolean autoload = true;

    public Validator(ValidationContext ctx) {
        this.context = ctx;
    }

    public abstract void setFilename(String var1) throws IrrecoverableValidationError;

    public abstract void validate() throws IrrecoverableValidationError;

    public String getXMLResult() {
        return this.context.getXMLResult();
    }

    protected void validateSchema(byte[] xmlRawData, String schemaPath, int section, EPart part) throws IrrecoverableValidationError {
        URL schemaFile = Thread.currentThread().getContextClassLoader().getResource("schema/" + schemaPath);
        StreamSource xmlData = new StreamSource(new ByteArrayInputStream(xmlRawData));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(schemaFile);
            javax.xml.validation.Validator validator = schema.newValidator();
            validator.validate(xmlData);
        }
        catch (SAXException e) {
            this.context.addResultItem(new ValidationResultItem(ESeverity.error, "schema validation fails:" + e).setSection(section).setPart(part));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    public ValidationContext getValidationContext() {
        return this.context;
    }

    public void setAutoload(boolean autoload) {
        this.autoload = autoload;
    }
}

