/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.ASFilterFactory;
import org.verapdf.as.filters.ASInFilter;
import org.verapdf.as.filters.ASOutFilter;
import org.verapdf.as.filters.IASFilterFactory;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASOutputStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.exceptions.VeraPDFParserException;

public class COSFilterRegistry {
    private static final Map<ASAtom, IASFilterFactory> registeredFactories;
    private static final Logger LOGGER;

    private COSFilterRegistry() {
    }

    private static IASFilterFactory factoryByName(ASAtom name) {
        return registeredFactories.get(name);
    }

    private static void registerFactory(ASAtom filterName, IASFilterFactory factory) throws VeraPDFParserException {
        if (registeredFactories.containsKey(filterName)) {
            throw new VeraPDFParserException("internal library error");
        }
        registeredFactories.put(filterName, factory);
    }

    public static ASInputStream getDecodeFilter(ASAtom filterName, ASInputStream inputStream, COSDictionary decodeParams) throws IOException {
        if (ASAtom.CRYPT.equals(filterName) && ASAtom.IDENTITY.equals(decodeParams.getNameKey(ASAtom.NAME))) {
            return inputStream;
        }
        IASFilterFactory filterFactory = COSFilterRegistry.factoryByName(filterName);
        if (filterFactory != null) {
            return filterFactory.getInFilter(inputStream, decodeParams);
        }
        LOGGER.log(Level.SEVERE, "Unknown decode filter");
        return new ASInFilter(inputStream){

            @Override
            public int read() {
                return -1;
            }
        };
    }

    public static ASOutFilter getEncodeFilter(ASAtom filterName, ASOutputStream outputStream) throws IOException {
        IASFilterFactory filterFactory = COSFilterRegistry.factoryByName(filterName);
        if (filterFactory != null) {
            return filterFactory.getOutFilter(outputStream);
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(COSFilterRegistry.class.getCanonicalName());
        registeredFactories = new HashMap<ASAtom, IASFilterFactory>();
        try {
            COSFilterRegistry.registerFactory(ASAtom.FLATE_DECODE, new ASFilterFactory(ASAtom.FLATE_DECODE));
            COSFilterRegistry.registerFactory(ASAtom.ASCII_HEX_DECODE, new ASFilterFactory(ASAtom.ASCII_HEX_DECODE));
            COSFilterRegistry.registerFactory(ASAtom.ASCII85_DECODE, new ASFilterFactory(ASAtom.ASCII85_DECODE));
            COSFilterRegistry.registerFactory(ASAtom.LZW_DECODE, new ASFilterFactory(ASAtom.LZW_DECODE));
        }
        catch (VeraPDFParserException e) {
            LOGGER.log(Level.FINE, "Trying to register factory twice", e);
        }
    }
}

