/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.objects.FontFeaturesObjectAdapter;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.font.PDCIDFont;
import org.verapdf.pd.font.PDCIDSystemInfo;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDFontDescriptor;
import org.verapdf.pd.font.type3.PDType3Font;

public class GFFontFeaturesObjectAdapter
implements FontFeaturesObjectAdapter {
    private final PDFont font;
    private final String id;
    private final Set<String> extGStateChild;
    private final Set<String> colorSpaceChild;
    private final Set<String> patternChild;
    private final Set<String> shadingChild;
    private final Set<String> xobjectChild;
    private final Set<String> fontChild;
    private final Set<String> propertiesChild;
    private FontFeaturesObjectAdapter.FontDescriptorAdapter fontDescriptorAdapter;

    public GFFontFeaturesObjectAdapter(PDFont font, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.font = font;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        if (font != null && !font.empty()) {
            PDFontDescriptor descriptor = this.font.getFontDescriptor();
            this.fontDescriptorAdapter = descriptor != null && !descriptor.empty() ? new GFFontDescriptorAdapter(descriptor) : null;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getExtGStateChild() {
        return this.extGStateChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.extGStateChild);
    }

    @Override
    public Set<String> getColorSpaceChild() {
        return this.colorSpaceChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.colorSpaceChild);
    }

    @Override
    public Set<String> getPatternChild() {
        return this.patternChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.patternChild);
    }

    @Override
    public Set<String> getShadingChild() {
        return this.shadingChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.shadingChild);
    }

    @Override
    public Set<String> getXObjectChild() {
        return this.xobjectChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.xobjectChild);
    }

    @Override
    public Set<String> getFontChild() {
        return this.fontChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.fontChild);
    }

    @Override
    public Set<String> getPropertiesChild() {
        return this.propertiesChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.propertiesChild);
    }

    @Override
    public String getType() {
        if (this.font != null && !this.font.empty()) {
            ASAtom subtype = this.font.getSubtype();
            return subtype == null ? null : subtype.getValue();
        }
        return null;
    }

    @Override
    public String getBaseFont() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getName();
        }
        return null;
    }

    @Override
    public Long getFirstChar() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getFirstChar();
        }
        return null;
    }

    @Override
    public Long getLastChar() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getLastChar();
        }
        return null;
    }

    @Override
    public String getEncoding() {
        if (this.font != null && !this.font.empty()) {
            COSObject enc = this.font.getEncoding();
            if (enc.getType() == COSObjType.COS_NAME) {
                return enc.getString();
            }
            if (enc.getType() == COSObjType.COS_DICT) {
                return enc.getNameKeyStringValue(ASAtom.BASE_ENCODING);
            }
        }
        return null;
    }

    @Override
    public double[] getBoundingBox() {
        if (this.font != null && !this.font.empty() && this.font.getSubtype() == ASAtom.TYPE3) {
            PDType3Font type3 = (PDType3Font)this.font;
            return type3.getFontBoundingBox();
        }
        return null;
    }

    @Override
    public double[] getMatrix() {
        if (this.font != null && !this.font.empty() && this.font.getSubtype() == ASAtom.TYPE3) {
            PDType3Font type3 = (PDType3Font)this.font;
            return type3.getFontMatrix();
        }
        return null;
    }

    @Override
    public boolean isCIDSystemInfoPresent() {
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2)) {
            PDCIDFont cid = (PDCIDFont)this.font;
            PDCIDSystemInfo cidSystemInfo = cid.getCIDSystemInfo();
            return cidSystemInfo != null;
        }
        return false;
    }

    @Override
    public Double getDefaultWidth() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getDefaultWidth();
        }
        return null;
    }

    @Override
    public String getCIDSysInfoRegistry() {
        PDCIDFont cid;
        PDCIDSystemInfo cidSystemInfo;
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2 || (cidSystemInfo = (cid = (PDCIDFont)this.font).getCIDSystemInfo()) == null)) {
            return cidSystemInfo.getRegistry();
        }
        return null;
    }

    @Override
    public String getCIDSysInfoOrdering() {
        PDCIDFont cid;
        PDCIDSystemInfo cidSystemInfo;
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2 || (cidSystemInfo = (cid = (PDCIDFont)this.font).getCIDSystemInfo()) == null)) {
            return cidSystemInfo.getOrdering();
        }
        return null;
    }

    @Override
    public Long getCIDSysInfoSupplement() {
        PDCIDFont cid;
        PDCIDSystemInfo cidSystemInfo;
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2 || (cidSystemInfo = (cid = (PDCIDFont)this.font).getCIDSystemInfo()) == null)) {
            return cidSystemInfo.getSupplement();
        }
        return null;
    }

    @Override
    public FontFeaturesObjectAdapter.FontDescriptorAdapter getFontDescriptor() {
        return this.fontDescriptorAdapter;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.font != null && !this.font.empty();
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private static class GFFontDescriptorAdapter
    implements FontFeaturesObjectAdapter.FontDescriptorAdapter {
        private final PDFontDescriptor descriptor;
        private COSStream file;
        private PDMetadata metadata;

        GFFontDescriptorAdapter(PDFontDescriptor descriptor) {
            this.descriptor = descriptor;
            this.file = descriptor.getFontFile();
            if (this.file == null) {
                this.file = descriptor.getFontFile2();
            }
            if (this.file == null) {
                this.file = descriptor.getFontFile3();
            }
            if (this.file != null) {
                this.metadata = new PDMetadata(this.file.getKey(ASAtom.METADATA));
            }
        }

        @Override
        public String getFontName() {
            ASAtom fontName = this.descriptor.getFontName();
            return fontName == null ? null : fontName.getValue();
        }

        @Override
        public String getFontFamily() {
            return this.descriptor.getFontFamily();
        }

        @Override
        public String getFontStretch() {
            ASAtom fontStretch = this.descriptor.getFontStretch();
            return fontStretch == null ? null : fontStretch.getValue();
        }

        @Override
        public Double getFontWeight() {
            return this.descriptor.getFontWeight();
        }

        @Override
        public boolean isFixedPitch() {
            return this.descriptor.isFixedPitch();
        }

        @Override
        public boolean isSerif() {
            return this.descriptor.isSerif();
        }

        @Override
        public boolean isSymbolic() {
            return this.descriptor.isSymbolic();
        }

        @Override
        public boolean isScript() {
            return this.descriptor.isScript();
        }

        @Override
        public boolean isNonSymbolic() {
            return this.descriptor.isNonsymbolic();
        }

        @Override
        public boolean isItalic() {
            return this.descriptor.isItalic();
        }

        @Override
        public boolean isAllcap() {
            return this.descriptor.isAllCap();
        }

        @Override
        public boolean isSmallCap() {
            return this.descriptor.isSmallCap();
        }

        @Override
        public boolean isForceBold() {
            return this.descriptor.isForceBold();
        }

        @Override
        public double[] getFontBoundingBox() {
            return this.descriptor.getFontBoundingBox();
        }

        @Override
        public Double getItalicAngle() {
            return this.descriptor.getItalicAngle();
        }

        @Override
        public Double getAscent() {
            return this.descriptor.getAscent();
        }

        @Override
        public Double getDescent() {
            return this.descriptor.getDescent();
        }

        @Override
        public Double getLeading() {
            return this.descriptor.getLeading();
        }

        @Override
        public Double getCapHeight() {
            return this.descriptor.getCapHeight();
        }

        @Override
        public Double getXHeight() {
            return this.descriptor.getXHeight();
        }

        @Override
        public Double getStemV() {
            return this.descriptor.getStemV();
        }

        @Override
        public Double getStemH() {
            return this.descriptor.getStemH();
        }

        @Override
        public Double getAverageWidth() {
            return this.descriptor.getAvgWidth();
        }

        @Override
        public Double getMaxWidth() {
            return this.descriptor.getMaxWidth();
        }

        @Override
        public Double getMissingWidth() {
            return this.descriptor.getMissingWidth();
        }

        @Override
        public String getCharSet() {
            return this.descriptor.getCharSet();
        }

        @Override
        public boolean isEmbedded() {
            return this.file != null;
        }

        @Override
        public Long getFlags() {
            return this.descriptor.getFlags();
        }

        @Override
        public InputStream getMetadataStream() {
            return this.metadata == null || this.metadata.empty() ? null : this.metadata.getStream();
        }

        @Override
        public InputStream getData() {
            return this.file == null ? null : this.file.getData(COSStream.FilterFlags.DECODE);
        }
    }
}

