/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.pd.font.cmap.CIDInterval;
import org.verapdf.pd.font.cmap.CIDMappable;
import org.verapdf.pd.font.cmap.CMapParser;
import org.verapdf.pd.font.cmap.CodeSpace;
import org.verapdf.pd.font.cmap.NotDefInterval;
import org.verapdf.pd.font.cmap.SingleCIDMapping;
import org.verapdf.pd.font.cmap.ToUnicodeInterval;

public class CMap {
    private static final Logger LOGGER = Logger.getLogger(CMap.class.getCanonicalName());
    private int wMode = 0;
    private String registry;
    private String ordering;
    private int supplement;
    private String name;
    private boolean usesNonPredefinedCMap = false;
    int shortestCodeSpaceLength;
    private final List<CIDMappable> cidMappings = new LinkedList<CIDMappable>();
    private List<CodeSpace> codeSpaces = new ArrayList<CodeSpace>();
    private final List<CIDMappable> notDefMappings = new ArrayList<CIDMappable>();
    private final Map<Integer, String> toUnicode = new HashMap<Integer, String>();
    private final List<ToUnicodeInterval> unicodeIntervals = new ArrayList<ToUnicodeInterval>();

    public CMap() {
        this.shortestCodeSpaceLength = Integer.MAX_VALUE;
    }

    public int toCID(int character) {
        int res;
        for (CIDMappable cidMapping : this.cidMappings) {
            res = cidMapping.getCID(character);
            if (res == -1) continue;
            return res;
        }
        for (CIDMappable notDefMapping : this.notDefMappings) {
            res = notDefMapping.getCID(character);
            if (res == -1) continue;
            return res;
        }
        return 0;
    }

    public boolean containsCode(int character) {
        int res;
        for (CIDMappable cidMapping : this.cidMappings) {
            res = cidMapping.getCID(character);
            if (res == -1) continue;
            return true;
        }
        for (CIDMappable notDefMapping : this.notDefMappings) {
            res = notDefMapping.getCID(character);
            if (res == -1) continue;
            return true;
        }
        return false;
    }

    public int getCodeFromStream(InputStream stream) throws IOException {
        byte[] charCode = new byte[5];
        byte[] temp = new byte[1];
        int previousShortestMatchingCodeSpaceLength = this.shortestCodeSpaceLength;
        for (int i = 0; i <= 4; ++i) {
            temp[0] = (byte)stream.read();
            System.arraycopy(temp, 0, charCode, i, 1);
            byte[] currentCode = Arrays.copyOf(charCode, i + 1);
            for (CodeSpace codeSpace : this.codeSpaces) {
                if (!codeSpace.contains(currentCode)) continue;
                int res = (int)CMapParser.numberFromBytes(currentCode);
                if (res != -1) {
                    return res;
                }
                LOGGER.log(Level.FINE, "CMap " + this.name + " has invalid codespace information.");
            }
            int shortestMatchingCodeSpaceLength = Integer.MAX_VALUE;
            for (CodeSpace codeSpace3 : this.codeSpaces) {
                boolean partialMatch = true;
                for (int j = 0; j <= i; ++j) {
                    if (codeSpace3.isPartialMatch(charCode[j], j)) continue;
                    partialMatch = false;
                    break;
                }
                if (!partialMatch || shortestMatchingCodeSpaceLength <= codeSpace3.getLength()) continue;
                shortestMatchingCodeSpaceLength = codeSpace3.getLength();
            }
            if (shortestMatchingCodeSpaceLength == Integer.MAX_VALUE && !this.codeSpaces.isEmpty()) {
                byte[] byArray = new byte[previousShortestMatchingCodeSpaceLength - i - 1];
                stream.read(byArray);
                System.arraycopy(byArray, 0, charCode, 0, byArray.length);
                return 0;
            }
            previousShortestMatchingCodeSpaceLength = shortestMatchingCodeSpaceLength;
        }
        return 0;
    }

    public void useCMap(CMap another) {
        this.cidMappings.addAll(another.cidMappings);
        this.codeSpaces.addAll(another.codeSpaces);
        this.notDefMappings.addAll(another.notDefMappings);
        this.toUnicode.putAll(another.toUnicode);
    }

    public int getwMode() {
        return this.wMode;
    }

    void setwMode(int wMode) {
        this.wMode = wMode;
    }

    public String getRegistry() {
        return this.registry;
    }

    void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    public boolean isUsesNonPredefinedCMap() {
        return this.usesNonPredefinedCMap;
    }

    void setName(String name) {
        this.name = name;
    }

    void setCodeSpaces(List<CodeSpace> codeSpaces) {
        this.codeSpaces = codeSpaces;
    }

    public void setUsesNonPredefinedCMap(boolean usesNonPredefinedCMap) {
        this.usesNonPredefinedCMap = usesNonPredefinedCMap;
    }

    void addUnicodeMapping(int code, String toUnicodeMap) {
        this.toUnicode.put(code, toUnicodeMap);
    }

    public String getUnicode(int code) {
        String res = this.toUnicode.get(code);
        if (res == null) {
            for (ToUnicodeInterval interval : this.unicodeIntervals) {
                if (!interval.containsCode(code)) continue;
                return interval.toUnicode(code);
            }
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    void addNotDefInterval(NotDefInterval interval) {
        this.notDefMappings.add(interval);
    }

    List<CodeSpace> getCodeSpaces() {
        return this.codeSpaces;
    }

    void addCidInterval(CIDInterval interval) {
        this.cidMappings.add(0, interval);
    }

    void addSingleCidMapping(SingleCIDMapping mapping) {
        this.cidMappings.add(0, mapping);
    }

    void addSingleNotDefMapping(SingleCIDMapping mapping) {
        this.notDefMappings.add(mapping);
    }

    void addUnicodeInterval(ToUnicodeInterval interval) {
        this.unicodeIntervals.add(interval);
    }

    public List<CIDMappable> getCidMappings() {
        return this.cidMappings;
    }
}

