/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.pd.font.truetype.TrueTypeBaseParser;
import org.verapdf.pd.font.truetype.TrueTypeCmapSubtable;
import org.verapdf.pd.font.truetype.TrueTypeCmapTable;
import org.verapdf.pd.font.truetype.TrueTypeHeadTable;
import org.verapdf.pd.font.truetype.TrueTypeHheaTable;
import org.verapdf.pd.font.truetype.TrueTypeHmtxTable;
import org.verapdf.pd.font.truetype.TrueTypeMaxpTable;
import org.verapdf.pd.font.truetype.TrueTypePostTable;

class TrueTypeFontParser
extends TrueTypeBaseParser {
    private static final Logger LOGGER = Logger.getLogger(TrueTypeFontParser.class.getCanonicalName());
    private static final long HHEA = 1751672161L;
    private static final long HMTX = 1752003704L;
    private static final long CMAP = 1668112752L;
    private static final long HEAD = 1751474532L;
    private static final long POST = 1886352244L;
    private static final long MAXP = 1835104368L;
    private int numTables;
    private TrueTypeHeadTable headParser;
    private TrueTypeHheaTable hheaParser;
    private TrueTypeHmtxTable hmtxParser;
    private TrueTypeCmapTable cmapParser;
    private TrueTypePostTable postParser;
    private TrueTypeMaxpTable maxpParser;

    TrueTypeFontParser(ASInputStream source) throws IOException {
        super(source);
    }

    void readHeader() throws IOException {
        this.source.skip(4);
        this.numTables = this.readUShort();
        this.source.skip(6);
    }

    void readTableDirectory() throws IOException {
        for (int i = 0; i < this.numTables; ++i) {
            long tabName = this.readULong();
            this.readULong();
            long offset = this.readULong();
            long length = this.readULong();
            if (tabName == 1668112752L) {
                this.cmapParser = new TrueTypeCmapTable(this.source, offset);
                continue;
            }
            if (tabName == 1751672161L) {
                this.hheaParser = new TrueTypeHheaTable(this.source, offset);
                continue;
            }
            if (tabName == 1752003704L) {
                this.hmtxParser = new TrueTypeHmtxTable(this.source, offset);
                continue;
            }
            if (tabName == 1751474532L) {
                this.headParser = new TrueTypeHeadTable(this.source, offset);
                continue;
            }
            if (tabName == 1886352244L) {
                this.postParser = new TrueTypePostTable(this.source, offset, length);
                continue;
            }
            if (tabName != 1835104368L) continue;
            this.maxpParser = new TrueTypeMaxpTable(this.source, offset);
        }
    }

    void readTables() throws IOException {
        if (this.headParser != null) {
            this.headParser.readTable();
        } else {
            LOGGER.log(Level.FINE, "True type font doesn't contain head table. Default value for unitsPerEm used.");
            this.headParser = new TrueTypeHeadTable();
        }
        if (this.hheaParser == null) {
            throw new IOException("True type font doesn't contain hhea table.");
        }
        this.hheaParser.readTable();
        if (this.hmtxParser == null) {
            throw new IOException("True type font doesn't contain hmtx table.");
        }
        this.hmtxParser.setNumberOfHMetrics(this.hheaParser.getNumberOfHMetrics());
        this.hmtxParser.readTable();
        if (this.cmapParser != null) {
            this.cmapParser.readTable();
        } else {
            LOGGER.log(Level.FINE, "True type font doesn't contain cmap table.");
        }
        if (this.maxpParser != null) {
            this.maxpParser.readTable();
        } else {
            this.maxpParser = new TrueTypeMaxpTable(this.hmtxParser.getLongHorMetrics().length);
            LOGGER.log(Level.FINE, "True type font doesn't contain maxp table. Default value for numGlyphs used.");
        }
        if (this.postParser != null) {
            this.postParser.setNumGlyphs(this.maxpParser.getNumGlyphs());
            this.postParser.readTable();
        } else {
            LOGGER.log(Level.FINE, "True type font doesn't contain post table.");
        }
    }

    TrueTypeHeadTable getHeadParser() {
        return this.headParser;
    }

    TrueTypeHmtxTable getHmtxParser() {
        return this.hmtxParser;
    }

    TrueTypeCmapTable getCmapParser() {
        return this.cmapParser;
    }

    TrueTypePostTable getPostParser() {
        return this.postParser;
    }

    TrueTypeMaxpTable getMaxpParser() {
        return this.maxpParser;
    }

    TrueTypeCmapSubtable getCmapTable(int platformID, int encodingID) {
        if (this.cmapParser != null) {
            for (TrueTypeCmapSubtable ttci : this.cmapParser.getCmapInfos()) {
                if (ttci.getPlatformID() != platformID || ttci.getEncodingID() != encodingID) continue;
                return ttci;
            }
        }
        return null;
    }

    TrueTypeHheaTable getHheaParser() {
        return this.hheaParser;
    }
}

