/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.pd.PDObject;

public class PDNumberTreeNode
extends PDObject
implements Iterable<COSObject> {
    public PDNumberTreeNode(COSObject obj) {
        super(obj);
    }

    public long[] getLimitsArray() {
        COSObject limits = this.getKey(ASAtom.LIMITS);
        if (limits != null && !limits.empty() && limits.getType() == COSObjType.COS_ARRAY && limits.size() >= 2 && limits.at(0).getType() == COSObjType.COS_INTEGER && limits.at(1).getType() == COSObjType.COS_INTEGER) {
            long[] res = new long[]{limits.at(0).getInteger(), limits.at(1).getInteger()};
            return res;
        }
        return null;
    }

    public List<PDNumberTreeNode> getKids() {
        COSObject kids = this.getKey(ASAtom.KIDS);
        if (kids != null && !kids.empty() && kids.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDNumberTreeNode> res = new ArrayList<PDNumberTreeNode>(kids.size());
            for (COSObject obj : (COSArray)kids.get()) {
                res.add(new PDNumberTreeNode(obj));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public Map<Long, COSObject> getNums() {
        COSObject nums = this.getKey(ASAtom.NUMS);
        if (nums != null && !nums.empty() && nums.getType() == COSObjType.COS_ARRAY) {
            HashMap<Long, COSObject> res = new HashMap<Long, COSObject>();
            for (int i = 0; i < nums.size() - 1; i += 2) {
                COSObject key = nums.at(i);
                if (key.getType() != COSObjType.COS_INTEGER) continue;
                COSObject value = nums.at(i + 1);
                res.put(key.getInteger(), value);
            }
            return Collections.unmodifiableMap(res);
        }
        return Collections.emptyMap();
    }

    private List<COSObject> getObjects() {
        LinkedList<COSObject> result = new LinkedList<COSObject>(this.getNums().values());
        for (PDNumberTreeNode kid : this.getKids()) {
            result.addAll(kid.getObjects());
        }
        return result;
    }

    public COSObject getObject(Long key) {
        HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
        COSKey objectKey = this.getObject().getObjectKey();
        if (objectKey != null) {
            visitedKeys.add(objectKey);
        }
        return this.getObject(key, visitedKeys);
    }

    private COSObject getObject(Long key, Set<COSKey> visitedKeys) {
        List<PDNumberTreeNode> kids;
        long[] limits = this.getLimitsArray();
        if (limits != null && (key < limits[0] || key > limits[1])) {
            return null;
        }
        if (this.knownKey(ASAtom.NUMS)) {
            Map<Long, COSObject> nums = this.getNums();
            return nums == null ? null : nums.get(key);
        }
        if (this.knownKey(ASAtom.KIDS) && (kids = this.getKids()) != null) {
            for (PDNumberTreeNode kid : kids) {
                COSObject res;
                COSKey kidObjectKey = kid.getObject().getObjectKey();
                if (kidObjectKey != null) {
                    if (visitedKeys.contains(kidObjectKey)) {
                        throw new LoopedException("Loop inside number tree");
                    }
                    visitedKeys.add(kidObjectKey);
                }
                if ((res = kid.getObject(key, visitedKeys)) == null) continue;
                return res;
            }
        }
        return null;
    }

    @Override
    public Iterator<COSObject> iterator() {
        return this.getObjects().iterator();
    }

    public Long size() {
        long i = 0L;
        Iterator<COSObject> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        return i;
    }
}

