/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.asm.typehierarchy;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchyReader;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;

public class TypeHierarchy {
    private static final List<Type> IMPLEMENTS_NO_INTERFACES = Collections.emptyList();
    private static final List<Type> IMPLICIT_ARRAY_INTERFACES = Collections.unmodifiableList(Arrays.asList(Type.getType(Cloneable.class), Type.getType(Serializable.class)));
    public static final TypeHierarchy JAVA_LANG_OBJECT = new TypeHierarchy(Type.getType(Object.class), null, IMPLEMENTS_NO_INTERFACES, false);
    public static final TypeHierarchy BOOLEAN_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.BOOLEAN_TYPE);
    public static final TypeHierarchy BYTE_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.BYTE_TYPE);
    public static final TypeHierarchy CHAR_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.CHAR_TYPE);
    public static final TypeHierarchy SHORT_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.SHORT_TYPE);
    public static final TypeHierarchy INT_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.INT_TYPE);
    public static final TypeHierarchy LONG_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.LONG_TYPE);
    public static final TypeHierarchy FLOAT_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.FLOAT_TYPE);
    public static final TypeHierarchy DOUBLE_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.DOUBLE_TYPE);
    public static final TypeHierarchy VOID_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.VOID_TYPE);
    private final Type thisType;
    private final Type superClass;
    private final List<Type> interfaces;
    private final boolean isInterface;

    public static TypeHierarchy hierarchyForArrayOfType(Type t) {
        return new TypeHierarchy(t, JAVA_LANG_OBJECT.type(), IMPLICIT_ARRAY_INTERFACES, false);
    }

    private static TypeHierarchy typeHierarchyForPrimitiveType(Type primitiveType) {
        return new TypeHierarchy(primitiveType, null, IMPLEMENTS_NO_INTERFACES, false);
    }

    public TypeHierarchy(Type thisType, Type superClass, List<Type> interfaces, boolean isInterface) {
        this.thisType = thisType;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.isInterface = isInterface;
    }

    public Type type() {
        return this.thisType;
    }

    public boolean representsType(Type t) {
        return t.equals(this.thisType);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isArray() {
        return this.thisType.getSort() == 9;
    }

    public Type getSuperClass() {
        return this.superClass;
    }

    public List<Type> getInterfaces() {
        return this.interfaces;
    }

    public boolean isAssignableFrom(Type type, TypeHierarchyReader reader) {
        return this.isAssignableFrom(reader.hierarchyOf(type), reader);
    }

    public boolean isAssignableFrom(TypeHierarchy u, TypeHierarchyReader typeHierarchyReader) {
        if (this.assigningToObject()) {
            return true;
        }
        if (this.isSameType(u)) {
            return true;
        }
        if (this.isSuperTypeOf(u)) {
            return true;
        }
        if (this.isInterfaceImplementedBy(u)) {
            return true;
        }
        if (this.bothAreArrayTypes(u) && this.haveSameDimensionality(u)) {
            return JAVA_LANG_OBJECT.representsType(this.typeOfArray()) && u.isReferenceArrayType() || this.arrayTypeIsAssignableFrom(u, typeHierarchyReader);
        }
        if (this.bothAreArrayTypes(u) && this.isObjectArrayWithSmallerDimensionalityThan(u)) {
            return true;
        }
        if (u.extendsObject() && !u.implementsAnyInterfaces()) {
            return false;
        }
        if (u.hasSuperClass() && this.isAssignableFrom(u.getSuperClass(), typeHierarchyReader)) {
            return true;
        }
        return u.implementsAnyInterfaces() && this.isAssignableFromAnyInterfaceImplementedBy(u, typeHierarchyReader);
    }

    private boolean assigningToObject() {
        return JAVA_LANG_OBJECT.representsType(this.type());
    }

    private boolean isAssignableFromAnyInterfaceImplementedBy(TypeHierarchy u, TypeHierarchyReader typeHierarchyReader) {
        for (Type ui : u.interfaces) {
            if (!this.isAssignableFrom(ui, typeHierarchyReader)) continue;
            return true;
        }
        return false;
    }

    private boolean haveSameDimensionality(TypeHierarchy u) {
        return this.arrayDimensionality() == u.arrayDimensionality();
    }

    private boolean isObjectArrayWithSmallerDimensionalityThan(TypeHierarchy u) {
        return JAVA_LANG_OBJECT.representsType(this.typeOfArray()) && this.arrayDimensionality() <= u.arrayDimensionality();
    }

    private boolean arrayTypeIsAssignableFrom(TypeHierarchy u, TypeHierarchyReader reader) {
        TypeHierarchy thisArrayType = reader.hierarchyOf(this.typeOfArray());
        return this.typeOfArray().getSort() == u.typeOfArray().getSort() && thisArrayType.isAssignableFrom(reader.hierarchyOf(u.typeOfArray()), reader);
    }

    private boolean bothAreArrayTypes(TypeHierarchy u) {
        return this.isArray() && u.isArray();
    }

    private Type typeOfArray() {
        return Type.getType(this.thisType.getInternalName().substring(this.thisType.getDimensions()));
    }

    private int arrayDimensionality() {
        return this.thisType.getDimensions();
    }

    public boolean isReferenceArrayType() {
        return this.isArray() && this.typeOfArray().getSort() == 10;
    }

    public boolean isInterfaceImplementedBy(TypeHierarchy u) {
        return u.interfaces.contains(this.type());
    }

    public boolean isSuperTypeOf(TypeHierarchy u) {
        return this.type().equals(u.getSuperClass());
    }

    public boolean hasSuperClass() {
        return this.getSuperClass() != null && !JAVA_LANG_OBJECT.representsType(this.getSuperClass());
    }

    public boolean implementsAnyInterfaces() {
        return !this.interfaces.isEmpty();
    }

    public boolean extendsObject() {
        return this.getSuperClass() != null && JAVA_LANG_OBJECT.representsType(this.getSuperClass());
    }

    public boolean isSameType(TypeHierarchy u) {
        return u.type().equals(this.type());
    }

    public int hashCode() {
        int prime = 31;
        return 31 * this.thisType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeHierarchy other = (TypeHierarchy)obj;
        return this.thisType.equals(other.thisType);
    }

    public String toString() {
        return String.format("%s [type=%s]", this.getClass().getSimpleName(), this.thisType.toString());
    }
}

