/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.mutabilitydetector.AnalysisError;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.asmoverride.AsmClassVisitor;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.CheckerResult;
import org.mutabilitydetector.checkers.UnhandledExceptionBuilder;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.com.google.classpath.ClassPathFactory;
import org.mutabilitydetector.internal.com.google.common.base.Optional;
import org.mutabilitydetector.internal.org.objectweb.asm.ClassReader;
import org.mutabilitydetector.internal.org.objectweb.asm.ClassVisitor;
import org.mutabilitydetector.locations.CodeLocation;
import org.mutabilitydetector.locations.Dotted;

public final class CheckerRunner {
    private final ClassPath classpath;
    private final UnhandledExceptionBuilder unhandledExceptionBuilder;
    private final ExceptionPolicy exceptionPolicy;

    private CheckerRunner(ClassPath classpath, UnhandledExceptionBuilder unhandledExceptionBuilder, ExceptionPolicy exceptionPolicy) {
        this.classpath = classpath;
        this.unhandledExceptionBuilder = unhandledExceptionBuilder;
        this.exceptionPolicy = exceptionPolicy;
    }

    public static CheckerRunner createWithClasspath(ClassPath classpath, ExceptionPolicy exceptionPolicy) {
        return new CheckerRunner(classpath, new UnhandledExceptionBuilder(), exceptionPolicy);
    }

    public static CheckerRunner createWithCurrentClasspath(ExceptionPolicy exceptionPolicy) {
        return CheckerRunner.createWithClasspath(new ClassPathFactory().createFromJVM(), exceptionPolicy);
    }

    public CheckerResult run(AsmMutabilityChecker checker, Dotted className, Iterable<AnalysisResult> resultsSoFar) {
        Optional<AnalysisError> potentialError = this.runVisitor(checker, className, resultsSoFar);
        if (potentialError.isPresent()) {
            return new CheckerResult(MutabilityReason.CANNOT_ANALYSE.createsResult(), Collections.singleton(MutableReasonDetail.newMutableReasonDetail("Encountered an unhandled error in analysis.", this.codeLocationOf(className), MutabilityReason.CANNOT_ANALYSE)), Collections.singleton(potentialError.get()));
        }
        return checker.checkerResult();
    }

    public Optional<AnalysisError> runVisitor(AsmClassVisitor visitor, Dotted className, Iterable<AnalysisResult> resultsSoFar) {
        try {
            try {
                this.analyseFromStream(visitor, className);
            }
            catch (Exception e) {
                this.analyseFromClassLoader(visitor, className);
            }
        }
        catch (Throwable e) {
            return Optional.of(this.attemptRecovery(visitor, className, resultsSoFar, e));
        }
        return Optional.absent();
    }

    private CodeLocation<?> codeLocationOf(Dotted className) {
        return className != null ? CodeLocation.ClassLocation.from(className) : CodeLocation.UnknownCodeLocation.UNKNOWN;
    }

    private void analyseFromStream(ClassVisitor checker, Dotted dottedClassPath) throws IOException {
        InputStream classStream = this.classpath.getResourceAsStream(dottedClassPath.asResource());
        this.analyse(checker, classStream);
    }

    private void analyseFromClassLoader(ClassVisitor checker, Dotted className) throws Exception {
        InputStream classStream = this.getClass().getClassLoader().getResourceAsStream(className.asResource());
        this.analyse(checker, classStream);
    }

    private void analyse(ClassVisitor checker, InputStream classStream) throws IOException {
        ClassReader cr = new ClassReader(classStream);
        cr.accept(checker, 0);
    }

    private AnalysisError attemptRecovery(ClassVisitor visitor, Dotted className, Iterable<AnalysisResult> resultsSoFar, Throwable error) {
        if (!this.isRecoverable(error) || this.exceptionPolicy == ExceptionPolicy.FAIL_FAST) {
            throw this.unhandledExceptionBuilder.unhandledException(error, resultsSoFar, visitor, className);
        }
        return this.handleException(visitor, className);
    }

    private boolean isRecoverable(Throwable e) {
        Throwable cause = this.underlyingCause(e);
        return cause instanceof Exception || cause instanceof LinkageError;
    }

    private Throwable underlyingCause(Throwable e) {
        Throwable rootCause = e;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    private AnalysisError handleException(ClassVisitor checker, Dotted onClass) {
        String errorDescription = this.createErrorDescription(onClass);
        return new AnalysisError(onClass, this.getNameOfChecker(checker), errorDescription);
    }

    public String createErrorDescription(Dotted dottedClass) {
        return String.format("It is likely that the class %s has dependencies outwith the given class path.", dottedClass.asString());
    }

    private String getNameOfChecker(ClassVisitor visitor) {
        return visitor.getClass().getSimpleName();
    }

    public static enum ExceptionPolicy {
        FAIL_FAST,
        CARRY_ON;

    }
}

