/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.List;
import java.util.Map;
import org.mutabilitydetector.IsImmutable;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.CollectionField;
import org.mutabilitydetector.checkers.FieldAssignmentVisitor;
import org.mutabilitydetector.checkers.JdkCollectionTypes;
import org.mutabilitydetector.checkers.info.AnalysisInProgress;
import org.mutabilitydetector.checkers.info.MutableTypeInformation;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.internal.com.google.common.collect.Maps;
import org.mutabilitydetector.internal.org.objectweb.asm.FieldVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.MethodVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.BasicValue;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Frame;
import org.mutabilitydetector.locations.CodeLocation;
import org.mutabilitydetector.locations.Dotted;

public final class CollectionWithMutableElementTypeToFieldChecker
extends AsmMutabilityChecker {
    private final MutableTypeInformation mutableTypeInfo;
    private final AsmVerifierFactory verifierFactory;
    private final ImmutableSet<Dotted> immutableContainerTypes;
    private final JdkCollectionTypes jdkCollectionTypes = new JdkCollectionTypes();
    private final Map<String, String> fieldSignatures = Maps.newHashMap();
    private final AnalysisInProgress analysisInProgress;

    public CollectionWithMutableElementTypeToFieldChecker(MutableTypeInformation mutableTypeInfo, AsmVerifierFactory verifierFactory, ImmutableSet<Dotted> immutableContainerTypes, AnalysisInProgress analysisInProgress) {
        this.mutableTypeInfo = mutableTypeInfo;
        this.verifierFactory = verifierFactory;
        this.immutableContainerTypes = immutableContainerTypes;
        this.analysisInProgress = analysisInProgress;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.fieldSignatures.put(name, signature);
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new AssignCollectionToFieldVisitor(this.ownerClass, access, name, desc, signature, exceptions, this.verifierFactory);
    }

    class AssignCollectionToFieldVisitor
    extends FieldAssignmentVisitor {
        public AssignCollectionToFieldVisitor(String owner, int access, String name, String desc, String signature, String[] exceptions, AsmVerifierFactory verifierFactory) {
            super(owner, access, name, desc, signature, exceptions, verifierFactory);
        }

        @Override
        protected void visitFieldAssignmentFrame(Frame<BasicValue> assignmentFrame, FieldInsnNode fieldInsnNode, BasicValue stackValue) {
            if (this.isInvalidStackValue(stackValue)) {
                return;
            }
            Type typeAssignedToField = stackValue.getType();
            if (typeAssignedToField.getSort() == 10) {
                this.checkIfClassIsMutable(fieldInsnNode, typeAssignedToField);
            }
        }

        private void checkIfClassIsMutable(FieldInsnNode fieldInsnNode, Type typeAssignedToField) {
            Dotted fieldClass = Dotted.dotted(typeAssignedToField.getInternalName());
            if (CollectionWithMutableElementTypeToFieldChecker.this.jdkCollectionTypes.isCollectionType(fieldClass) || CollectionWithMutableElementTypeToFieldChecker.this.immutableContainerTypes.contains(fieldClass)) {
                String fieldName = fieldInsnNode.name;
                String fieldSignature = (String)CollectionWithMutableElementTypeToFieldChecker.this.fieldSignatures.get(fieldName);
                CollectionField collectionField = CollectionField.from(fieldInsnNode.desc, fieldSignature);
                List<CollectionField.GenericType> genericParameters = collectionField.getGenericParameterTypes();
                if (!collectionField.isGeneric() || this.anyGenericParameterTypesAreMutable(genericParameters)) {
                    CollectionWithMutableElementTypeToFieldChecker.this.setResult(String.format("Field can have collection with mutable element type (%s) assigned to it.", collectionField.asString()), CodeLocation.FieldLocation.fieldLocation(fieldName, CodeLocation.ClassLocation.fromInternalName(CollectionWithMutableElementTypeToFieldChecker.this.ownerClass)), MutabilityReason.COLLECTION_FIELD_WITH_MUTABLE_ELEMENT_TYPE);
                }
            }
        }

        private boolean anyGenericParameterTypesAreMutable(Iterable<CollectionField.GenericType> genericParameters) {
            for (CollectionField.GenericType genericType : genericParameters) {
                if (genericType.equals(CollectionField.GenericType.wildcard())) {
                    return true;
                }
                if (genericType.isVariable) {
                    return true;
                }
                if (genericType.isArray) {
                    return true;
                }
                if (Dotted.dotted(CollectionWithMutableElementTypeToFieldChecker.this.ownerClass()).equals(genericType.type)) {
                    return false;
                }
                MutableTypeInformation.MutabilityLookup mutabilityLookup = CollectionWithMutableElementTypeToFieldChecker.this.mutableTypeInfo.resultOf(Dotted.dotted(CollectionWithMutableElementTypeToFieldChecker.this.ownerClass), genericType.type, CollectionWithMutableElementTypeToFieldChecker.this.analysisInProgress);
                if (!mutabilityLookup.foundCyclicReference && mutabilityLookup.result.isImmutable.equals((Object)IsImmutable.IMMUTABLE)) continue;
                return true;
            }
            return false;
        }
    }
}

