/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.hint;

import org.mutabilitydetector.locations.Dotted;

public final class WrappingHint {
    public static final WrappingHint NO_HINT = WrappingHint.builder().build();
    final String copyMethodOwnerName;
    final String copyMethodName;
    final String wrappingMethodOwnerName;
    final String wrappingMethodName;
    final String copyTypeParameterName;

    private WrappingHint(String copyMethodOwnerName, String copyMethodName, String wrappingMethodOwnerName, String wrappingMethodName, String copyTypeParameterName) {
        this.copyMethodOwnerName = copyMethodOwnerName;
        this.copyMethodName = copyMethodName;
        this.wrappingMethodOwnerName = wrappingMethodOwnerName;
        this.wrappingMethodName = wrappingMethodName;
        this.copyTypeParameterName = copyTypeParameterName;
    }

    public String getWrappingHint(String fieldName) {
        if (this.isEmpty()) {
            return "";
        }
        return String.format(" You can use this expression: %s(%s(%s))", this.formatMethod(this.wrappingMethodOwnerName, this.wrappingMethodName, ""), this.formatMethod(this.copyMethodOwnerName, this.copyMethodName, this.copyTypeParameterName), fieldName);
    }

    private String formatMethod(String typeName, String methodName, String typeParameter) {
        String simpleTypeName = Dotted.fromSlashedString(typeName).asSimpleString();
        if ("<init>".equals(methodName)) {
            return String.format("new %s%s", simpleTypeName, typeParameter);
        }
        return String.format("%s.%s%s", simpleTypeName, typeParameter, methodName);
    }

    public boolean isEmpty() {
        return this.copyMethodOwnerName.isEmpty() && this.copyMethodName.isEmpty() && this.wrappingMethodOwnerName.isEmpty() && this.wrappingMethodName.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String copyMethodOwnerName = "";
        private String copyMethodName = "";
        private String wrappingMethodOwnerName = "";
        private String wrappingMethodName = "";
        private String copyTypeParameterName = "";

        public Builder setCopyMethodOwnerName(String copyMethodOwnerName) {
            this.copyMethodOwnerName = copyMethodOwnerName;
            return this;
        }

        public Builder setCopyMethodName(String copyMethodName) {
            this.copyMethodName = copyMethodName;
            return this;
        }

        public Builder setWrappingMethodOwnerName(String wrappingMethodOwnerName) {
            this.wrappingMethodOwnerName = wrappingMethodOwnerName;
            return this;
        }

        public Builder setWrappingMethodName(String wrappingMethodName) {
            this.wrappingMethodName = wrappingMethodName;
            return this;
        }

        public Builder setCopyTypeParameterName(String copyTypeParameterName) {
            this.copyTypeParameterName = copyTypeParameterName;
            return this;
        }

        public WrappingHint build() {
            return new WrappingHint(this.copyMethodOwnerName, this.copyMethodName, this.wrappingMethodOwnerName, this.wrappingMethodName, this.copyTypeParameterName);
        }
    }
}

