/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.checkers.settermethod.Alias;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.Finder;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.VarInsnNode;

@Immutable
final class AliasFinder
implements Finder<Alias> {
    private final Set<ControlFlowBlock> alreadyVisited = new HashSet<ControlFlowBlock>();
    private final String variableName;
    private final ControlFlowBlock controlFlowBlockToExamine;

    private AliasFinder(String theVariableName, ControlFlowBlock theControlFlowBlockToExamine) {
        this.variableName = theVariableName;
        this.controlFlowBlockToExamine = theControlFlowBlockToExamine;
    }

    public static AliasFinder newInstance(String variableName, ControlFlowBlock controlFlowBlockToExamine) {
        Preconditions.checkArgument(!variableName.isEmpty());
        return new AliasFinder(variableName, Preconditions.checkNotNull(controlFlowBlockToExamine));
    }

    @Override
    public Alias find() {
        return this.searchForAliasInBlock(this.controlFlowBlockToExamine);
    }

    private Alias searchForAliasInBlock(ControlFlowBlock block) {
        Iterator<ControlFlowBlock> iterator;
        AbstractInsnNode successorInsnOfGetfieldForVariable;
        Preconditions.checkNotNull(block);
        Alias result = Alias.newInstance(false, Integer.MIN_VALUE);
        if (this.alreadyVisited.contains(block)) {
            return result;
        }
        this.alreadyVisited.add(block);
        List<AbstractInsnNode> insns = block.getBlockInstructions();
        int indexOfGetfield = this.findIndexOfGetfieldForVariable(insns);
        if (AliasFinder.indexOfGetfieldFound(indexOfGetfield) && AliasFinder.isStoreInstruction(successorInsnOfGetfieldForVariable = insns.get(indexOfGetfield + 1))) {
            VarInsnNode storeInstruction = (VarInsnNode)successorInsnOfGetfieldForVariable;
            result = Alias.newInstance(true, storeInstruction.var);
        }
        if (!result.doesExist && (iterator = block.getPredecessors().iterator()).hasNext()) {
            ControlFlowBlock predecessor = iterator.next();
            return this.searchForAliasInBlock(predecessor);
        }
        return result;
    }

    private int findIndexOfGetfieldForVariable(List<AbstractInsnNode> instructions) {
        int result = -1;
        int i = 0;
        for (AbstractInsnNode instruction : instructions) {
            if (this.isGetfieldForVariable(instruction)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isGetfieldForVariable(AbstractInsnNode insn) {
        boolean result = false;
        if (180 == insn.getOpcode()) {
            FieldInsnNode getfield = (FieldInsnNode)insn;
            result = this.variableName.equals(getfield.name);
        }
        return result;
    }

    private static boolean indexOfGetfieldFound(int index) {
        return -1 < index;
    }

    private static boolean isStoreInstruction(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AliasFinder [").append("variableName=").append(this.variableName);
        builder.append(", controlFlowBlockToExamine=").append(this.controlFlowBlockToExamine);
        builder.append(", alreadyVisited=").append(this.alreadyVisited).append(']');
        return builder.toString();
    }
}

