/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.settermethod.UnknownTypeValue;

@NotThreadSafe
final class DefaultUnknownTypeValue
implements UnknownTypeValue {
    private final Object value;

    private DefaultUnknownTypeValue(Object theBaseValue) {
        this.value = theBaseValue;
    }

    public static UnknownTypeValue getInstance(Object baseValue) {
        UnknownTypeValue result = baseValue instanceof DefaultUnknownTypeValue ? (DefaultUnknownTypeValue)baseValue : (null == baseValue ? DefaultUnknownTypeValue.getInstanceForNull() : new DefaultUnknownTypeValue(baseValue));
        return result;
    }

    public static UnknownTypeValue getInstanceForNull() {
        return new DefaultUnknownTypeValue((Object)UnknownTypeValue.Default.NULL);
    }

    public static UnknownTypeValue getInstanceForUnknownPrimitive() {
        return DefaultUnknownTypeValue.getInstance((Object)UnknownTypeValue.Default.UNKNOWN_PRIMITIVE);
    }

    public static UnknownTypeValue getInstanceForUnknownReference() {
        return DefaultUnknownTypeValue.getInstance((Object)UnknownTypeValue.Default.UNKNOWN_REFERENCE);
    }

    @Override
    public boolean asBoolean() {
        Boolean result = this.tryToCast(Boolean.class);
        return result;
    }

    private <T> T tryToCast(Class<T> targetClass) {
        try {
            return this.cast(targetClass);
        }
        catch (ClassCastException e) {
            String msg = String.format("Unable to cast '%s' to target class '%s'.", this.value, targetClass);
            System.err.println(msg);
            return null;
        }
    }

    private <T> T cast(Class<T> targetClass) {
        T result = targetClass.cast(this.value);
        if (null == result) {
            String msg = String.format("Unable to cast '%s' to target class '%s'.", this.value, targetClass);
            throw new NullPointerException(msg);
        }
        return result;
    }

    @Override
    public char asChar() {
        Character result = this.tryToCast(Character.class);
        return result.charValue();
    }

    @Override
    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean isByte() {
        return this.value instanceof Byte;
    }

    @Override
    public boolean isChar() {
        return this.value instanceof Character;
    }

    @Override
    public boolean isShort() {
        return this.value instanceof Short;
    }

    @Override
    public boolean isInt() {
        return this.value instanceof Integer;
    }

    @Override
    public boolean isLong() {
        return this.value instanceof Long;
    }

    @Override
    public boolean isFloat() {
        return this.value instanceof Float;
    }

    @Override
    public boolean isDouble() {
        return this.value instanceof Double;
    }

    @Override
    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public boolean isObject() {
        boolean result = this.isBoolean() || this.isChar() || this.isString() ? false : null == this.tryToCastToNumber();
        return result;
    }

    private Number tryToCastToNumber() {
        return this.tryToCast(Number.class);
    }

    @Override
    public boolean isZero() {
        Number valueAsNumber;
        int valueAsInt;
        boolean result = this.isObject() || this.isString() ? false : (this.isBoolean() ? !this.asBoolean() : (this.isChar() ? '\u0000' == this.asChar() : 0 == (valueAsInt = (valueAsNumber = this.tryToCastToNumber()).intValue())));
        return result;
    }

    @Override
    public boolean isNotZero() {
        return !this.isZero();
    }

    @Override
    public boolean isNull() {
        return UnknownTypeValue.Default.NULL == this.value;
    }

    @Override
    public boolean isNotNull() {
        return !this.isNull();
    }

    @Override
    public boolean isUnknownPrimitive() {
        return UnknownTypeValue.Default.UNKNOWN_PRIMITIVE == this.value;
    }

    @Override
    public boolean isUnknownReference() {
        return UnknownTypeValue.Default.UNKNOWN_REFERENCE == this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultUnknownTypeValue)) {
            return false;
        }
        DefaultUnknownTypeValue other = (DefaultUnknownTypeValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append(" [").append("value=(").append(this.getValueTypeAsString());
        b.append(") ").append(this.value).append(']');
        return b.toString();
    }

    private String getValueTypeAsString() {
        String result = this.isBoolean() ? "boolean" : (this.isChar() ? "char" : (this.isShort() ? "short" : (this.isInt() ? "int" : (this.isLong() ? "long" : (this.isFloat() ? "float" : (this.isDouble() ? "double" : (this.isString() ? "String" : "unknown/Object")))))));
        return result;
    }
}

