/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlockCache;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.commons.Method;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.ClassNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;

@NotThreadSafe
final class EnhancedClassNode {
    private final ClassNode classNode;
    private final ControlFlowBlockCache cfbCache;

    private EnhancedClassNode(ClassNode theClassNode) {
        this.classNode = theClassNode;
        this.cfbCache = ControlFlowBlockCache.newInstance(theClassNode.name);
    }

    public static EnhancedClassNode newInstance(ClassNode classNode) {
        return new EnhancedClassNode(Preconditions.checkNotNull(classNode));
    }

    public String getName() {
        return this.classNode.name;
    }

    public List<FieldNode> getFields() {
        return this.classNode.fields;
    }

    public List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    FieldNode findVariableWithName(String variableName) {
        Preconditions.checkArgument(!variableName.isEmpty());
        for (FieldNode variable : this.getFields()) {
            if (!variableName.equals(variable.name)) continue;
            return variable;
        }
        return null;
    }

    List<MethodNode> findMethodByName(String methodName) {
        Preconditions.checkArgument(!methodName.isEmpty());
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        for (MethodNode method : this.getMethods()) {
            if (!methodName.equals(method.name)) continue;
            result.add(method);
        }
        result.trimToSize();
        return result;
    }

    MethodNode findMethodByDescriptor(String methodName, Type returnType, Type ... argumentTypes) {
        Preconditions.checkArgument(!methodName.isEmpty(), "Parameter 'methodName' must neither be null nor empty!");
        Preconditions.checkNotNull(returnType, "Parameter 'returnType' must not be null!");
        String desc = EnhancedClassNode.createDescriptorFor(methodName, returnType, argumentTypes);
        return this.findMethodByDescriptor(methodName, desc);
    }

    MethodNode findMethodByDescriptor(String methodName, String descriptor) {
        Preconditions.checkArgument(!methodName.isEmpty(), "Parameter 'methodName' must neither be null nor empty!");
        Preconditions.checkArgument(!descriptor.isEmpty(), "Parameter 'descriptor' must neither be null nor empty!");
        for (MethodNode method : this.getMethods()) {
            if (!method.name.equals(methodName) || !method.desc.equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    private static String createDescriptorFor(String methodName, Type returnType, Type[] argumentTypes) {
        Method method = new Method(methodName, returnType, argumentTypes);
        return method.getDescriptor();
    }

    public List<ControlFlowBlock> getControlFlowBlocksForMethod(MethodNode method) {
        return this.cfbCache.getControlFlowBlocksForMethod(method);
    }

    List<ControlFlowBlock> getControlFlowBlocksForMethod(String methodName, Type returnType, Type ... argumentTypes) {
        MethodNode method = this.findMethodByDescriptor(methodName, returnType, argumentTypes);
        return this.getControlFlowBlocksForMethod(method);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [").append("classNode=").append(this.classNode);
        builder.append(", cfbCache=").append(this.cfbCache).append(']');
        return builder.toString();
    }
}

