/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.settermethod.AssignmentInsn;
import org.mutabilitydetector.checkers.settermethod.CandidatesInitialisersMapping;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.DefaultUnknownTypeValue;
import org.mutabilitydetector.checkers.settermethod.EffectiveAssignmentInsnFinder;
import org.mutabilitydetector.checkers.settermethod.EnhancedClassNode;
import org.mutabilitydetector.checkers.settermethod.Finder;
import org.mutabilitydetector.checkers.settermethod.Opcode;
import org.mutabilitydetector.checkers.settermethod.UnknownTypeValue;
import org.mutabilitydetector.internal.com.google.common.base.MoreObjects;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.InsnList;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.IntInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LdcInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;

@NotThreadSafe
final class InitialValueFinder
implements Finder<Set<UnknownTypeValue>> {
    private final FieldNode variable;
    private final CandidatesInitialisersMapping.Initialisers initialisers;
    private final EnhancedClassNode enhancedClassNode;
    private final Set<UnknownTypeValue> possibleInitialValues;
    private volatile boolean arePossibleInitialValuesAlreadyFound;

    private InitialValueFinder(FieldNode theVariable, CandidatesInitialisersMapping.Initialisers theSetters, EnhancedClassNode theEnhancedClassNode) {
        this.variable = theVariable;
        this.initialisers = theSetters;
        this.enhancedClassNode = theEnhancedClassNode;
        int supposedMaximumOfPossibleInitialValues = 5;
        this.possibleInitialValues = new HashSet<UnknownTypeValue>(5);
        this.arePossibleInitialValuesAlreadyFound = false;
    }

    public static InitialValueFinder newInstance(FieldNode variable, CandidatesInitialisersMapping.Initialisers initialisers, EnhancedClassNode enhancedClassNode) {
        return new InitialValueFinder(Preconditions.checkNotNull(variable), Preconditions.checkNotNull(initialisers), Preconditions.checkNotNull(enhancedClassNode));
    }

    @Override
    public Set<UnknownTypeValue> find() {
        if (!this.arePossibleInitialValuesAlreadyFound) {
            this.findPossibleInitialValues();
            this.arePossibleInitialValuesAlreadyFound = true;
        }
        return Collections.unmodifiableSet(this.possibleInitialValues);
    }

    private void findPossibleInitialValues() {
        if (this.hasNoConstructors()) {
            this.addJvmInitialValueForVariable();
        } else {
            this.addConcreteInitialValuesByConstructor();
        }
    }

    private boolean hasNoConstructors() {
        List<MethodNode> constructors = this.initialisers.getConstructors();
        return constructors.isEmpty();
    }

    private void addJvmInitialValueForVariable() {
        InitialValueFactory factory = new InitialValueFactory(this.variable);
        Type type = Type.getType(this.variable.desc);
        this.possibleInitialValues.add(factory.getJvmDefaultInitialValueFor(type));
    }

    private void addConcreteInitialValuesByConstructor() {
        for (MethodNode constructor : this.initialisers.getConstructors()) {
            AbstractInsnNode valueSetUpInsn = this.findValueSetUpInsnIn(constructor);
            this.addSupposedInitialValueFor(valueSetUpInsn);
        }
    }

    private AbstractInsnNode findValueSetUpInsnIn(MethodNode constructor) {
        List<ControlFlowBlock> blocks = this.enhancedClassNode.getControlFlowBlocksForMethod(constructor);
        EffectiveAssignmentInsnFinder f = EffectiveAssignmentInsnFinder.newInstance(this.variable, blocks);
        AssignmentInsn effectiveAssignmentInsn = (AssignmentInsn)f.find();
        int indexOfAssignmentInstruction = effectiveAssignmentInsn.getIndexWithinMethod();
        InsnList instructions = constructor.instructions;
        return instructions.get(indexOfAssignmentInstruction - 1);
    }

    private void addSupposedInitialValueFor(AbstractInsnNode variableValueSetupInsn) {
        InitialValueFactory factory = new InitialValueFactory(this.variable);
        UnknownTypeValue initialValue = factory.getConcreteInitialValueFor(variableValueSetupInsn);
        this.possibleInitialValues.add(initialValue);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this);
        helper.add("variable", this.variable).add("setters", this.initialisers);
        helper.add("possibleInitialValues", this.possibleInitialValues);
        return helper.toString();
    }

    @Immutable
    private static final class InitialValueFactory {
        private final FieldNode variable;

        public InitialValueFactory(FieldNode theVariable) {
            this.variable = theVariable;
        }

        public UnknownTypeValue getConcreteInitialValueFor(AbstractInsnNode variableValueSetupInsn) {
            UnknownTypeValue result = InitialValueFactory.isLdcInsn(variableValueSetupInsn) ? InitialValueFactory.getInitialValueOfLdcInsn(variableValueSetupInsn) : (InitialValueFactory.isIntInsn(variableValueSetupInsn) ? InitialValueFactory.getInitialValueOfIntInsn(variableValueSetupInsn) : (InitialValueFactory.isStackConstantPushInsn(variableValueSetupInsn) ? InitialValueFactory.getInitialValueOfStackConstantInsn(variableValueSetupInsn) : this.getInitialValueOfUnknownTypeOfVariable()));
            return result;
        }

        private static boolean isLdcInsn(AbstractInsnNode abstractInsnNode) {
            return 9 == abstractInsnNode.getType();
        }

        private static UnknownTypeValue getInitialValueOfLdcInsn(AbstractInsnNode setupInsn) {
            LdcInsnNode ldcInsn = (LdcInsnNode)setupInsn;
            Object cst = ldcInsn.cst;
            return DefaultUnknownTypeValue.getInstance(cst);
        }

        private static boolean isIntInsn(AbstractInsnNode abstractInsnNode) {
            return 1 == abstractInsnNode.getType();
        }

        private static UnknownTypeValue getInitialValueOfIntInsn(AbstractInsnNode setupInsn) {
            IntInsnNode singleIntOperandInsn = (IntInsnNode)setupInsn;
            int operand = singleIntOperandInsn.operand;
            return DefaultUnknownTypeValue.getInstance(operand);
        }

        private static boolean isStackConstantPushInsn(AbstractInsnNode setupInsn) {
            SortedSet<Opcode> constantsInstructions = Opcode.constants();
            Opcode opcode = Opcode.forInt(setupInsn.getOpcode());
            return constantsInstructions.contains(opcode);
        }

        private static UnknownTypeValue getInitialValueOfStackConstantInsn(AbstractInsnNode setupInsn) {
            Opcode opcode = Opcode.forInt(setupInsn.getOpcode());
            return opcode.stackValue();
        }

        private UnknownTypeValue getInitialValueOfUnknownTypeOfVariable() {
            Type variableType = Type.getType(this.variable.desc);
            int typeSort = variableType.getSort();
            UnknownTypeValue result = 10 == typeSort || 9 == typeSort || 11 == typeSort ? DefaultUnknownTypeValue.getInstanceForUnknownReference() : DefaultUnknownTypeValue.getInstanceForUnknownPrimitive();
            return result;
        }

        public UnknownTypeValue getJvmDefaultInitialValueFor(Type type) {
            int sort = type.getSort();
            UnknownTypeValue result = 1 == sort ? DefaultUnknownTypeValue.getInstance(Boolean.FALSE) : (3 == sort ? DefaultUnknownTypeValue.getInstance((byte)0) : (2 == sort ? DefaultUnknownTypeValue.getInstance(Character.valueOf('\u0000')) : (4 == sort ? DefaultUnknownTypeValue.getInstance((short)0) : (5 == sort ? DefaultUnknownTypeValue.getInstance(0) : (7 == sort ? DefaultUnknownTypeValue.getInstance(0L) : (6 == sort ? DefaultUnknownTypeValue.getInstance(Float.valueOf(0.0f)) : (8 == sort ? DefaultUnknownTypeValue.getInstance(0.0) : DefaultUnknownTypeValue.getInstanceForNull())))))));
            return result;
        }
    }
}

