/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.util;

import java.util.HashMap;
import java.util.Map;
import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.MethodIs;
import org.mutabilitydetector.checkers.MutabilityAnalysisException;
import org.mutabilitydetector.checkers.info.MethodIdentifier;
import org.mutabilitydetector.checkers.info.TypeInformationRetriever;
import org.mutabilitydetector.internal.org.objectweb.asm.MethodVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;
import org.mutabilitydetector.locations.Slashed;

public final class PrivateMethodInvocationAnalyser
extends TypeInformationRetriever {
    private final Map<MethodIdentifier, Boolean> privateMethodCalledFromConstructorMap = new HashMap<MethodIdentifier, Boolean>();

    public boolean isPrivateMethodCalledOnlyFromConstructor(String methodDescriptor) {
        MethodIdentifier identifier = this.makeMethodIdentifier(methodDescriptor);
        if (this.privateMethodCalledFromConstructorMap.containsKey(identifier)) {
            return this.privateMethodCalledFromConstructorMap.get(identifier);
        }
        String message = String.format("Could not find method descriptor %s. Available descriptors are: %n%s", identifier, this.privateMethodCalledFromConstructorMap.keySet().toString());
        throw new MutabilityAnalysisException(message);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        super.visitMethod(access, name, desc, signature, exceptions);
        boolean isPrivate = AccessModifierQuery.method(access).isPrivate();
        String methodDescriptor = this.makeMethodDescriptor(name, desc);
        this.privateMethodCalledFromConstructorMap.put(this.makeMethodIdentifier(methodDescriptor), isPrivate);
        return new MethodInvocationVisitor(access, name, desc, signature, exceptions);
    }

    private String makeMethodDescriptor(String methodName, String methodDesc) {
        return String.format("%s:%s", methodName, methodDesc);
    }

    private MethodIdentifier makeMethodIdentifier(String desc) {
        return MethodIdentifier.forMethod(Slashed.slashed(this.ownerClass()), desc);
    }

    private class MethodInvocationVisitor
    extends MethodNode {
        public MethodInvocationVisitor(int access, String name, String desc, String signature, String[] exceptions) {
            super(458752, access, name, desc, signature, exceptions);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String methodName, String methodDesc, boolean isInterface) {
            if (MethodIs.aConstructor(this.name)) {
                return;
            }
            MethodIdentifier identifier = PrivateMethodInvocationAnalyser.this.makeMethodIdentifier(PrivateMethodInvocationAnalyser.this.makeMethodDescriptor(methodName, methodDesc));
            PrivateMethodInvocationAnalyser.this.privateMethodCalledFromConstructorMap.put(identifier, false);
        }
    }
}

