/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.unittesting;

import java.util.Arrays;
import java.util.Set;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.internal.com.google.common.collect.Iterables;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.unittesting.matchers.reasons.AllowingForSubclassing;
import org.mutabilitydetector.unittesting.matchers.reasons.AllowingNonFinalFields;
import org.mutabilitydetector.unittesting.matchers.reasons.FieldAssumptions;
import org.mutabilitydetector.unittesting.matchers.reasons.ProvidedOtherClass;

public final class AllowedReason {
    private AllowedReason() {
    }

    public static ProvidedOtherClass provided(String dottedClassName) {
        return ProvidedOtherClass.provided(Dotted.dotted(dottedClassName));
    }

    public static ProvidedOtherClass provided(Class<?> clazz) {
        return ProvidedOtherClass.provided(Dotted.fromClass(clazz));
    }

    public static ProvidedOtherClass provided(Class<?> ... classes) {
        return ProvidedOtherClass.provided(Iterables.transform(Arrays.asList(classes), Dotted::fromClass));
    }

    public static AllowingForSubclassing allowingForSubclassing() {
        return new AllowingForSubclassing();
    }

    public static AllowingNonFinalFields allowingNonFinalFields() {
        return new AllowingNonFinalFields();
    }

    public static FieldAssumptions assumingFields(String firstFieldName, String ... otherFieldNames) {
        return FieldAssumptions.named((Set<String>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(firstFieldName)).add(otherFieldNames)).build()));
    }

    public static FieldAssumptions assumingFields(Iterable<String> named) {
        return FieldAssumptions.named(ImmutableSet.copyOf(named));
    }
}

