/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.unittesting.matchers.reasons;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.internal.com.google.common.collect.Iterables;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.unittesting.matchers.reasons.BaseMutableReasonDetailMatcher;

public final class ProvidedOtherClass {
    private final Iterable<Dotted> dottedClassNames;

    private ProvidedOtherClass(Iterable<Dotted> dottedClassName) {
        this.dottedClassNames = dottedClassName;
    }

    public static ProvidedOtherClass provided(Dotted className) {
        return ProvidedOtherClass.provided(Collections.singleton(className));
    }

    public static ProvidedOtherClass provided(Dotted ... classNames) {
        return ProvidedOtherClass.provided(Arrays.asList(classNames));
    }

    public static ProvidedOtherClass provided(Iterable<Dotted> classNames) {
        return new ProvidedOtherClass(classNames);
    }

    public Matcher<MutableReasonDetail> isAlsoImmutable() {
        AllowedIfOtherClassIsGenericTypeOfCollectionField allowGenericTypes = new AllowedIfOtherClassIsGenericTypeOfCollectionField(this.dottedClassNames);
        return AnyOf.anyOf((Matcher)allowGenericTypes, (Matcher)AnyOf.anyOf(Iterables.transform(this.dottedClassNames, AllowedIfOtherClassIsImmutable::new)));
    }

    public Matcher<MutableReasonDetail> areAlsoImmutable() {
        return this.isAlsoImmutable();
    }

    private static final class AllowedIfOtherClassIsGenericTypeOfCollectionField
    extends BaseMutableReasonDetailMatcher {
        private final Iterable<Dotted> classNames;

        public AllowedIfOtherClassIsGenericTypeOfCollectionField(Iterable<Dotted> classNames) {
            this.classNames = classNames;
        }

        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            return this.allowedIfCollectionTypeWhereAllGenericElementsAreConsideredImmutable(reasonDetail);
        }

        private boolean allowedIfCollectionTypeWhereAllGenericElementsAreConsideredImmutable(MutableReasonDetail reasonDetail) {
            return reasonDetail.reason().isOneOf(MutabilityReason.COLLECTION_FIELD_WITH_MUTABLE_ELEMENT_TYPE) && this.allElementTypesAreConsideredImmutable(reasonDetail.message());
        }

        private boolean allElementTypesAreConsideredImmutable(String message) {
            String[] genericsTypesDescription;
            String[] stringArray;
            String fieldTypeDescription = message.substring(message.indexOf("("), message.indexOf(")") + 1);
            String generics = fieldTypeDescription.substring(fieldTypeDescription.indexOf("<") + 1, fieldTypeDescription.lastIndexOf(">"));
            if (generics.contains(", ")) {
                stringArray = generics.split(", ");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = generics;
            }
            for (String genericType : genericsTypesDescription = stringArray) {
                if (Iterables.contains(this.classNames, Dotted.dotted(genericType))) continue;
                return false;
            }
            return true;
        }
    }

    private static final class AllowedIfOtherClassIsImmutable
    extends BaseMutableReasonDetailMatcher {
        private final Dotted className;

        public AllowedIfOtherClassIsImmutable(Dotted dottedClassName) {
            this.className = dottedClassName;
        }

        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            return this.isAssignedField(reasonDetail);
        }

        private boolean isAssignedField(MutableReasonDetail reasonDetail) {
            return reasonDetail.reason().isOneOf(MutabilityReason.ABSTRACT_TYPE_TO_FIELD, MutabilityReason.MUTABLE_TYPE_TO_FIELD) && reasonDetail.message().contains(this.classNameAsItAppearsInDescription());
        }

        private String classNameAsItAppearsInDescription() {
            return "(" + this.className.asString() + ")";
        }
    }
}

