/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.Configuration;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.checkers.CheckerRunner;
import org.mutabilitydetector.checkers.MethodIs;
import org.mutabilitydetector.checkers.MutabilityAnalysisException;
import org.mutabilitydetector.checkers.MutabilityCheckerFactory;
import org.mutabilitydetector.checkers.info.CopyMethod;
import org.mutabilitydetector.config.HardcodedResultsUsage;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableMap;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSetMultimap;
import org.mutabilitydetector.internal.com.google.common.collect.Multimap;
import org.mutabilitydetector.internal.com.google.common.collect.Sets;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.locations.ClassNameConverter;
import org.mutabilitydetector.locations.Dotted;

@NotThreadSafe
public abstract class ConfigurationBuilder {
    private ImmutableSet.Builder<AnalysisResult> hardcodedResults = ImmutableSet.builder();
    private ImmutableSet.Builder<Dotted> hardcodedImmutableContainerClasses = ImmutableSet.builder();
    private CheckerRunner.ExceptionPolicy exceptionPolicy = CheckerRunner.ExceptionPolicy.FAIL_FAST;
    private AsmVerifierFactory.ClassloadingOption classloadingOption = AsmVerifierFactory.ClassloadingOption.ENABLED;
    private MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm = MutabilityCheckerFactory.ReassignedFieldAnalysisChoice.NAIVE_PUT_FIELD_ANALYSIS;
    private ImmutableSetMultimap.Builder<String, CopyMethod> validCopyMethods = ImmutableSetMultimap.builder();
    private HardcodedResultsUsage howToUseHardcodedResults = HardcodedResultsUsage.LOOKUP_WHEN_REFERENCED;

    public abstract void configure();

    public final Configuration build() {
        this.configure();
        return new DefaultConfiguration((ImmutableSet)this.hardcodedResults.build(), (ImmutableSet)this.hardcodedImmutableContainerClasses.build(), this.exceptionPolicy, this.classloadingOption, this.reassignedFieldAlgorithm, (ImmutableSetMultimap)this.validCopyMethods.build(), this.howToUseHardcodedResults);
    }

    protected final void setExceptionPolicy(CheckerRunner.ExceptionPolicy exceptionPolicy) {
        this.exceptionPolicy = exceptionPolicy;
    }

    protected final void setClassloadingPolicy(AsmVerifierFactory.ClassloadingOption classloadingOption) {
        this.classloadingOption = classloadingOption;
    }

    protected final void hardcodeResult(AnalysisResult result) {
        this.hardcodedResults.add((Object)result);
    }

    protected final void hardcodeResults(Iterable<AnalysisResult> result) {
        this.hardcodedResults.addAll((Iterable)result);
    }

    protected final void hardcodeResults(AnalysisResult ... result) {
        this.hardcodeResults(Arrays.asList(result));
    }

    protected final void hardcodeAsDefinitelyImmutable(Class<?> immutableClass) {
        this.hardcodeResult(AnalysisResult.definitelyImmutable(Dotted.fromClass(immutableClass)));
    }

    protected final void hardcodeAsDefinitelyImmutable(String immutableClassName) {
        this.hardcodeResult(AnalysisResult.definitelyImmutable(Dotted.dotted(immutableClassName)));
    }

    protected final void setHowToUseHardcodedResults(HardcodedResultsUsage usage) {
        this.howToUseHardcodedResults = usage;
    }

    protected final Set<AnalysisResult> getCurrentlyHardcodedResults() {
        return this.hardcodedResults.build();
    }

    protected final void hardcodeAsImmutableContainerType(Class<?> immutableContainerClass) {
        this.hardcodeAsImmutableContainerType(Dotted.fromClass(immutableContainerClass));
    }

    protected final void hardcodeAsImmutableContainerType(String immutableContainerClassName) {
        this.hardcodeAsImmutableContainerType(Dotted.dotted(ClassNameConverter.CONVERTER.dotted(immutableContainerClassName)));
    }

    private void hardcodeAsImmutableContainerType(Dotted immutableContainerClassName) {
        this.hardcodedImmutableContainerClasses.add((Object)immutableContainerClassName);
    }

    protected void mergeHardcodedResultsFrom(Configuration otherConfiguration) {
        Map<Dotted, AnalysisResult> resultsMap = this.hardcodedResults.build().stream().collect(Collectors.toMap(r -> r.className, r -> r));
        resultsMap.putAll(otherConfiguration.hardcodedResults());
        this.hardcodedResults = ImmutableSet.builder().addAll(resultsMap.values());
    }

    protected void mergeImmutableContainerTypesFrom(Configuration otherConfiguration) {
        Sets.SetView<Dotted> union = Sets.union(this.hardcodedImmutableContainerClasses.build(), otherConfiguration.immutableContainerClasses());
        this.hardcodedImmutableContainerClasses = ImmutableSet.builder().addAll(union);
    }

    protected void mergeValidCopyMethodsFrom(Configuration otherConfiguration) {
        this.validCopyMethods.putAll(otherConfiguration.hardcodedCopyMethods());
    }

    protected void merge(Configuration otherConfiguration) {
        this.mergeHardcodedResultsFrom(otherConfiguration);
        this.mergeImmutableContainerTypesFrom(otherConfiguration);
        this.mergeValidCopyMethodsFrom(otherConfiguration);
    }

    protected void useAdvancedReassignedFieldAlgorithm() {
        this.reassignedFieldAlgorithm = MutabilityCheckerFactory.ReassignedFieldAnalysisChoice.LAZY_INITIALISATION_ANALYSIS;
    }

    protected final void hardcodeValidCopyMethod(Class<?> fieldType, String fullyQualifiedMethodName, Class<?> argType) {
        if (argType == null || fieldType == null || fullyQualifiedMethodName == null) {
            throw new IllegalArgumentException("All parameters must be supplied - no nulls");
        }
        String className = fullyQualifiedMethodName.substring(0, fullyQualifiedMethodName.lastIndexOf("."));
        String methodName = fullyQualifiedMethodName.substring(fullyQualifiedMethodName.lastIndexOf(".") + 1);
        String desc = null;
        try {
            if (MethodIs.aConstructor(methodName)) {
                Constructor<?> ctor = Class.forName(className).getDeclaredConstructor(argType);
                desc = Type.getConstructorDescriptor(ctor);
            } else {
                Method method = Class.forName(className).getMethod(methodName, argType);
                desc = Type.getMethodDescriptor(method);
            }
        }
        catch (NoSuchMethodException e) {
            this.rethrow("No such method", e);
        }
        catch (SecurityException e) {
            this.rethrow("Security error", e);
        }
        catch (ClassNotFoundException e) {
            this.rethrow("Class not  found", e);
        }
        CopyMethod copyMethod = new CopyMethod(Dotted.dotted(className), methodName, desc);
        this.hardcodeValidCopyMethod(fieldType, copyMethod);
    }

    protected void hardcodeValidCopyMethod(Class<?> fieldType, CopyMethod copyMethod) {
        this.validCopyMethods.put((Object)fieldType.getCanonicalName(), (Object)copyMethod);
    }

    public Multimap<String, CopyMethod> getCopyMethodsAllowed() {
        return this.validCopyMethods.build();
    }

    private void rethrow(String message, Throwable e) {
        throw new MutabilityAnalysisException("Error in configuration: " + message + ": " + e.getMessage(), e);
    }

    @Immutable
    private static final class DefaultConfiguration
    implements Configuration {
        private final ImmutableSet<AnalysisResult> hardcodedResults;
        private final HardcodedResultsUsage howToUseHardcodedResults;
        private final ImmutableMap<Dotted, AnalysisResult> resultsByClassname;
        private final ImmutableSet<Dotted> immutableContainerClasses;
        private final ImmutableSetMultimap<String, CopyMethod> validCopyMethods;
        private final CheckerRunner.ExceptionPolicy exceptionPolicy;
        private final AsmVerifierFactory.ClassloadingOption classloadingOption;
        private final MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm;

        private DefaultConfiguration(ImmutableSet<AnalysisResult> predefinedResults, ImmutableSet<Dotted> immutableContainerClasses, CheckerRunner.ExceptionPolicy exceptionPolicy, AsmVerifierFactory.ClassloadingOption classloadingOption, MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm, ImmutableSetMultimap<String, CopyMethod> validCopyMethods, HardcodedResultsUsage howToUseHardcodedResults) {
            this.immutableContainerClasses = immutableContainerClasses;
            this.exceptionPolicy = exceptionPolicy;
            this.hardcodedResults = predefinedResults;
            this.classloadingOption = classloadingOption;
            this.howToUseHardcodedResults = howToUseHardcodedResults;
            this.resultsByClassname = ImmutableMap.copyOf(this.hardcodedResults.stream().collect(Collectors.toMap(r -> r.className, r -> r)));
            this.reassignedFieldAlgorithm = reassignedFieldAlgorithm;
            this.validCopyMethods = validCopyMethods;
        }

        @Override
        public Map<Dotted, AnalysisResult> hardcodedResults() {
            return this.resultsByClassname;
        }

        @Override
        public HardcodedResultsUsage howToUseHardcodedResults() {
            return this.howToUseHardcodedResults;
        }

        @Override
        public Set<Dotted> immutableContainerClasses() {
            return this.immutableContainerClasses;
        }

        @Override
        public CheckerRunner.ExceptionPolicy exceptionPolicy() {
            return this.exceptionPolicy;
        }

        @Override
        public AsmVerifierFactory.ClassloadingOption classloadingOption() {
            return this.classloadingOption;
        }

        @Override
        public MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm() {
            return this.reassignedFieldAlgorithm;
        }

        @Override
        public ImmutableSetMultimap<String, CopyMethod> hardcodedCopyMethods() {
            return this.validCopyMethods;
        }
    }
}

