/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

public class AccessModifierQuery {
    private int access;

    private AccessModifierQuery(int access) {
        this.access = access;
    }

    private boolean includesAccess(int accessFlag) {
        return (this.access & accessFlag) != 0;
    }

    public static AccessModifierQuery method(int access) {
        return new AccessModifierQuery(access);
    }

    public static AccessModifierQuery type(int access) {
        return new AccessModifierQuery(access);
    }

    public static AccessModifierQuery field(int access) {
        return new AccessModifierQuery(access);
    }

    private boolean is(int flag) {
        return this.includesAccess(flag);
    }

    public boolean isPrivate() {
        return this.is(2);
    }

    public boolean isNotPrivate() {
        return !this.is(2);
    }

    public boolean isFinal() {
        return this.is(16);
    }

    public boolean isNotFinal() {
        return !this.is(16);
    }

    public boolean isSynthetic() {
        return this.is(4096);
    }

    public boolean isNotSynthetic() {
        return !this.is(4096);
    }

    public boolean isAbstract() {
        return this.is(1024);
    }

    public boolean isInterface() {
        return this.is(512);
    }

    public boolean isStatic() {
        return this.is(8);
    }

    public boolean isNotStatic() {
        return !this.is(8);
    }
}

