/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VarStack {
    private List<Integer> indices = new ArrayList<Integer>();
    private List<VarStackSnapshot> snapshots = new ArrayList<VarStackSnapshot>();
    private Iterator<VarStackSnapshot> snapshotsIterator = this.snapshots.iterator();

    public void visitVarInsn(int var) {
        this.indices.add(var);
    }

    public void takeSnapshotOfVarsAtPutfield() {
        this.snapshots.add(new VarStackSnapshot(this.indices));
        this.snapshotsIterator = this.snapshots.iterator();
    }

    public VarStackSnapshot next() {
        return this.snapshotsIterator.next();
    }

    public static class VarStackSnapshot {
        private final List<Integer> indices;

        public VarStackSnapshot(List<Integer> indices) {
            this.indices = Collections.unmodifiableList(new ArrayList<Integer>(indices));
        }

        public boolean thisObjectWasAddedToStack() {
            return this.indices.contains(0);
        }

        public int indexOfOwningObject() {
            int stackSpaceToLookBack = 1;
            return this.indices.get(this.indices.size() - 1 - stackSpaceToLookBack);
        }
    }
}

