/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.info;

import java.util.HashMap;
import java.util.Map;
import org.mutabilitydetector.checkers.info.AnalysisInformation;
import org.mutabilitydetector.checkers.info.InformationRetrievalRunner;
import org.mutabilitydetector.checkers.info.MethodIdentifier;
import org.mutabilitydetector.checkers.util.PrivateMethodInvocationAnalyser;
import org.mutabilitydetector.locations.ClassIdentifier;
import org.mutabilitydetector.locations.Dotted;

public final class PrivateMethodInvocationInformation
implements AnalysisInformation {
    private final Map<Dotted, PrivateMethodInvocationAnalyser> checkerCache = new HashMap<Dotted, PrivateMethodInvocationAnalyser>();
    private final InformationRetrievalRunner sessionCheckerRunner;

    public PrivateMethodInvocationInformation(InformationRetrievalRunner sessionCheckerRunner) {
        this.sessionCheckerRunner = sessionCheckerRunner;
    }

    public boolean isOnlyCalledFromConstructor(MethodIdentifier forMethod) {
        PrivateMethodInvocationAnalyser checker;
        if (this.checkerCache.containsKey(forMethod.dottedClassName())) {
            checker = this.checkerCache.get(forMethod.dottedClassName());
        } else {
            checker = new PrivateMethodInvocationAnalyser();
            this.sessionCheckerRunner.run(checker, ClassIdentifier.forClass(forMethod.dottedClassName()));
            this.checkerCache.put(forMethod.dottedClassName(), checker);
        }
        return this.result(checker, forMethod);
    }

    private boolean result(PrivateMethodInvocationAnalyser checker, MethodIdentifier forMethod) {
        return checker.isPrivateMethodCalledOnlyFromConstructor(forMethod.methodDescriptor());
    }
}

