/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.ThreadSafe;
import org.mutabilitydetector.checkers.settermethod.CandidatesInitialisersMapping;
import org.mutabilitydetector.checkers.settermethod.Finder;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;

@ThreadSafe
final class InitialisersFinder
implements Finder<CandidatesInitialisersMapping> {
    private final Collection<MethodNode> methods;
    private final CandidatesInitialisersMapping candidatesInitialisersMapping;
    private volatile boolean areMethodsAlreadyExamined;

    private InitialisersFinder(Collection<MethodNode> theMethods, CandidatesInitialisersMapping theVariableInitialisersMapping) {
        this.methods = Collections.unmodifiableCollection(theMethods);
        this.candidatesInitialisersMapping = theVariableInitialisersMapping;
        this.areMethodsAlreadyExamined = false;
    }

    public static InitialisersFinder newInstance(Collection<MethodNode> methodsOfAnalysedClass, CandidatesInitialisersMapping candidatesInitialisersMapping) {
        String msgTemplate = "Argument '%s' must not be null!";
        Preconditions.checkNotNull(methodsOfAnalysedClass, String.format("Argument '%s' must not be null!", "methodsOfAnalysedClass"));
        Preconditions.checkNotNull(candidatesInitialisersMapping, String.format("Argument '%s' must not be null!", "variableInitialiserMapping"));
        return new InitialisersFinder(methodsOfAnalysedClass, candidatesInitialisersMapping);
    }

    @Override
    public CandidatesInitialisersMapping find() {
        if (this.areMethodsToBeExamined()) {
            this.collectAllInitialisingMethodsForAllLazyVariableCandidates();
            this.areMethodsAlreadyExamined = true;
        }
        return this.candidatesInitialisersMapping;
    }

    private boolean areMethodsToBeExamined() {
        return !this.areMethodsAlreadyExamined;
    }

    private void collectAllInitialisingMethodsForAllLazyVariableCandidates() {
        for (MethodNode methodNode : this.methods) {
            this.addMethodNodeIfIsInitialiserForVariable(methodNode);
        }
    }

    private void addMethodNodeIfIsInitialiserForVariable(MethodNode methodNode) {
        for (AbstractInsnNode insn : methodNode.instructions.toArray()) {
            if (!InitialisersFinder.isInitialiserForAVariable(insn)) continue;
            FieldInsnNode assignmentInstruction = (FieldInsnNode)insn;
            this.candidatesInitialisersMapping.addInitialiserForCandidate(assignmentInstruction.name, methodNode);
        }
    }

    private static boolean isInitialiserForAVariable(AbstractInsnNode insn) {
        return InitialisersFinder.isPutfieldInstruction(insn) || InitialisersFinder.isPutstaticInstruction(insn);
    }

    private static boolean isPutfieldInstruction(AbstractInsnNode insn) {
        return 181 == insn.getOpcode();
    }

    private static boolean isPutstaticInstruction(AbstractInsnNode insn) {
        return 179 == insn.getOpcode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append(" [methods=").append(this.methods);
        b.append(", variableSetterMapping=").append(this.candidatesInitialisersMapping);
        b.append(", areMethodsAlreadyExamined=").append(this.areMethodsAlreadyExamined).append(']');
        return b.toString();
    }
}

