/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.classloading;

import java.util.concurrent.ExecutionException;
import org.mutabilitydetector.classloading.AnalysisClassLoader;
import org.mutabilitydetector.internal.com.google.common.cache.Cache;
import org.mutabilitydetector.internal.com.google.common.cache.CacheBuilder;

public final class CachingAnalysisClassLoader
implements AnalysisClassLoader {
    private final Cache<String, Class<?>> cache = CacheBuilder.newBuilder().recordStats().build();
    private final AnalysisClassLoader classLoader;

    public CachingAnalysisClassLoader(AnalysisClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> loadClass(String dottedClass) throws ClassNotFoundException {
        try {
            return this.cache.get(dottedClass, () -> this.classLoader.loadClass(dottedClass));
        }
        catch (ExecutionException e) {
            throw new ClassNotFoundException("Error loading class: " + dottedClass, e.getCause());
        }
    }
}

