/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.cli;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.cli.BatchAnalysisOptions;
import org.mutabilitydetector.cli.CommandLineOptionsException;
import org.mutabilitydetector.cli.OptionParserHelper;
import org.mutabilitydetector.cli.ParsingAction;
import org.mutabilitydetector.internal.org.apache.commons.cli.CommandLine;
import org.mutabilitydetector.internal.org.apache.commons.cli.HelpFormatter;
import org.mutabilitydetector.internal.org.apache.commons.cli.Option;
import org.mutabilitydetector.internal.org.apache.commons.cli.OptionBuilder;
import org.mutabilitydetector.internal.org.apache.commons.cli.Options;

public class CommandLineOptions
implements BatchAnalysisOptions {
    private String classpath;
    private final Options options;
    private String match;
    private boolean verbose = false;
    private ReportMode reportMode;
    private File classListFile;
    private boolean isUsingClassList;
    private boolean reportErrors;
    private boolean failFast = false;
    private boolean showSummary = false;
    private final PrintStream errorStream;
    private AsmVerifierFactory.ClassloadingOption classloadingOption;

    public CommandLineOptions(PrintStream errorStream, String ... args) {
        this.errorStream = errorStream;
        this.options = this.createOptions();
        this.parseOptions(args);
    }

    public CommandLineOptions(PrintStream errorStream, List<String> args) {
        this(errorStream, args.toArray(new String[args.size()]));
    }

    private Options createOptions() {
        Options opts = new Options();
        CommandLineOptions.createAndAddOption(opts, "path", "The classpath to be analysed by Mutability Detector", "classpath", "cp");
        CommandLineOptions.createAndAddOption(opts, "regex", "A regular expression used to match class names to analyse. This is matched against the fully qualified class name, minus the .class suffix (i.e. it matches against 'java.lang.Object', not 'java/lang/Object.class'). The default is '.*', meaning all classes will be analysed.", "match", "m");
        CommandLineOptions.createAndAddOption(opts, "filename", "Only report results on the classes listed within <filename>. Currently this option only supports plain text files with one class per line. It is also rather limited in the format it accepts: each line must contain the equivalent of someClass.getName(), e.g. it must be java.lang.Integer, with dot delimiters and no suffixes such as .java or .class. Can be used in conjunction with -match to reduce the time taken to perform analysis.", "classlist", "cl");
        opts.addOption("s", "summary", false, "Show summary of analysis result.");
        opts.addOption("v", "verbose", false, "Print details of analysis and reasons for results.");
        opts.addOption("r", "report", true, "Choose what is reported from the analysis. Valid options are " + ReportMode.validModes() + ". If not specified, or doesn't match an available mode, defaults to 'ALL'");
        opts.addOption("h", "help", false, "print this message");
        opts.addOption("e", "reportErrors", false, "Reports on errors in the analysis. Defaults to false.");
        opts.addOption("f", "failFast", false, "When true, encountering an unhandled exception will cause analysis to abort immediately. When false, exceptions during analysis of a particular class will be reflected in the result assigned to that class. Defaults to false.");
        opts.addOption("n", "nonClassloading", false, "When supplied, use an implementation of ASM's SimpleVerifier that does not load classes. This can help avoid issues encountered with class loading. Warning: this is experimental, and has not been tested as thoroughly as the classloading version.");
        return opts;
    }

    private static void createAndAddOption(Options opts, String argumentName, String description, String argumentFlag, String shortFlag) {
        OptionBuilder.withArgName(argumentName);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(description);
        OptionBuilder.withLongOpt(argumentFlag);
        Option newOption = OptionBuilder.create(shortFlag);
        opts.addOption(newOption);
    }

    private void parseOptions(String[] args) {
        OptionParserHelper parser = new OptionParserHelper(this.options, args);
        try {
            parser.parseOptions(new ParsingActionImplementation());
        }
        catch (CommandLineOptionsException cloe) {
            this.errorStream.println(cloe.getMessage());
            throw cloe;
        }
        catch (Exception e) {
            this.printHelpAndExit();
        }
    }

    private void extractReportMode(CommandLine line) {
        if (line.hasOption("r") || line.hasOption("report")) {
            String mode = line.getOptionValue("report");
            this.reportMode = Enum.valueOf(ReportMode.class, mode.toUpperCase());
        } else {
            this.reportMode = ReportMode.ALL;
        }
    }

    private void extractShowSummaryOption(CommandLine line) {
        this.showSummary = line.hasOption("s") || line.hasOption("summary");
    }

    private void extractUseExperimentalAsmNonClassloadingSimpleVerifier(CommandLine line) {
        this.classloadingOption = line.hasOption("n") || line.hasOption("nonClassloading") ? AsmVerifierFactory.ClassloadingOption.DISABLED : AsmVerifierFactory.ClassloadingOption.ENABLED;
    }

    private void extractVerboseOption(CommandLine line) {
        if (line.hasOption("v") || line.hasOption("verbose")) {
            this.verbose = true;
        }
    }

    private void extractClasspath(CommandLine line) {
        this.classpath = line.getOptionValue("classpath", ".");
    }

    private void extractMatch(CommandLine line) {
        this.match = line.getOptionValue("match", ".*");
    }

    private void extractClassListFile(CommandLine line) {
        if (line.hasOption("classlist")) {
            String fileName = line.getOptionValue("classlist");
            this.classListFile = new File(fileName);
            this.isUsingClassList = true;
            this.throwExceptionIfClassListFileIsInvalid();
        }
    }

    private void throwExceptionIfClassListFileIsInvalid() {
        StringBuilder reasons = new StringBuilder();
        boolean isInvalid = false;
        if (!this.classListFile.exists()) {
            isInvalid = true;
            reasons.append("File does not exist.");
        }
        if (this.classListFile.isDirectory()) {
            isInvalid = true;
            reasons.append("Specified file is a directory.");
        }
        if (this.unreadableClassFileListExists()) {
            isInvalid = true;
            reasons.append("File exists but cannot be read from.");
        }
        if (isInvalid) {
            String message = String.format("Could not read class list from file [%s]: ", this.classListFile.getName());
            reasons.insert(0, message);
            throw new CommandLineOptionsException(reasons.toString());
        }
    }

    private boolean unreadableClassFileListExists() {
        return this.classListFile.exists() && !this.classListFile.canRead();
    }

    private void extractShowErrorsOption(CommandLine line) {
        this.reportErrors = line.hasOption("e") || line.hasOption("showErrors");
    }

    private void extractFailFastOption(CommandLine line) {
        this.failFast = line.hasOption("failFast");
    }

    private void printHelpIfRequired(CommandLine line) {
        if (line.hasOption("help")) {
            this.printHelpAndExit();
        }
    }

    private void printHelpIfNoOptionsGiven(CommandLine line) {
        if (line.getOptions().length == 0) {
            this.printHelpAndExit();
        }
    }

    private void printHelpAndExit() {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("MutabilityDetector", this.options);
        this.exit();
    }

    private void exit() {
        throw new CommandLineOptionsException("");
    }

    @Override
    public String classpath() {
        return this.classpath;
    }

    @Override
    public String match() {
        return this.match;
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public boolean showSummary() {
        return this.showSummary;
    }

    @Override
    public ReportMode reportMode() {
        return this.reportMode;
    }

    @Override
    public File classListFile() {
        return this.classListFile;
    }

    @Override
    public boolean isUsingClassList() {
        return this.isUsingClassList;
    }

    @Override
    public boolean reportErrors() {
        return this.reportErrors;
    }

    @Override
    public boolean failFast() {
        return this.failFast;
    }

    @Override
    public AsmVerifierFactory.ClassloadingOption classloading() {
        return this.classloadingOption;
    }

    public static enum ReportMode {
        ALL,
        IMMUTABLE,
        MUTABLE;


        public static String validModes() {
            StringBuilder modes = new StringBuilder();
            modes.append('[');
            for (ReportMode m : ReportMode.values()) {
                modes.append(m.name());
                modes.append('|');
            }
            modes.deleteCharAt(modes.length() - 1);
            modes.append(']');
            return modes.toString();
        }
    }

    private final class ParsingActionImplementation
    implements ParsingAction {
        private ParsingActionImplementation() {
        }

        @Override
        public void doParsingAction(CommandLine line) {
            CommandLineOptions.this.printHelpIfRequired(line);
            CommandLineOptions.this.extractClasspath(line);
            CommandLineOptions.this.extractMatch(line);
            CommandLineOptions.this.extractVerboseOption(line);
            CommandLineOptions.this.extractReportMode(line);
            CommandLineOptions.this.extractClassListFile(line);
            CommandLineOptions.this.extractShowErrorsOption(line);
            CommandLineOptions.this.extractFailFastOption(line);
            CommandLineOptions.this.extractShowSummaryOption(line);
            CommandLineOptions.this.extractUseExperimentalAsmNonClassloadingSimpleVerifier(line);
            CommandLineOptions.this.printHelpIfNoOptionsGiven(line);
        }
    }
}

