/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.locations;

import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.locations.Slashed;

@Immutable
public final class ClassNameConverter {
    public static final ClassNameConverter CONVERTER = new ClassNameConverter();
    private static final Function<String, String> SINGLE_DIMENSIONAL_IF_ARRAY = s -> s.replaceAll("\\[+", "[");
    private static final Function<String, String> REMOVE_ARRAY_DESCRIPTOR_IF_REFERENCE_TYPE = s -> s.startsWith("[L") ? s.replace("[L", "") : s;
    private static final Function<String, String> REMOVE_REFERENCE_DESCRIPTOR_IF_REFERENCE_TYPE = s -> s.startsWith("L") ? s.substring(1) : s;
    private static final Function<String, String> REMOVE_CLASS_EXTENSION = s -> s.endsWith(".class") ? s.replace(".class", "") : s;
    private static final Function<String, String> REMOVE_TRAILING_SEMICOLON = s -> s.replace(";", "");
    private static final Function<String, String> REPLACE_SLASHES_WITH_DOTS = s -> s.replace("/", ".");

    public String dotted(String givenClassName) {
        return SINGLE_DIMENSIONAL_IF_ARRAY.andThen(REMOVE_ARRAY_DESCRIPTOR_IF_REFERENCE_TYPE).andThen(REMOVE_REFERENCE_DESCRIPTOR_IF_REFERENCE_TYPE).andThen(REMOVE_CLASS_EXTENSION).andThen(REMOVE_TRAILING_SEMICOLON).andThen(REPLACE_SLASHES_WITH_DOTS).apply(givenClassName);
    }

    public String toInternal(Dotted dotted) {
        return "L" + dotted.asSimpleString().replace(".", "/") + ";";
    }

    public String toInternal(Slashed slashed) {
        return "L" + slashed.asSimpleString() + ";";
    }
}

