/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.unittesting;

import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.AnalysisSession;
import org.mutabilitydetector.Configuration;
import org.mutabilitydetector.ConfigurationBuilder;
import org.mutabilitydetector.DefaultCachingAnalysisSession;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.asmoverride.ClassLoadingVerifierFactory;
import org.mutabilitydetector.asmoverride.NonClassLoadingVerifierFactory;
import org.mutabilitydetector.checkers.ClassPathBasedCheckerRunnerFactory;
import org.mutabilitydetector.checkers.MutabilityCheckerFactory;
import org.mutabilitydetector.classloading.CachingAnalysisClassLoader;
import org.mutabilitydetector.classloading.ClassForNameWrapper;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.com.google.classpath.ClassPathFactory;
import org.mutabilitydetector.internal.com.google.common.collect.Lists;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.unittesting.MutabilityMatchers;
import org.mutabilitydetector.unittesting.internal.AssertionReporter;
import org.mutabilitydetector.unittesting.matchers.reasons.WithAllowedReasonsMatcher;

public class MutabilityAsserter {
    private final AssertionReporter reporter;
    private final AnalysisSession analysisSession;

    private MutabilityAsserter(AssertionReporter reporter, AnalysisSession analysisSession) {
        this.reporter = reporter;
        this.analysisSession = analysisSession;
    }

    public static MutabilityAsserter configured(Configuration configuration) {
        ClassPath classpath = new ClassPathFactory().createFromJVM();
        AsmVerifierFactory verifierFactory = configuration.classloadingOption() == AsmVerifierFactory.ClassloadingOption.ENABLED ? new ClassLoadingVerifierFactory(new CachingAnalysisClassLoader(new ClassForNameWrapper())) : new NonClassLoadingVerifierFactory(classpath);
        AnalysisSession analysisSession = DefaultCachingAnalysisSession.createWithGivenClassPath(classpath, new ClassPathBasedCheckerRunnerFactory(classpath, configuration.exceptionPolicy()), new MutabilityCheckerFactory(MutabilityCheckerFactory.ReassignedFieldAnalysisChoice.NAIVE_PUT_FIELD_ANALYSIS, configuration.immutableContainerClasses()), verifierFactory, configuration);
        return new MutabilityAsserter(new AssertionReporter(), analysisSession);
    }

    public static MutabilityAsserter configured(ConfigurationBuilder configuration) {
        return MutabilityAsserter.configured(configuration.build());
    }

    public void assertImmutable(Class<?> expectedImmutableClass) {
        this.reporter.assertThat(this.getResultFor(expectedImmutableClass), WithAllowedReasonsMatcher.withNoAllowedReasons(MutabilityMatchers.areImmutable()));
    }

    public void assertInstancesOf(Class<?> clazz, Matcher<AnalysisResult> mutabilityMatcher) {
        this.reporter.assertThat(this.getResultFor(clazz), WithAllowedReasonsMatcher.withNoAllowedReasons(mutabilityMatcher));
    }

    public void assertInstancesOf(Class<?> clazz, Matcher<AnalysisResult> mutabilityMatcher, Matcher<MutableReasonDetail> allowing) {
        WithAllowedReasonsMatcher areImmutable_withReasons = WithAllowedReasonsMatcher.withAllowedReasons(mutabilityMatcher, Arrays.asList(allowing));
        this.reporter.assertThat(this.getResultFor(clazz), areImmutable_withReasons);
    }

    public void assertInstancesOf(Class<?> clazz, Matcher<AnalysisResult> mutabilityMatcher, Matcher<MutableReasonDetail> allowingFirst, Matcher<MutableReasonDetail> allowingSecond) {
        WithAllowedReasonsMatcher areImmutable_withReasons = WithAllowedReasonsMatcher.withAllowedReasons(mutabilityMatcher, Arrays.asList(allowingFirst, allowingSecond));
        this.reporter.assertThat(this.getResultFor(clazz), areImmutable_withReasons);
    }

    public void assertInstancesOf(Class<?> clazz, Matcher<AnalysisResult> mutabilityMatcher, Matcher<MutableReasonDetail> allowingFirst, Matcher<MutableReasonDetail> allowingSecond, Matcher<MutableReasonDetail> allowingThird) {
        WithAllowedReasonsMatcher areImmutable_withReasons = WithAllowedReasonsMatcher.withAllowedReasons(mutabilityMatcher, Arrays.asList(allowingFirst, allowingSecond, allowingThird));
        this.reporter.assertThat(this.getResultFor(clazz), areImmutable_withReasons);
    }

    public void assertInstancesOf(Class<?> clazz, Matcher<AnalysisResult> mutabilityMatcher, Matcher<MutableReasonDetail> allowingFirst, Matcher<MutableReasonDetail> allowingSecond, Matcher<MutableReasonDetail> allowingThird, Matcher<MutableReasonDetail> ... allowingRest) {
        ArrayList<Matcher<MutableReasonDetail>> allowedReasonMatchers = new ArrayList<Matcher<MutableReasonDetail>>();
        allowedReasonMatchers.add(allowingFirst);
        allowedReasonMatchers.add(allowingSecond);
        allowedReasonMatchers.add(allowingThird);
        allowedReasonMatchers.addAll(Arrays.asList(allowingRest));
        WithAllowedReasonsMatcher areImmutable_withReasons = WithAllowedReasonsMatcher.withAllowedReasons(mutabilityMatcher, allowedReasonMatchers);
        this.reporter.assertThat(this.getResultFor(clazz), areImmutable_withReasons);
    }

    public void assertInstancesOf(Class<?> clazz, Matcher<AnalysisResult> mutabilityMatcher, Iterable<Matcher<MutableReasonDetail>> allowingAll) {
        ArrayList<Matcher<MutableReasonDetail>> allowedReasonMatchers = Lists.newArrayList(allowingAll);
        WithAllowedReasonsMatcher areImmutable_withReasons = WithAllowedReasonsMatcher.withAllowedReasons(mutabilityMatcher, allowedReasonMatchers);
        this.reporter.assertThat(this.getResultFor(clazz), areImmutable_withReasons);
    }

    private AnalysisResult getResultFor(Class<?> clazz) {
        return this.analysisSession.resultFor(Dotted.fromClass(clazz));
    }
}

