/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mutabilitydetector.internal.com.google.common.base.MoreObjects;
import org.mutabilitydetector.internal.com.google.common.base.Objects;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.signature.SignatureReader;
import org.mutabilitydetector.internal.org.objectweb.asm.signature.SignatureVisitor;
import org.mutabilitydetector.locations.ClassName;
import org.mutabilitydetector.locations.Dotted;

public abstract class CollectionField {
    public final Dotted collectionType;
    public final Node root;

    public List<GenericType> getGenericParameterTypes() {
        if (this.root.children.isEmpty()) {
            return null;
        }
        ArrayList<GenericType> genericParameters = new ArrayList<GenericType>();
        this.putAllChildren(this.root, genericParameters);
        return Collections.unmodifiableList(new ArrayList<GenericType>(genericParameters));
    }

    private void putAllChildren(Node root, List<GenericType> genericParameters) {
        for (Node child : root.children) {
            genericParameters.add(child.type);
            this.putAllChildren(child, genericParameters);
        }
    }

    public abstract boolean isGeneric();

    public abstract String asString();

    public abstract String asSimpleString();

    protected CollectionField(Dotted collectionType, Node root) {
        this.collectionType = collectionType;
        this.root = root;
    }

    public static CollectionField from(String collectionType, String signature) {
        if (signature == null) {
            return new RawCollection(Dotted.dotted(collectionType));
        }
        GenericCollectionVisitor collectionTypeReader = new GenericCollectionVisitor(Dotted.dotted(collectionType));
        new SignatureReader(signature).accept(collectionTypeReader);
        return new GenericCollection(((GenericCollectionVisitor)collectionTypeReader).state.collectionType, collectionTypeReader.root);
    }

    public abstract CollectionField transformGenericTree(Function<GenericType, GenericType> var1);

    private static final class Node {
        public final List<Node> children = new ArrayList<Node>();
        public final GenericType type;

        public static Node dummyRoot() {
            return new Node(null);
        }

        public Node(GenericType type) {
            this.type = type;
        }

        public void addChild(Node child) {
            this.children.add(Preconditions.checkNotNull(child));
        }

        public String asString() {
            return this.asStringUsingFunctions(Object::toString, Object::toString);
        }

        public String asSimpleString() {
            return this.asStringUsingFunctions(GenericType::asSimpleString, Node::asSimpleString);
        }

        private String asStringUsingFunctions(Function<? super GenericType, String> genericTypeStringFunction, Function<? super Node, String> nodeStringFunction) {
            String childrenPart = "";
            if (this.children.size() > 0) {
                childrenPart = this.children.stream().map(nodeStringFunction).collect(Collectors.joining(", ", "<", ">"));
            }
            return genericTypeStringFunction.apply(this.type) + childrenPart;
        }

        public String toString() {
            return this.asString();
        }
    }

    public static class GenericType {
        public final Dotted type;
        public final String wildcard;
        public final boolean isVariable;
        public final boolean isArray;

        public GenericType(Dotted type, String wildcard, boolean isVariable, boolean isArray) {
            this.type = type;
            this.wildcard = Preconditions.checkNotNull(wildcard, "wildcard");
            this.isVariable = isVariable;
            this.isArray = isArray;
        }

        public static GenericType wildcard() {
            return new GenericType(null, "?", false, false);
        }

        public static GenericType exact(Dotted type) {
            return new GenericType(type, "=", false, false);
        }

        public static GenericType extends_(Dotted type) {
            return new GenericType(type, "+", false, false);
        }

        public static GenericType super_(Dotted type) {
            return new GenericType(type, "-", false, false);
        }

        public int hashCode() {
            return Objects.hashCode(this.type, this.wildcard);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericType other = (GenericType)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.wildcard == null ? other.wildcard != null : !this.wildcard.equals(other.wildcard));
        }

        public String toString() {
            return this.toStringWithFunction(Object::toString);
        }

        public String asSimpleString() {
            return this.toStringWithFunction(ClassName::asSimpleString);
        }

        private String toStringWithFunction(Function<? super Dotted, String> toStringFunction) {
            if (this.type == null) {
                return this.wildcard;
            }
            if (this.wildcard.equals("=")) {
                return toStringFunction.apply(this.type);
            }
            if (this.wildcard.equals("+")) {
                return "? extends " + toStringFunction.apply(this.type);
            }
            if (this.wildcard.equals("-")) {
                return "? super " + toStringFunction.apply(this.type);
            }
            throw new IllegalStateException();
        }

        public GenericType withoutWildcard() {
            if ("?".equals(this.wildcard)) {
                return new GenericType(Dotted.fromClass(Object.class), "=", false, false);
            }
            return new GenericType(this.type, "=", false, false);
        }
    }

    private static class GenericCollectionVisitor
    extends SignatureVisitor {
        public static final String OBJECT_ARRAY_PREFIX = "[L";
        public static final String PRIMITIVE_ARRAY_PREFIX = "[";
        private GenericCollectionReaderState state;
        private Node root;
        private Node lastStored;

        public GenericCollectionVisitor(Dotted collectionType) {
            super(458752);
            this.state = new GenericCollectionReaderState();
            this.root = new Node(GenericType.exact(collectionType));
        }

        private GenericCollectionVisitor(GenericCollectionReaderState state, Node root) {
            super(458752);
            this.state = state;
            this.root = root;
        }

        @Override
        public void visitClassType(String name) {
            if (!this.state.seenOuterCollectionType) {
                this.state.collectionType = Dotted.dotted(name);
                this.state.seenOuterCollectionType = true;
            } else {
                this.state.elementType = this.state.isElementTypeArray ? Dotted.dotted(OBJECT_ARRAY_PREFIX + name) : Dotted.dotted(name);
                this.storeNode();
            }
        }

        @Override
        public void visitTypeVariable(String name) {
            this.state.typeVariable = Dotted.dotted(name);
            this.storeNode();
        }

        @Override
        public void visitTypeArgument() {
            this.state.wildcard = "?";
            this.state.elementType = null;
            this.storeNode();
        }

        @Override
        public void visitBaseType(char descriptor) {
            if (!this.state.isElementTypeArray) {
                throw new IllegalStateException("It shouldn't happen. Java doesn't support primitive generic types");
            }
            this.state.elementType = Dotted.dotted(PRIMITIVE_ARRAY_PREFIX + descriptor);
            this.storeNode();
        }

        @Override
        public SignatureVisitor visitArrayType() {
            this.state.isElementTypeArray = true;
            return this.withRoot(MoreObjects.firstNonNull(this.lastStored, this.root));
        }

        @Override
        public SignatureVisitor visitTypeArgument(char wildcard) {
            this.state.wildcard = String.valueOf(wildcard);
            return this.withRoot(MoreObjects.firstNonNull(this.lastStored, this.root));
        }

        private void storeNode() {
            this.lastStored = new Node(this.createGenericType());
            this.root.addChild(this.lastStored);
        }

        private GenericType createGenericType() {
            boolean isVariable = this.state.typeVariable != null;
            return new GenericType(isVariable ? this.state.typeVariable : this.state.elementType, this.state.wildcard, isVariable, this.state.isElementTypeArray);
        }

        private GenericCollectionVisitor withRoot(Node newRoot) {
            return new GenericCollectionVisitor(this.state, newRoot);
        }

        private static final class GenericCollectionReaderState {
            protected Dotted collectionType;
            protected Dotted elementType;
            protected Dotted typeVariable;
            protected String wildcard;
            protected boolean seenOuterCollectionType = false;
            boolean isElementTypeArray = false;

            private GenericCollectionReaderState() {
            }
        }
    }

    private static final class GenericCollection
    extends CollectionField {
        public GenericCollection(Dotted collectionType, Node root) {
            super(collectionType, root);
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public String asString() {
            return this.root.asString();
        }

        @Override
        public String asSimpleString() {
            return this.root.asSimpleString();
        }

        @Override
        public CollectionField transformGenericTree(Function<GenericType, GenericType> function) {
            Node newRoot = this.transformNode(this.root, function);
            return new GenericCollection(this.collectionType, newRoot);
        }

        private Node transformNode(Node node, Function<GenericType, GenericType> function) {
            Node transformed = new Node(function.apply(node.type));
            for (Node child : node.children) {
                transformed.addChild(this.transformNode(child, function));
            }
            return transformed;
        }
    }

    private static final class RawCollection
    extends CollectionField {
        private RawCollection(Dotted collectionType) {
            super(collectionType, Node.dummyRoot());
        }

        @Override
        public boolean isGeneric() {
            return false;
        }

        @Override
        public String asString() {
            return "raw " + this.collectionType.asString();
        }

        @Override
        public String asSimpleString() {
            return "raw " + this.collectionType.asSimpleString();
        }

        @Override
        public CollectionField transformGenericTree(Function<GenericType, GenericType> function) {
            return this;
        }
    }
}

