/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.misc;

import java.lang.management.ManagementFactory;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;

public final class TimingUtil {
    private final Clock jvmStartTimeClock;
    private final Clock currentTimeClock;

    public TimingUtil() {
        long jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        this.jvmStartTimeClock = Clock.fixed(Instant.ofEpochMilli(jvmStartTime), ZoneId.systemDefault());
        this.currentTimeClock = Clock.systemDefaultZone();
    }

    public long getCurrentTimeMillis() {
        return this.currentTimeClock.millis();
    }

    public long getVMStartTimeMillis() {
        return this.jvmStartTimeClock.millis();
    }
}

