/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.unittesting.matchers.reasons;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.internal.com.google.common.collect.Iterables;
import org.mutabilitydetector.locations.CodeLocation;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.unittesting.matchers.reasons.BaseMutableReasonDetailMatcher;

public final class ProvidedOtherClass {
    private final Iterable<Dotted> dottedClassNames;

    private ProvidedOtherClass(Iterable<Dotted> dottedClassName) {
        this.dottedClassNames = dottedClassName;
    }

    public static ProvidedOtherClass provided(Dotted className) {
        return ProvidedOtherClass.provided(Collections.singleton(className));
    }

    public static ProvidedOtherClass provided(Dotted ... classNames) {
        return ProvidedOtherClass.provided(Arrays.asList(classNames));
    }

    public static ProvidedOtherClass provided(Iterable<Dotted> classNames) {
        return new ProvidedOtherClass(classNames);
    }

    public Matcher<MutableReasonDetail> isAlsoImmutable() {
        AllowedIfOtherClassIsGenericTypeOfCollectionField allowGenericTypes = new AllowedIfOtherClassIsGenericTypeOfCollectionField(this.dottedClassNames);
        return AnyOf.anyOf(allowGenericTypes, AnyOf.anyOf(Iterables.transform(this.dottedClassNames, AllowedIfOtherClassIsImmutable::new)), new AllowedIfOtherClassIsGenericTypeParameter(this.dottedClassNames));
    }

    public Matcher<MutableReasonDetail> areAlsoImmutable() {
        return this.isAlsoImmutable();
    }

    private static final class AllowedIfOtherClassIsGenericTypeParameter
    extends BaseMutableReasonDetailMatcher {
        private final Iterable<Dotted> classNames;

        public AllowedIfOtherClassIsGenericTypeParameter(Iterable<Dotted> classNames) {
            if (classNames == null) {
                throw new IllegalArgumentException("classNames cannot be null");
            }
            this.classNames = classNames;
        }

        @Override
        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            CodeLocation<?> codeLocation = reasonDetail.codeLocation();
            if (reasonDetail.reason().isOneOf(MutabilityReason.MUTABLE_TYPE_TO_FIELD) && codeLocation instanceof CodeLocation.FieldLocation) {
                CodeLocation.FieldLocation location = (CodeLocation.FieldLocation)reasonDetail.codeLocation();
                Dotted fieldType = location.fieldType();
                return StreamSupport.stream(this.classNames.spliterator(), false).anyMatch(fieldType::equals);
            }
            return false;
        }
    }

    private static final class AllowedIfOtherClassIsGenericTypeOfCollectionField
    extends BaseMutableReasonDetailMatcher {
        private final Iterable<Dotted> classNames;

        public AllowedIfOtherClassIsGenericTypeOfCollectionField(Iterable<Dotted> classNames) {
            this.classNames = classNames;
        }

        @Override
        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            return this.allowedIfCollectionTypeWhereAllGenericElementsAreConsideredImmutable(reasonDetail);
        }

        private boolean allowedIfCollectionTypeWhereAllGenericElementsAreConsideredImmutable(MutableReasonDetail reasonDetail) {
            return reasonDetail.reason().isOneOf(MutabilityReason.COLLECTION_FIELD_WITH_MUTABLE_ELEMENT_TYPE) && this.allElementTypesAreConsideredImmutable(reasonDetail.message());
        }

        private boolean allElementTypesAreConsideredImmutable(String message) {
            String[] genericsTypesDescription;
            String[] stringArray;
            String fieldTypeDescription = message.substring(message.indexOf("("), message.indexOf(")") + 1);
            String generics = fieldTypeDescription.substring(fieldTypeDescription.indexOf("<") + 1, fieldTypeDescription.lastIndexOf(">"));
            if (generics.contains(", ")) {
                stringArray = generics.split(", ");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = generics;
            }
            for (String genericType : genericsTypesDescription = stringArray) {
                if (Iterables.contains(this.classNames, Dotted.dotted(genericType))) continue;
                return false;
            }
            return true;
        }
    }

    private static final class AllowedIfOtherClassIsImmutable
    extends BaseMutableReasonDetailMatcher {
        private final Dotted className;

        public AllowedIfOtherClassIsImmutable(Dotted dottedClassName) {
            this.className = dottedClassName;
        }

        @Override
        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            return this.isAssignedField(reasonDetail);
        }

        private boolean isAssignedField(MutableReasonDetail reasonDetail) {
            return reasonDetail.reason().isOneOf(MutabilityReason.ABSTRACT_TYPE_TO_FIELD, MutabilityReason.MUTABLE_TYPE_TO_FIELD) && reasonDetail.message().contains(this.classNameAsItAppearsInDescription());
        }

        private String classNameAsItAppearsInDescription() {
            return "(" + this.className.asString() + ")";
        }
    }
}

