/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mutabilitydetector.IsImmutable;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.CollectionTypeWrappedInUnmodifiableIdiomChecker;
import org.mutabilitydetector.checkers.FieldAssignmentVisitor;
import org.mutabilitydetector.checkers.info.AnalysisInProgress;
import org.mutabilitydetector.checkers.info.CyclicReferences;
import org.mutabilitydetector.checkers.info.MutableTypeInformation;
import org.mutabilitydetector.checkers.info.TypeStructureInformation;
import org.mutabilitydetector.internal.com.google.common.base.Joiner;
import org.mutabilitydetector.internal.com.google.common.base.Optional;
import org.mutabilitydetector.internal.com.google.common.collect.Lists;
import org.mutabilitydetector.internal.com.google.common.collect.Maps;
import org.mutabilitydetector.internal.org.objectweb.asm.FieldVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.MethodVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.signature.SignatureReader;
import org.mutabilitydetector.internal.org.objectweb.asm.signature.SignatureVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.BasicValue;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Frame;
import org.mutabilitydetector.locations.CodeLocation;
import org.mutabilitydetector.locations.Dotted;

public final class MutableTypeToFieldChecker
extends AsmMutabilityChecker {
    private final TypeStructureInformation typeStructureInformation;
    private final MutableTypeInformation mutableTypeInfo;
    private final AsmVerifierFactory verifierFactory;
    private final Set<Dotted> immutableContainerClasses;
    private final List<String> genericTypesOfClass = Lists.newLinkedList();
    private final Map<String, String> genericFields = Maps.newHashMap();
    private final AnalysisInProgress analysisInProgress;
    private final Map<String, String> typeSignatureByFieldName = Maps.newHashMap();

    public MutableTypeToFieldChecker(TypeStructureInformation info, MutableTypeInformation mutableTypeInfo, AsmVerifierFactory verifierFactory, Set<Dotted> immutableContainerClasses, AnalysisInProgress analysisInProgress) {
        this.typeStructureInformation = info;
        this.mutableTypeInfo = mutableTypeInfo;
        this.verifierFactory = verifierFactory;
        this.immutableContainerClasses = immutableContainerClasses;
        this.analysisInProgress = analysisInProgress;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (signature == null) {
            return;
        }
        new SignatureReader(signature).accept(new SignatureVisitor(327680){

            @Override
            public void visitFormalTypeParameter(String name) {
                MutableTypeToFieldChecker.this.genericTypesOfClass.add(name);
            }
        });
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            return null;
        }
        this.typeSignatureByFieldName.put(name, signature);
        GenericFieldVisitor visitor = new GenericFieldVisitor();
        new SignatureReader(signature).acceptType(visitor);
        Optional<String> declaredType = visitor.declaredType();
        if (declaredType.isPresent() && this.genericTypesOfClass.contains(declaredType.get())) {
            this.genericFields.put(name, declaredType.get());
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new AssignMutableTypeToFieldChecker(this.ownerClass, access, name, desc, signature, exceptions, this.verifierFactory);
    }

    class AssignMutableTypeToFieldChecker
    extends FieldAssignmentVisitor {
        public AssignMutableTypeToFieldChecker(String owner, int access, String name, String desc, String signature, String[] exceptions, AsmVerifierFactory verifierFactory) {
            super(owner, access, name, desc, signature, exceptions, verifierFactory);
        }

        @Override
        protected void visitFieldAssignmentFrame(Frame<BasicValue> assignmentFrame, FieldInsnNode fieldInsnNode, BasicValue stackValue) {
            if (this.isInvalidStackValue(stackValue)) {
                return;
            }
            this.checkIfClassIsMutable(fieldInsnNode, stackValue.getType());
        }

        private void checkIfClassIsMutable(FieldInsnNode fieldInsnNode, Type typeAssignedToField) {
            int sort = typeAssignedToField.getSort();
            String fieldName = fieldInsnNode.name;
            CodeLocation.FieldLocation fieldLocation = CodeLocation.FieldLocation.fieldLocation(fieldName, CodeLocation.ClassLocation.fromInternalName(MutableTypeToFieldChecker.this.ownerClass));
            switch (sort) {
                case 10: {
                    Dotted assignedToField = Dotted.dotted(typeAssignedToField.getInternalName());
                    if (this.isAssigningToGenericField(fieldName)) {
                        this.setAssigningToGenericFieldResult(fieldName, fieldLocation);
                        break;
                    }
                    MutableTypeInformation.MutabilityLookup mutabilityLookup = MutableTypeToFieldChecker.this.mutableTypeInfo.resultOf(Dotted.dotted(MutableTypeToFieldChecker.this.ownerClass), assignedToField, MutableTypeToFieldChecker.this.analysisInProgress);
                    if (mutabilityLookup.foundCyclicReference) {
                        this.setCyclicReferenceResult(fieldLocation, mutabilityLookup.cyclicReference);
                        break;
                    }
                    if (this.isImmutableContainerType(assignedToField)) break;
                    if (!this.isConcreteType(assignedToField)) {
                        String fieldSignature = (String)MutableTypeToFieldChecker.this.typeSignatureByFieldName.get(fieldName);
                        CollectionTypeWrappedInUnmodifiableIdiomChecker.UnmodifiableWrapResult unmodifiableWrapResult = new CollectionTypeWrappedInUnmodifiableIdiomChecker(fieldInsnNode, typeAssignedToField, MutableTypeToFieldChecker.this.mutableTypeInfo.hardcodedCopyMethods(), fieldSignature).checkWrappedInUnmodifiable();
                        if (!unmodifiableWrapResult.canBeWrapped()) {
                            this.setAbstractFieldAssignmentResult(fieldLocation, assignedToField);
                            break;
                        }
                        if (unmodifiableWrapResult.invokesWhitelistedWrapperMethod()) {
                            if (unmodifiableWrapResult.safelyCopiesBeforeWrapping()) break;
                            this.setWrappingWithoutFirstCopyingResult(fieldLocation, unmodifiableWrapResult.getWrappingHint(fieldLocation.fieldName()));
                            break;
                        }
                        this.setUnsafeWrappingResult(fieldLocation, unmodifiableWrapResult.getWrappingHint(fieldLocation.fieldName()));
                        break;
                    }
                    if (mutabilityLookup.result.isImmutable.equals((Object)IsImmutable.IMMUTABLE)) break;
                    this.setMutableFieldAssignmentResult(fieldLocation, assignedToField);
                    break;
                }
                case 9: {
                    MutableTypeToFieldChecker.this.setResult("Field can have a mutable type (an array) assigned to it.", fieldLocation, MutabilityReason.MUTABLE_TYPE_TO_FIELD);
                    break;
                }
            }
        }

        private boolean isImmutableContainerType(Dotted assignedToField) {
            return MutableTypeToFieldChecker.this.immutableContainerClasses.contains(assignedToField);
        }

        private void setAssigningToGenericFieldResult(String fieldName, CodeLocation.FieldLocation fieldLocation) {
            MutableTypeToFieldChecker.this.setResult(String.format("Field can have a generic type (%s) assigned to it.", this.genericTypeOf(fieldName)), fieldLocation, MutabilityReason.MUTABLE_TYPE_TO_FIELD);
        }

        private String genericTypeOf(String fieldName) {
            return (String)MutableTypeToFieldChecker.this.genericFields.get(fieldName);
        }

        private boolean isAssigningToGenericField(String fieldName) {
            return MutableTypeToFieldChecker.this.genericFields.containsKey(fieldName);
        }

        private boolean isConcreteType(Dotted className) {
            return !MutableTypeToFieldChecker.this.typeStructureInformation.isTypeAbstract(className) && !MutableTypeToFieldChecker.this.typeStructureInformation.isTypeInterface(className);
        }

        private void setUnsafeWrappingResult(CodeLocation.FieldLocation fieldLocation, String wrappingHintMessage) {
            String message = String.format("Field is not a wrapped collection type.%s", wrappingHintMessage);
            MutableTypeToFieldChecker.this.setResult(message, fieldLocation, MutabilityReason.ABSTRACT_COLLECTION_TYPE_TO_FIELD);
        }

        private void setWrappingWithoutFirstCopyingResult(CodeLocation.FieldLocation fieldLocation, String wrappingHintMessage) {
            String message = String.format("Attempts to wrap mutable collection type without safely performing a copy first.%s", wrappingHintMessage);
            MutableTypeToFieldChecker.this.setResult(message, fieldLocation, MutabilityReason.ABSTRACT_COLLECTION_TYPE_TO_FIELD);
        }

        private void setAbstractFieldAssignmentResult(CodeLocation.FieldLocation fieldLocation, Dotted assignedToField) {
            MutableTypeToFieldChecker.this.setResult(String.format("Field can have an abstract type (%s) assigned to it.", assignedToField), fieldLocation, MutabilityReason.ABSTRACT_TYPE_TO_FIELD);
        }

        private void setMutableFieldAssignmentResult(CodeLocation.FieldLocation fieldLocation, Dotted assignedToField) {
            MutableTypeToFieldChecker.this.setResult("Field can have a mutable type (" + assignedToField + ") " + "assigned to it.", fieldLocation, MutabilityReason.MUTABLE_TYPE_TO_FIELD);
        }

        private void setCyclicReferenceResult(CodeLocation.FieldLocation fieldLocation, CyclicReferences.CyclicReference cyclicReference) {
            MutableTypeToFieldChecker.this.setResult("There is a field assigned which creates a cyclic reference. (" + Joiner.on(" -> ").join(cyclicReference.references) + ")", fieldLocation, MutabilityReason.MUTABLE_TYPE_TO_FIELD);
        }
    }

    static final class GenericFieldVisitor
    extends SignatureVisitor {
        private String declaredType;
        private boolean fieldIsOfGenericType = true;

        public GenericFieldVisitor() {
            super(327680);
        }

        @Override
        public void visitTypeVariable(String name) {
            this.declaredType = name;
        }

        @Override
        public void visitClassType(String name) {
            this.fieldIsOfGenericType = false;
        }

        public Optional<String> declaredType() {
            return this.fieldIsOfGenericType ? Optional.of(this.declaredType) : Optional.absent();
        }
    }
}

