/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.info;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.locations.Slashed;

@Immutable
public final class MethodIdentifier {
    @Nonnull
    private final Dotted dottedClassName;
    @Nonnull
    private final String methodDescriptor;

    public MethodIdentifier(Dotted className, String methodDescriptor) {
        this.dottedClassName = className;
        this.methodDescriptor = methodDescriptor;
    }

    public String toString() {
        return this.dottedClassName + "." + this.methodDescriptor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dottedClassName.hashCode();
        result = 31 * result + this.methodDescriptor.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodIdentifier other = (MethodIdentifier)obj;
        return this.dottedClassName.equals(other.dottedClassName) && this.methodDescriptor.equals(other.methodDescriptor);
    }

    public static MethodIdentifier forMethod(Dotted className, String methodDescriptor) {
        return new MethodIdentifier(className, methodDescriptor);
    }

    public static MethodIdentifier forMethod(Slashed className, String methodDescriptor) {
        Dotted dotted = Dotted.fromSlashed(className);
        return new MethodIdentifier(dotted, methodDescriptor);
    }

    public Dotted dottedClassName() {
        return this.dottedClassName;
    }

    public String methodDescriptor() {
        return this.methodDescriptor;
    }
}

