/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.internal.com.google.classpath;

import java.util.SortedSet;
import java.util.TreeSet;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.com.google.classpath.ResourceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFinder {
    private final ClassPath classPath;

    public ResourceFinder(ClassPath classPath) {
        this.classPath = classPath;
    }

    public String[] findResources(String rootPackageName, ResourceFilter resourceFilter) {
        TreeSet<String> resources = new TreeSet<String>();
        this.findResources(resources, rootPackageName, resourceFilter, new TreeSet<String>());
        return resources.toArray(new String[resources.size()]);
    }

    private void findResources(SortedSet<String> resources, String rootPackageName, ResourceFilter resourceFilter, TreeSet<String> visitedPackages) {
        if (rootPackageName.startsWith("/")) {
            rootPackageName = rootPackageName.substring(1);
        }
        if (visitedPackages.contains(rootPackageName)) {
            return;
        }
        visitedPackages.add(rootPackageName);
        for (String packageName : this.classPath.listPackages(rootPackageName)) {
            this.findResources(resources, rootPackageName + "/" + packageName, resourceFilter, visitedPackages);
        }
        for (String resourceName : this.classPath.listResources(rootPackageName)) {
            if (!resourceFilter.match(rootPackageName, resourceName)) continue;
            String name = rootPackageName + "/" + resourceName;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            resources.add(name);
        }
    }
}

