/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.asm.tree.analysis;

import java.util.List;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchy;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchyReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

public class NonClassloadingSimpleVerifier
extends SimpleVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List<Type> currentClassInterfaces;
    private final boolean isInterface;
    protected final TypeHierarchyReader typeHierarchyReader;

    public NonClassloadingSimpleVerifier() {
        this(new TypeHierarchyReader());
    }

    public NonClassloadingSimpleVerifier(Type currentClass, Type currentSuperClass, boolean isInterface) {
        this(currentClass, currentSuperClass, null, isInterface, new TypeHierarchyReader());
    }

    public NonClassloadingSimpleVerifier(TypeHierarchyReader reader) {
        this(null, null, null, false, reader);
    }

    public NonClassloadingSimpleVerifier(Type currentClass, Type currentSuperClass, List<Type> currentClassInterfaces, boolean isInterface, TypeHierarchyReader reader) {
        super(458752, currentClass, currentSuperClass, currentClassInterfaces, isInterface);
        this.currentClass = currentClass;
        this.currentSuperClass = currentSuperClass;
        this.currentClassInterfaces = currentClassInterfaces;
        this.isInterface = isInterface;
        this.typeHierarchyReader = reader;
    }

    protected Class<?> getClass(Type t) {
        throw new Error("Programming error: this verifier should not be attempting to load classes.");
    }

    protected boolean isInterface(Type t) {
        if (this.currentClass != null && t.equals((Object)this.currentClass)) {
            return this.isInterface;
        }
        return this.typeHierarchyReader.isInterface(t);
    }

    protected Type getSuperClass(Type t) {
        if (this.currentClass != null && t.equals((Object)this.currentClass)) {
            return this.currentSuperClass;
        }
        return this.typeHierarchyReader.getSuperClass(t);
    }

    public boolean isAssignableFrom(Type toType, Type fromType) {
        if (toType.equals((Object)fromType)) {
            return true;
        }
        if (this.currentClass != null && toType.equals((Object)this.currentClass)) {
            if (this.getSuperClass(fromType) == null) {
                return false;
            }
            if (this.isInterface) {
                return fromType.getSort() == 10 || fromType.getSort() == 9;
            }
            return this.isAssignableFrom(toType, this.getSuperClass(fromType));
        }
        if (this.currentClass != null && fromType.equals((Object)this.currentClass)) {
            if (this.isAssignableFrom(toType, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (Type currentClassInterface : this.currentClassInterfaces) {
                    if (!this.isAssignableFrom(toType, currentClassInterface)) continue;
                    return true;
                }
            }
            return false;
        }
        TypeHierarchy tc = this.typeHierarchyReader.hierarchyOf(toType);
        return tc.isAssignableFrom(fromType, this.typeHierarchyReader);
    }

    protected boolean isSubTypeOf(BasicValue value, BasicValue expected) {
        Type expectedType = expected.getType();
        Type type = value.getType();
        switch (expectedType.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type.equals((Object)expectedType);
            }
            case 9: 
            case 10: {
                if (type.equals((Object)NULL_TYPE)) {
                    return true;
                }
                if (type.getSort() == 10 || type.getSort() == 9) {
                    if (this.isAssignableFrom(expectedType, type)) {
                        return true;
                    }
                    if (this.isInterface(expectedType)) {
                        return this.isAssignableFrom(TypeHierarchy.JAVA_LANG_OBJECT.type(), type);
                    }
                    return false;
                }
                return false;
            }
        }
        throw new AssertionError();
    }
}

