/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.asm.typehierarchy;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchy;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchyReader;
import org.objectweb.asm.Type;

public class ConcurrentMapCachingTypeHierarchyReader
extends TypeHierarchyReader {
    private final TypeHierarchyReader baseReader;
    private final ConcurrentMap<Type, TypeHierarchy> typeHierarchyCache;

    public ConcurrentMapCachingTypeHierarchyReader(TypeHierarchyReader baseReader, ConcurrentMap<Type, TypeHierarchy> initiallyEmptyCache) {
        this.baseReader = baseReader;
        this.typeHierarchyCache = initiallyEmptyCache;
    }

    public ConcurrentMapCachingTypeHierarchyReader(TypeHierarchyReader baseReader) {
        this(baseReader, new ConcurrentHashMap<Type, TypeHierarchy>());
    }

    @Override
    public TypeHierarchy hierarchyOf(Type t) {
        if (!this.typeHierarchyCache.containsKey(t)) {
            this.typeHierarchyCache.put(t, this.baseReader.hierarchyOf(t));
        }
        return (TypeHierarchy)this.typeHierarchyCache.get(t);
    }
}

