/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.asm.typehierarchy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchy;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public class TypeHierarchyReader {
    public boolean isInterface(Type t) {
        return this.hierarchyOf(t).isInterface();
    }

    public Type getSuperClass(Type t) {
        return this.hierarchyOf(t).getSuperClass();
    }

    public boolean isAssignableFrom(Type to, Type from) {
        return this.hierarchyOf(to).isAssignableFrom(this.hierarchyOf(from), this);
    }

    public TypeHierarchy hierarchyOf(Type t) {
        try {
            switch (t.getSort()) {
                case 1: {
                    return TypeHierarchy.BOOLEAN_HIERARCHY;
                }
                case 3: {
                    return TypeHierarchy.BYTE_HIERARCHY;
                }
                case 2: {
                    return TypeHierarchy.CHAR_HIERARCHY;
                }
                case 4: {
                    return TypeHierarchy.SHORT_HIERARCHY;
                }
                case 5: {
                    return TypeHierarchy.INT_HIERARCHY;
                }
                case 7: {
                    return TypeHierarchy.LONG_HIERARCHY;
                }
                case 6: {
                    return TypeHierarchy.FLOAT_HIERARCHY;
                }
                case 8: {
                    return TypeHierarchy.DOUBLE_HIERARCHY;
                }
                case 0: {
                    return TypeHierarchy.VOID_HIERARCHY;
                }
                case 9: {
                    return TypeHierarchy.hierarchyForArrayOfType(t);
                }
                case 10: {
                    return this.obtainHierarchyOf(this.reader(t));
                }
            }
            throw new Error("Programmer error: received a type whose getSort() wasn't matched.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ClassReader reader(Type t) throws IOException {
        return new ClassReader(t.getInternalName());
    }

    protected TypeHierarchy obtainHierarchyOf(ClassReader reader) {
        boolean isInterface = (reader.getAccess() & 0x200) != 0;
        return new TypeHierarchy(Type.getObjectType((String)reader.getClassName()), reader.getSuperName() == null || isInterface ? null : Type.getObjectType((String)reader.getSuperName()), this.interfacesTypesFrom(reader.getInterfaces()), isInterface);
    }

    private List<Type> interfacesTypesFrom(String[] interfaces) {
        Type[] interfaceTypes = new Type[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceTypes[i] = Type.getObjectType((String)interfaces[i]);
        }
        return Arrays.asList(interfaceTypes);
    }
}

