/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.refl;

import java.lang.reflect.Field;
import org.mvel.AccessorNode;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.integration.VariableResolverFactory;

public class DynamicFieldAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;

    public DynamicFieldAccessor() {
    }

    public DynamicFieldAccessor(Field field) {
        this.field = field;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.field.get(ctx), elCtx, vars);
            }
            return this.field.get(ctx);
        }
        catch (Exception e) {
            throw new CompileException("unable to access field", e);
        }
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            this.field.set(ctx, DataConversion.convert(value, this.field.getType()));
        }
        catch (Exception e) {
            throw new CompileException("unable to access field", e);
        }
        return value;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }
}

