/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.main;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.DataConversion;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.MVELRuntime;
import org.mvel.Macro;
import org.mvel.ParserContext;
import org.mvel.PropertyAccessor;
import org.mvel.ast.WithNode;
import org.mvel.debug.DebugTools;
import org.mvel.debug.Debugger;
import org.mvel.debug.Frame;
import org.mvel.integration.Interceptor;
import org.mvel.integration.ResolverTools;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.integration.impl.StaticMethodImportResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.tests.main.AbstractTest;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Cheese;
import org.mvel.tests.main.res.DefaultKnowledgeHelper;
import org.mvel.tests.main.res.Foo;
import org.mvel.tests.main.res.PojoStatic;
import org.mvel.tests.main.res.RuleBaseImpl;
import org.mvel.tests.main.res.WorkingMemoryImpl;
import org.mvel.util.MethodStub;

public class CoreConfidenceTests
extends AbstractTest {
    private Map<Object, Object> outerMap;
    private Map<Object, Object> innerMap;
    private HashMap<String, Object> context = new HashMap();

    public void testSingleProperty() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("fun"));
    }

    public void testMethodOnValue() {
        CoreConfidenceTests.assertEquals((Object)"DOG", (Object)this.test("foo.bar.name.toUpperCase()"));
    }

    public void testSimpleProperty() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.test("foo.bar.name"));
    }

    public void testSimpleProperty2() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.test("DATA"));
    }

    public void testPropertyViaDerivedClass() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.test("derived.data"));
    }

    public void testDeepAssignment() {
        CoreConfidenceTests.assertEquals((Object)"crap", (Object)this.test("foo.bar.assignTest = 'crap'"));
    }

    public void testThroughInterface() {
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)this.test("testImpl.name"));
    }

    public void testThroughInterface2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("testImpl.foo"));
    }

    public void testMapAccessWithMethodCall() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.test("funMap['foo'].happy()"));
    }

    public void testSimpleIfStatement() {
        this.test("if (true) { System.out.println(\"test!\") }  \n");
    }

    public void testBooleanOperator() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.woof == true"));
    }

    public void testBooleanOperator2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("foo.bar.woof == false"));
    }

    public void testBooleanOperator3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.woof== true"));
    }

    public void testBooleanOperator4() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("foo.bar.woof ==false"));
    }

    public void testBooleanOperator5() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.woof == true"));
    }

    public void testBooleanOperator6() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("foo.bar.woof==false"));
    }

    public void testTextComparison() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.name == 'dog'"));
    }

    public void testNETextComparison() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.name != 'foo'"));
    }

    public void testChor() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.test("a or b or c"));
    }

    public void testChorWithLiteral() {
        CoreConfidenceTests.assertEquals((Object)"fubar", (Object)this.test("a or 'fubar'"));
    }

    public void testNullCompare() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("c != null"));
    }

    public void testUninitializedInt() {
        CoreConfidenceTests.assertEquals((Object)new Integer(0), (Object)this.test("sarahl"));
    }

    public void testAnd() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("c != null && foo.bar.name == 'dog' && foo.bar.woof"));
    }

    public void testAnd2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("c!=null&&foo.bar.name=='dog'&&foo.bar.woof"));
    }

    public void testMath() {
        CoreConfidenceTests.assertEquals((Object)new Float(188.4f), (Object)this.test("pi * hour"));
    }

    public void testMath2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(3), (Object)this.test("foo.number-1"));
    }

    public void testMath3() {
        CoreConfidenceTests.assertEquals((Object)new Double(33.333333333333336), (Object)this.test("(10 * 5) * 2 / 3"));
    }

    public void testMath4() {
        int val = 19;
        System.out.println("val=" + val);
        CoreConfidenceTests.assertEquals((Object)new Integer(val), (Object)this.test("(100 % 3) * 2 - 1 / 1 + 8 + (5 * 2)"));
    }

    public void testMath5() {
        CoreConfidenceTests.assertEquals((Object)new Double(17.999401018268944), (Object)this.test("300.5 / 5.3 / 2.1 / 1.5"));
    }

    public void testMath6() {
        CoreConfidenceTests.assertEquals((Object)new Integer(1601), (Object)this.test("(300 * five + 1) + (100 / 2 * 2)"));
    }

    public void testMath7() {
        CoreConfidenceTests.assertEquals((Object)new Integer(19), (Object)this.test("(100 % 3) * 2 - 1 / 1 + 8 + (5 * 2)"));
    }

    public void testMath8() {
        CoreConfidenceTests.assertEquals((Object)new Float(15134.279f), (Object)this.test("5 * (100.56 * 30.1)"));
    }

    public void testMath9() {
        CoreConfidenceTests.assertEquals((Object)new Integer(25), (Object)this.test("(five * 5) + 1 - 1"));
    }

    public void testMath10() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Float");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals((Object)new Float(2.375f), DataConversion.convert(this.test("five * (0.95 / 2)"), clazz));
    }

    public void testPowerOf() {
        CoreConfidenceTests.assertEquals((Object)new Integer(25), (Object)this.test("5 ** 2"));
    }

    public void testWhileUsingImports() {
        Class<?> clazz;
        Class<?> clazz2;
        HashMap<String, Object> imports = new HashMap<String, Object>();
        try {
            clazz2 = Class.forName("java.util.ArrayList");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        imports.put("ArrayList", clazz2);
        try {
            clazz = Class.forName("java.util.List");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        imports.put("List", clazz);
        ParserContext context = new ParserContext(imports, null, "testfile");
        ExpressionCompiler compiler = new ExpressionCompiler("List list = new ArrayList(); return (list == empty)");
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.executeExpression((Object)compiler.compile(context), new DefaultLocalVariableResolverFactory())));
    }

    public void testComplexExpression() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("a = 'foo'; b = 'bar'; c = 'jim'; list = {a,b,c}; list[1]"));
    }

    public void testComplexAnd() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("(pi * hour) > 0 && foo.happy() == 'happyBar'"));
    }

    public void testShortPathExpression() {
        CoreConfidenceTests.assertEquals(null, (Object)this.test("3 > 4 && foo.toUC('test'); foo.register"));
    }

    public void testShortPathExpression2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("4 > 3 || foo.toUC('test')"));
    }

    public void testShortPathExpression4() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("4>3||foo.toUC('test')"));
    }

    public void testOrOperator() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("true||true"));
    }

    public void testOrOperator2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("2 > 3 || 3 > 2"));
    }

    public void testOrOperator3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("pi > 5 || pi > 6 || pi > 3"));
    }

    public void testShortPathExpression3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("defnull != null  && defnull.length() > 0"));
    }

    public void testModulus() {
        CoreConfidenceTests.assertEquals((Object)new Integer(0), (Object)this.test("38392 % 2"));
    }

    public void testLessThan() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("pi < 3.15"));
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("pi <= 3.14"));
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("pi > 3.14"));
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("pi >= 3.14"));
    }

    public void testMethodAccess() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.test("foo.happy()"));
    }

    public void testMethodAccess2() {
        CoreConfidenceTests.assertEquals((Object)"FUBAR", (Object)this.test("foo.toUC( 'fubar' )"));
    }

    public void testMethodAccess3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("equalityCheck(c, 'cat')"));
    }

    public void testMethodAccess4() {
        CoreConfidenceTests.assertEquals(null, (Object)this.test("readBack(null)"));
    }

    public void testMethodAccess5() {
        CoreConfidenceTests.assertEquals((Object)"nulltest", (Object)this.test("appendTwoStrings(null, 'test')"));
    }

    public void testMethodAccess6() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("   equalityCheck(   c  \n  ,   \n   'cat'      )   "));
    }

    public void testNegation() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("!fun && !fun"));
    }

    public void testNegation2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("fun && !fun"));
    }

    public void testNegation3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("!(fun && fun)"));
    }

    public void testNegation4() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("(fun && fun)"));
    }

    public void testMultiStatement() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("populate(); barfoo == 'sarah'"));
    }

    public void testAssignment() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("populate(); blahfoo = 'sarah'; blahfoo == 'sarah'"));
    }

    public void testAssignment2() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.test("populate(); blahfoo = barfoo"));
    }

    public void testAssignment3() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, this.test("blah = 5").getClass());
    }

    public void testAssignment4() {
        CoreConfidenceTests.assertEquals((Object)new Integer(102), (Object)this.test("a = 100 + 1 + 1"));
    }

    public void testOr() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("fun || true"));
    }

    public void testLiteralPassThrough() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("true"));
    }

    public void testLiteralPassThrough2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("false"));
    }

    public void testLiteralPassThrough3() {
        CoreConfidenceTests.assertEquals(null, (Object)this.test("null"));
    }

    public void testRegEx() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.name ~= '[a-z].+'"));
    }

    public void testRegExNegate() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("!(foo.bar.name ~= '[a-z].+')"));
    }

    public void testRegEx2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.name ~= '[a-z].+' && foo.bar.name != null"));
    }

    public void testRegEx3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.bar.name~='[a-z].+'&&foo.bar.name!=null"));
    }

    public void testBlank() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("'' == empty"));
    }

    public void testBlank2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("BWAH == empty"));
    }

    public void testBooleanModeOnly2() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), MVEL.eval("BWAH", (Object)new Base(), CoreConfidenceTests.createTestMap(), clazz));
    }

    public void testBooleanModeOnly4() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), MVEL.eval("hour == (hour + 0)", (Object)new Base(), CoreConfidenceTests.createTestMap(), clazz));
    }

    public void testTernary() {
        CoreConfidenceTests.assertEquals((Object)"foobie", (Object)this.test("zero==0?'foobie':zero"));
    }

    public void testTernary2() {
        CoreConfidenceTests.assertEquals((Object)"blimpie", (Object)this.test("zero==1?'foobie':'blimpie'"));
    }

    public void testTernary3() {
        CoreConfidenceTests.assertEquals((Object)"foobiebarbie", (Object)this.test("zero==1?'foobie':'foobie'+'barbie'"));
    }

    public void testStrAppend() {
        CoreConfidenceTests.assertEquals((Object)"foobarcar", (Object)this.test("'foo' + 'bar' + 'car'"));
    }

    public void testStrAppend2() {
        CoreConfidenceTests.assertEquals((Object)"foobarcar1", (Object)this.test("'foobar' + 'car' + 1"));
    }

    public void testInstanceCheck1() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("c is java.lang.String"));
    }

    public void testInstanceCheck2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("pi is java.lang.Integer"));
    }

    public void testInstanceCheck3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo is org.mvel.tests.main.res.Foo"));
    }

    public void testBitwiseOr1() {
        CoreConfidenceTests.assertEquals((Object)new Integer(6), (Object)this.test("2|4"));
    }

    public void testBitwiseOr2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("(2 | 1) > 0"));
    }

    public void testBitwiseOr3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("(2|1) == 3"));
    }

    public void testBitwiseAnd1() {
        CoreConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.test("2 & 3"));
    }

    public void testShiftLeft() {
        CoreConfidenceTests.assertEquals((Object)new Integer(4), (Object)this.test("2 << 1"));
    }

    public void testUnsignedShiftLeft() {
        CoreConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.test("-2 <<< 0"));
    }

    public void testShiftRight() {
        CoreConfidenceTests.assertEquals((Object)new Integer(128), (Object)this.test("256 >> 1"));
    }

    public void testXOR() {
        CoreConfidenceTests.assertEquals((Object)new Integer(3), (Object)this.test("1 ^ 2"));
    }

    public void testContains1() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("list contains 'Happy!'"));
    }

    public void testContains2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("list contains 'Foobie'"));
    }

    public void testContains3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("sentence contains 'fox'"));
    }

    public void testContains4() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("sentence contains 'mike'"));
    }

    public void testContains5() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("!(sentence contains 'mike')"));
    }

    public void testContains6() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("bwahbwah = 'mikebrock'; testVar10 = 'mike'; bwahbwah contains testVar10"));
    }

    public void testInvert() {
        CoreConfidenceTests.assertEquals((Object)new Integer(-11), (Object)this.test("~10"));
    }

    public void testInvert2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(-12), (Object)this.test("~(10 + 1)"));
    }

    public void testInvert3() {
        CoreConfidenceTests.assertEquals((Object)new Integer(-61), (Object)this.test("~10 + (1 + ~50)"));
    }

    public void testListCreation2() {
        CoreConfidenceTests.assertTrue((boolean)(this.test("[\"test\"]") instanceof List));
    }

    public void testListCreation3() {
        CoreConfidenceTests.assertTrue((boolean)(this.test("[66]") instanceof List));
    }

    public void testListCreation4() {
        List ar = (List)this.test("[   66   , \"test\"   ]");
        CoreConfidenceTests.assertEquals((int)2, (int)ar.size());
        CoreConfidenceTests.assertEquals((Object)new Integer(66), ar.get(0));
        CoreConfidenceTests.assertEquals((Object)"test", ar.get(1));
    }

    public void testListCreationWithCall() {
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)this.test("[\"apple\"].size()"));
    }

    public void testArrayCreationWithLength() {
        CoreConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.test("Array.getLength({'foo', 'bar'})"));
    }

    public void testEmptyList() {
        CoreConfidenceTests.assertTrue((boolean)(this.test("[]") instanceof List));
    }

    public void testEmptyArray() {
        CoreConfidenceTests.assertTrue((((Object[])this.test("{}")).length == 0 ? 1 : 0) != 0);
    }

    public void testEmptyArray2() {
        CoreConfidenceTests.assertTrue((((Object[])this.test("{    }")).length == 0 ? 1 : 0) != 0);
    }

    public void testArrayCreation() {
        CoreConfidenceTests.assertEquals((Object)new Integer(0), (Object)this.test("arrayTest = {{1, 2, 3}, {2, 1, 0}}; arrayTest[1][2]"));
    }

    public void testMapCreation() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.test("map = ['mike':'sarah','tom':'jacquelin']; map['mike']"));
    }

    public void testMapCreation2() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.test("map = ['mike' :'sarah'  ,'tom'  :'jacquelin'  ]; map['mike']"));
    }

    public void testMapCreation3() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("map = [1 : 'foo']; map[1]"));
    }

    public void testProjectionSupport() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("(name in things)contains'Bob'"));
    }

    public void testProjectionSupport1() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("(name in things) contains 'Bob'"));
    }

    public void testProjectionSupport2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(3), (Object)this.test("(name in things).size()"));
    }

    public void testSizeOnInlineArray() {
        CoreConfidenceTests.assertEquals((Object)new Integer(3), (Object)this.test("{1,2,3}.size()"));
    }

    public void testSimpleListCreation() {
        this.test("['foo', 'bar', 'foobar', 'FOOBAR']");
    }

    public void testStaticMethodFromLiteral() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals((Object)clazz.getName(), (Object)this.test("String.valueOf(Class.forName('java.lang.String').getName())"));
    }

    public void testObjectInstantiation() {
        this.test("new java.lang.String('foobie')");
    }

    public void testObjectInstantiationWithMethodCall() {
        CoreConfidenceTests.assertEquals((Object)"FOOBIE", (Object)this.test("new String('foobie')  . toUpperCase()"));
    }

    public void testObjectInstantiation2() {
        this.test("new String() is String");
    }

    public void testObjectInstantiation3() {
        this.test("new java.text.SimpleDateFormat('yyyy').format(new java.util.Date(System.currentTimeMillis()))");
    }

    public void testArrayCoercion() {
        CoreConfidenceTests.assertEquals((Object)"gonk", (Object)this.test("funMethod( {'gonk', 'foo'} )"));
    }

    public void testArrayCoercion2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("sum({2,2,2,2,2})"));
    }

    public void testMapAccess() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.test("funMap['foo'].bar.name"));
    }

    public void testMapAccess2() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.test("funMap.foo.bar.name"));
    }

    public void testSoundex() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("'foobar' soundslike 'fubar'")));
    }

    public void testSoundex2() {
        CoreConfidenceTests.assertFalse((boolean)((Boolean)this.test("'flexbar' soundslike 'fubar'")));
    }

    public void testThisReference() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)(this.test("this") instanceof Base));
    }

    public void testThisReference2() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)(this.test("this.funMap") instanceof Map));
    }

    public void testThisReference3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("this is org.mvel.tests.main.res.Base"));
    }

    public void testThisReference4() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("this.funMap instanceof java.util.Map"));
    }

    public void testThisReference5() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("this.data == 'cat'"));
    }

    public void testThisReferenceInMethodCall() {
        CoreConfidenceTests.assertEquals((Object)new Integer(101), (Object)this.test("Integer.parseInt(this.number)"));
    }

    public void testThisReferenceInConstructor() {
        CoreConfidenceTests.assertEquals((Object)"101", (Object)this.test("new String(this.number)"));
    }

    public void testThisReferenceMapVirtualObjects() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        factory.createVariable("this", map);
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)MVEL.eval("this.foo == 'bar'", map, (VariableResolverFactory)factory));
    }

    public void testThisReferenceMapVirtualObjects1() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        factory.createVariable("this", map);
        Serializable compiled = MVEL.compileExpression("this.foo == 'bar'");
        OptimizerFactory.setDefaultOptimizer("reflective");
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)MVEL.executeExpression((Object)compiled, map, factory));
    }

    public void testThisReferenceMapVirtualObjects2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        factory.createVariable("this", map);
        Serializable compiled = MVEL.compileExpression("this.foo == 'bar'");
        if (!Boolean.getBoolean("mvel.disable.jit")) {
            OptimizerFactory.setDefaultOptimizer("ASM");
        }
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)MVEL.executeExpression((Object)compiled, map, factory));
    }

    public void testStringEscaping() {
        CoreConfidenceTests.assertEquals((Object)"\"Mike Brock\"", (Object)this.test("\"\\\"Mike Brock\\\"\""));
    }

    public void testStringEscaping2() {
        CoreConfidenceTests.assertEquals((Object)"MVEL's Parser is Fast", (Object)this.test("'MVEL\\'s Parser is Fast'"));
    }

    public void testEvalToBoolean() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean("true ", "true"));
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean("true ", "true"));
    }

    public void testCompiledMapStructures() {
        Class<?> clazz;
        Serializable compiled = MVEL.compileExpression("['foo':'bar'] contains 'foo'");
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        MVEL.executeExpression(compiled, null, null, clazz);
    }

    public void testSubListInMap() {
        CoreConfidenceTests.assertEquals((Object)"pear", (Object)this.test("map = ['test' : 'poo', 'foo' : [c, 'pear']]; map['foo'][1]"));
    }

    public void testCompiledMethodCall() {
        Class<?> clazz;
        Serializable compiled = MVEL.compileExpression("c.getClass()");
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)MVEL.executeExpression((Object)compiled, (Object)new Base(), CoreConfidenceTests.createTestMap()));
    }

    public void testStaticNamespaceCall() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.util.ArrayList");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)this.test("java.util.ArrayList"));
    }

    public void testStaticNamespaceClassWithMethod() {
        CoreConfidenceTests.assertEquals((Object)"FooBar", (Object)this.test("java.lang.String.valueOf('FooBar')"));
    }

    public void testConstructor() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("a = 'foobar'; new String(a.toCharArray(), 0, 3)"));
    }

    public void testStaticNamespaceClassWithField() {
        CoreConfidenceTests.assertEquals((Object)new Integer(Integer.MAX_VALUE), (Object)this.test("java.lang.Integer.MAX_VALUE"));
    }

    public void testStaticNamespaceClassWithField2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(Integer.MAX_VALUE), (Object)this.test("Integer.MAX_VALUE"));
    }

    public void testStaticFieldAsMethodParm() {
        CoreConfidenceTests.assertEquals((Object)String.valueOf(Integer.MAX_VALUE), (Object)this.test("String.valueOf(Integer.MAX_VALUE)"));
    }

    public void testEmptyIf() {
        CoreConfidenceTests.assertEquals((Object)new Integer(5), (Object)this.test("a = 5; if (a == 5) { }; return a;"));
    }

    public void testEmptyIf2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(5), (Object)this.test("a=5;if(a==5){};return a;"));
    }

    public void testIf() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("if (5 > 4) { return 10; } else { return 5; }"));
    }

    public void testIf2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("if (5 < 4) { return 5; } else { return 10; }"));
    }

    public void testIf3() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("if(5<4){return 5;}else{return 10;}"));
    }

    public void testIfAndElse() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("if (false) { return false; } else { return true; }"));
    }

    public void testIfAndElseif() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("if (false) { return false; } else if(100 < 50) { return false; } else if (10 > 5) return true;"));
    }

    public void testIfAndElseIfCondensedGrammar() {
        CoreConfidenceTests.assertEquals((Object)"Foo", (Object)this.test("if (false) return 'Bar'; else return 'Foo';"));
    }

    public void testForEach2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(6), (Object)this.test("total = 0; a = {1,2,3}; foreach(item : a) { total += item }; total"));
    }

    public void testForEach3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("a = {1,2,3}; foreach (i : a) { if (i == 1) { return true; } }"));
    }

    public void testForEach4() {
        CoreConfidenceTests.assertEquals((Object)"OneTwoThreeFour", (Object)this.test("a = {1,2,3,4}; builder = ''; foreach (i : a) { if (i == 1) { builder += 'One' } else if (i == 2) { builder += 'Two' } else if (i == 3) { builder += 'Three' } else { builder += 'Four' }}; builder;"));
    }

    public void testWith() {
        CoreConfidenceTests.assertEquals((Object)"OneTwo", (Object)this.test("with (foo) {aValue = 'One',bValue='Two'}; foo.aValue + foo.bValue;"));
    }

    public void testWith2() {
        CoreConfidenceTests.assertEquals((Object)"OneTwo", (Object)this.test("with (foo) { \naValue = 'One', // this is a comment \nbValue='Two'  // this is also a comment \n}; \nfoo.aValue + foo.bValue;"));
    }

    public void testMagicArraySize() {
        CoreConfidenceTests.assertEquals((Object)new Integer(5), (Object)this.test("stringArray.size()"));
    }

    public void testMagicArraySize2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(5), (Object)this.test("intArray.size()"));
    }

    public void testStaticVarAssignment() {
        CoreConfidenceTests.assertEquals((Object)"1", (Object)this.test("String mikeBrock = 1; mikeBrock"));
    }

    public void testImport() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.util.HashMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)this.test("import java.util.HashMap; HashMap;"));
    }

    public void testStaticImport() {
        CoreConfidenceTests.assertEquals((Object)new Double(2.0), (Object)this.test("import_static java.lang.Math.sqrt; sqrt(4)"));
    }

    public void testFunctionPointer() {
        CoreConfidenceTests.assertEquals((Object)new Double(2.0), (Object)this.test("squareRoot = java.lang.Math.sqrt; squareRoot(4)"));
    }

    public void testFunctionPointerAsParam() {
        CoreConfidenceTests.assertEquals((Object)"2.0", (Object)this.test("squareRoot = Math.sqrt; new String(String.valueOf(squareRoot(4)));"));
    }

    public void testFunctionPointerInAssignment() {
        CoreConfidenceTests.assertEquals((Object)new Double(5.0), (Object)this.test("squareRoot = Math.sqrt; i = squareRoot(25); return i;"));
    }

    public void testIncrementOperator() {
        CoreConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.test("x = 1; x++; x"));
    }

    public void testPreIncrementOperator() {
        CoreConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.test("x = 1; ++x"));
    }

    public void testDecrementOperator() {
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)this.test("x = 2; x--; x"));
    }

    public void testPreDecrementOperator() {
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)this.test("x = 2; --x"));
    }

    public void testQualifiedStaticTyping() {
        CoreConfidenceTests.assertEquals((Object)new Integer(20), (Object)this.test("java.math.BigDecimal axx = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal bxx = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal cxx = axx + bxx; return cxx; "));
    }

    public void testUnQualifiedStaticTyping() {
        CoreConfidenceTests.assertEquals((Object)new Integer(20), (Object)CoreConfidenceTests.testCompiledSimple("import java.math.BigDecimal;  BigDecimal axx = new BigDecimal( 10.0 ); BigDecimal bxx = new BigDecimal( 10.0 ); BigDecimal cxx = axx + bxx; return cxx; ", new HashMap()));
    }

    public void testObjectCreation() {
        CoreConfidenceTests.assertEquals((Object)new Integer(6), (Object)this.test("new Integer( 6 )"));
    }

    public void testTernary4() {
        CoreConfidenceTests.assertEquals((Object)"<test>", (Object)this.test("true ? '<test>' : '<poo>'"));
    }

    public void testStringAsCollection() {
        CoreConfidenceTests.assertEquals((Object)new Character('o'), (Object)this.test("abc = 'foo'; abc[1]"));
    }

    public void testSubExpressionIndexer() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("xx = new java.util.HashMap(); xx.put('foo', 'bar'); prop = 'foo'; xx[prop];"));
    }

    public void testCompileTimeLiteralReduction() {
        CoreConfidenceTests.assertEquals((Object)new Integer(1000), (Object)this.test("10 * 100"));
    }

    public void testCreationOfSet() {
        CoreConfidenceTests.assertEquals((Object)"foo bar foo bar", (Object)this.test("set = new java.util.LinkedHashSet(); set.add('foo');set.add('bar');output = '';foreach (item : set) {output = output + item + ' ';} foreach (item : set) {output = output + item + ' ';} output = output.trim();if (set.size() == 2) { return output; }"));
    }

    public void testCreationOfList() {
        CoreConfidenceTests.assertEquals((Object)new Integer(5), (Object)this.test("l = new java.util.LinkedList();l.add('fun');l.add('happy');l.add('fun');l.add('slide');l.add('crap');poo = new java.util.ArrayList(l);poo.size();"));
    }

    public void testMapOperations() {
        CoreConfidenceTests.assertEquals((Object)"poo5", (Object)this.test("l = new java.util.ArrayList();l.add('plop');l.add('poo');m = new java.util.HashMap();m.put('foo', l);m.put('cah', 'mah');m.put('bar', 'foo');m.put('sarah', 'mike');m.put('edgar', 'poe');if (m.edgar == 'poe') {return m.foo[1] + m.size();}"));
    }

    public void testStackOperations() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("stk = new java.util.Stack();stk.push(5);stk.push(5);stk.pop() + stk.pop();"));
    }

    public void testSystemOutPrint() {
        this.test("a = 0;\r\nSystem.out.println('This is a test');");
    }

    public void testBreakpoints() {
        ExpressionCompiler compiler = new ExpressionCompiler("a = 5;\nb = 5;\n\nif (a == b) {\n\nSystem.out.println('Good');\nreturn a + b;\n}\n");
        System.out.println("-------\n" + compiler.getExpression() + "\n-------\n");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test.mv", 7);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(CoreConfidenceTests.createTestMap())));
    }

    public void testBreakpoints2() {
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println('test the debugger');\n a = 0;");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
    }

    public void testBreakpoints3() {
        Class<?> clazz;
        String expr = "System.out.println( \"a1\" );\nSystem.out.println( \"a2\" );\nSystem.out.println( \"a3\" );\nSystem.out.println( \"a4\" );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        try {
            clazz = Class.forName("java.lang.System");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("System", clazz);
        context.setStrictTypeEnforcement(true);
        context.setDebugSymbols(true);
        context.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(context);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println("output: " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testBreakpointsAcrossWith() {
        Class<?> clazz;
        Class<?> clazz2;
        String line1 = "System.out.println( \"a1\" );\n";
        String line2 = "c = new Cheese();\n";
        String line3 = "with ( c ) { type = 'cheddar',\n             price = 10 };\n";
        String line4 = "System.out.println( \"a1\" );\n";
        String expr = String.valueOf(line1) + line2 + line3 + line4;
        System.out.println(expr);
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        try {
            clazz2 = Class.forName("java.lang.System");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("System", clazz2);
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Cheese");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("Cheese", clazz);
        context.setStrictTypeEnforcement(true);
        context.setDebugSymbols(true);
        context.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(context);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println("output: " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)5, (int)count);
    }

    public void testBreakpointsAcrossComments() {
        String expression = "/** This is a comment\n *  Second comment line\n *  Third Comment Line\n */\nSystem.out.println('4');\nSystem.out.println('5');\na = 0;\nb = 1;\na + b";
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        compiler.setDebugSymbols(true);
        System.out.println("Expression:\n------------");
        System.out.println(expression);
        System.out.println("------------");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 9);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint Encountered [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                System.out.println("vars:" + frame.getFactory().getKnownVariables());
                System.out.println("Resume Execution");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(CoreConfidenceTests.createTestMap())));
    }

    public void testBreakpointsAcrossComments2() {
        ExpressionCompiler compiler = new ExpressionCompiler("// This is a comment\n//Second comment line\n//Third Comment Line\n\n//Test\nSystem.out.println('4');\n//System.out.println('5'); \na = 0;\nb = 1;\n a + b");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 6);
        MVELRuntime.registerBreakpoint("test2.mv", 8);
        MVELRuntime.registerBreakpoint("test2.mv", 9);
        MVELRuntime.registerBreakpoint("test2.mv", 10);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(CoreConfidenceTests.createTestMap())));
    }

    public void testBreakpoints4() {
        Class<?> clazz;
        String expression = "System.out.println('foo');\na = new Foo();\nupdate (a) { name = 'bar' };\nSystem.out.println('name:' + a.name);\nreturn a.name;";
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Update", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                System.out.println("fired update interceptor -- before");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("fired update interceptor -- after");
                return 0;
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "@Update with";
            }
        });
        expression = MVEL.parseMacros(expression, macros);
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addImport("Foo", clazz);
        ctx.setInterceptors(interceptors);
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println("\nExpression:------------");
        System.out.println(expression);
        System.out.println("------------");
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 3);
        MVELRuntime.registerBreakpoint("test2.mv", 4);
        MVELRuntime.registerBreakpoint("test2.mv", 5);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(CoreConfidenceTests.createTestMap())));
    }

    public void testBreakpoints5() {
        Class<?> clazz;
        String expression = "System.out.println('foo');\r\na = new Foo();\r\na.name = 'bar'\r\nfoo.happy();\r\nSystem.out.println( 'name:' + a.name );               \r\nSystem.out.println( 'name:' + a.name );         \r\nSystem.out.println( 'name:' + a.name );     \r\nreturn a.name;";
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Update", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                System.out.println("fired update interceptor -- before");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("fired update interceptor -- after");
                return 0;
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "@Update with";
            }
        });
        expression = MVEL.parseMacros(expression, macros);
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addImport("Foo", clazz);
        ctx.setInterceptors(interceptors);
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println("\nExpression:------------");
        System.out.println(expression);
        System.out.println("------------");
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 1);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 1;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        System.out.println("\n==RUN==\n");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(CoreConfidenceTests.createTestMap())));
    }

    public void testDebugSymbolsWithWindowsLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\r\n   System.out.println( \"a2\" );\r\n   System.out.println( \"a3\" );\r\n   System.out.println( \"a4\" );\r\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(ctx);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println(s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testDebugSymbolsWithUnixLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\n   System.out.println( \"a2\" );\n   System.out.println( \"a3\" );\n   System.out.println( \"a4\" );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(ctx);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testDebugSymbolsWithMixedLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\n   System.out.println( \"a2\" );\r\n   System.out.println( \"a3\" );\n   System.out.println( \"a4\" );\r\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(ctx);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println(s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testReflectionCache() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.test("foo.happy(); foo.bar.happy()"));
    }

    public void testVarInputs() {
        Class<?> clazz;
        ExpressionCompiler compiler = new ExpressionCompiler("test != foo && bo.addSomething(trouble); String bleh = foo; twa = bleh;");
        compiler.compile();
        ParserContext pCtx = compiler.getParserContextState();
        CoreConfidenceTests.assertEquals((int)4, (int)pCtx.getInputs().size());
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("test"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("foo"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("bo"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("trouble"));
        CoreConfidenceTests.assertEquals((int)2, (int)pCtx.getVariables().size());
        CoreConfidenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("bleh"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("twa"));
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)pCtx.getVarOrInputType("bleh"));
    }

    public void testVarInputs2() {
        ExpressionCompiler compiler = new ExpressionCompiler("test != foo && bo.addSomething(trouble); String bleh = foo; twa = bleh;");
        ParserContext ctx = new ParserContext();
        ctx.setRetainParserState(true);
        compiler.compile(ctx);
        System.out.println(ctx.getVarOrInputType("bleh"));
    }

    public void testVarInputs3() {
        ExpressionCompiler compiler = new ExpressionCompiler("addresses['home'].street");
        compiler.compile();
        CoreConfidenceTests.assertFalse((boolean)compiler.getParserContextState().getInputs().keySet().contains("home"));
    }

    public void testVarInputs4() {
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println( message );");
        compiler.compile();
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().keySet().contains("message"));
    }

    public void testAnalyzer() {
        ExpressionCompiler compiler = new ExpressionCompiler("order.id == 10");
        compiler.compile();
        Iterator<String> iterator = compiler.getParserContextState().getInputs().keySet().iterator();
        while (iterator.hasNext()) {
            String input = iterator.next();
            System.out.println("input>" + input);
        }
        CoreConfidenceTests.assertEquals((int)1, (int)compiler.getParserContextState().getInputs().size());
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("order"));
    }

    public void testClassImportViaFactory() {
        Class<?> clazz;
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(CoreConfidenceTests.createTestMap());
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        try {
            clazz = Class.forName("java.util.HashMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        classes.addClass(clazz);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("HashMap map = new HashMap()", classes.getImportedClasses());
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)compiled, mvf) instanceof HashMap));
    }

    public void testSataticClassImportViaFactory() {
        Class<?> clazz;
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(CoreConfidenceTests.createTestMap());
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        try {
            clazz = Class.forName("org.mvel.tests.main.AbstractTest$Person");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        classes.addClass(clazz);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("p = new Person('tom'); return p.name;", classes.getImportedClasses());
        CoreConfidenceTests.assertEquals((Object)"tom", (Object)MVEL.executeExpression((Object)compiled, mvf));
    }

    public void testSataticClassImportViaFactoryAndWithModification() {
        Class<?> clazz;
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(CoreConfidenceTests.createTestMap());
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        try {
            clazz = Class.forName("org.mvel.tests.main.AbstractTest$Person");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        classes.addClass(clazz);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("p = new Person('tom'); p.age = 20; with( p ) { age = p.age + 1 }; return p.age;", classes.getImportedClasses());
        CoreConfidenceTests.assertEquals((Object)new Integer(21), (Object)MVEL.executeExpression((Object)compiled, mvf));
    }

    public void testCheeseConstructor() {
        Class<?> clazz;
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(CoreConfidenceTests.createTestMap());
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Cheese");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        classes.addClass(clazz);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("cheese = new Cheese(\"cheddar\", 15);", classes.getImportedClasses());
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)compiled, mvf) instanceof Cheese));
    }

    public void testInterceptors() {
        Interceptor testInterceptor = new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                System.out.println("BEFORE Node: " + node.getName());
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("AFTER Node: " + node.getName());
                return 0;
            }
        };
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        interceptors.put("test", testInterceptor);
        Serializable compiled = MVEL.compileExpression("@test System.out.println('MIDDLE');", null, interceptors);
        MVEL.executeExpression(compiled);
    }

    public void testMacroSupport() {
        HashMap<String, Foo> vars = new HashMap<String, Foo>();
        vars.put("foo", new Foo());
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Modify", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                factory.createVariable("mod", "FOOBAR!");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                return 0;
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        ExpressionCompiler compiler = new ExpressionCompiler(MVEL.parseMacros("modify (foo) { aValue = 'poo' }; mod", macros));
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext(null, interceptors, null);
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)MVEL.executeExpression((Object)compiled, null, vars));
    }

    public void testMacroSupportWithDebugging() {
        HashMap<String, Foo> vars = new HashMap<String, Foo>();
        vars.put("foo", new Foo());
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Modify", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                factory.createVariable("mod", "FOOBAR!");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                return 0;
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        ExpressionCompiler compiler = new ExpressionCompiler(MVEL.parseMacros("System.out.println('hello');\nSystem.out.println('bye');\nmodify (foo) { aValue = 'poo', \n aValue = 'poo' };\n mod", macros));
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext(null, interceptors, null);
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        MVELRuntime.setThreadDebugger(new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println(String.valueOf(frame.getSourceName()) + ":" + frame.getLineNumber());
                return 1;
            }
        });
        MVELRuntime.registerBreakpoint("test.mv", 3);
        System.out.println(DebugTools.decompile(compiled));
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(vars)));
    }

    public void testExecuteCoercionTwice() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("foo", new Foo());
        vars.put("$value", new Long(5L));
        ExpressionCompiler compiler = new ExpressionCompiler("with (foo) { countTest = $value };");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        MVEL.executeExpression((Object)compiled, null, vars);
        MVEL.executeExpression((Object)compiled, null, vars);
    }

    public void testComments() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("// This is a comment\n5 + 5"));
    }

    public void testComments2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(20), (Object)this.test("10 + 10; // This is a comment"));
    }

    public void testComments3() {
        CoreConfidenceTests.assertEquals((Object)new Integer(30), (Object)this.test("/* This is a test of\r\nMVEL's support for\r\nmulti-line comments\r\n*/\r\n 15 + 15"));
    }

    public void testComments4() {
        CoreConfidenceTests.assertEquals((Object)new Integer(50), (Object)this.test("/** This is a fun test script **/\r\na = 10;\r\n/**\r\n* Here is a useful variable\r\n*/\r\nb = 20; // set b to '20'\r\nreturn ((a + b) * 2) - 10;\r\n// last comment\n"));
    }

    public void testSubtractNoSpace1() {
        CoreConfidenceTests.assertEquals((Object)new Integer(59), (Object)this.test("hour-1"));
    }

    public void testStrictTypingCompilation() {
        ExpressionCompiler compiler = new ExpressionCompiler("a.foo;\nb.foo;\n x = 5");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        try {
            compiler.compile(ctx);
        }
        catch (CompileException e) {
            e.printStackTrace();
            CoreConfidenceTests.assertEquals((int)2, (int)e.getErrors().size());
            return;
        }
        CoreConfidenceTests.assertTrue((boolean)false);
    }

    public void testStrictStaticMethodCall() {
        Class<?> clazz;
        ExpressionCompiler compiler = new ExpressionCompiler("Bar.staticMethod()");
        ParserContext ctx = new ParserContext();
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Bar");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addImport("Bar", clazz);
        ctx.setStrictTypeEnforcement(true);
        CompiledExpression s = compiler.compile(ctx);
        DebugTools.decompile((Serializable)s);
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)MVEL.executeExpression(s));
    }

    public void testStrictTypingCompilation2() throws Exception {
        Class<?> clazz;
        ParserContext ctx = new ParserContext();
        try {
            clazz = Class.forName("java.lang.Runtime");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addImport("getRuntime", new MethodStub(clazz.getMethod("getRuntime", new Class[0])));
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("getRuntime()");
        StaticMethodImportResolverFactory si = new StaticMethodImportResolverFactory(ctx);
        CompiledExpression expression = compiler.compile(ctx);
        CoreConfidenceTests.serializationTest(expression);
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)expression, si) instanceof Runtime));
    }

    public void testStrictTypingCompilation3() throws NoSuchMethodException {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("message='Hello';b=7;\nSystem.out.println(message + ';' + b);\nSystem.out.println(message + ';' + b); b");
        CoreConfidenceTests.assertEquals((Object)new Integer(7), (Object)MVEL.executeExpression((Object)compiler.compile(ctx), new DefaultLocalVariableResolverFactory()));
    }

    public void testStrictTypingCompilation4() throws NoSuchMethodException {
        Class<?> clazz;
        Class<?> clazz2;
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        try {
            clazz2 = Class.forName("org.mvel.tests.main.res.Foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addImport(clazz2);
        ExpressionCompiler compiler = new ExpressionCompiler("x_a = new Foo()");
        compiler.compile(ctx);
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)ctx.getVariables().get("x_a"));
    }

    public void testProvidedExternalTypes() {
        Class<?> clazz;
        ExpressionCompiler compiler = new ExpressionCompiler("foo.bar");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addInput("foo", clazz);
        compiler.compile(ctx);
    }

    public void testEqualityRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("price == (new Integer( 5 ) + 5 ) ");
        compiler.compile();
    }

    public void testEvaluationRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("(p.age * 2)");
        compiler.compile();
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("p"));
    }

    public void testAssignmentRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("total = total + $cheese.price");
        compiler.compile();
    }

    public void testTypeRegression() {
        Class<?> clazz;
        ExpressionCompiler compiler = new ExpressionCompiler("total = 0");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        compiler.compile(ctx);
        try {
            clazz = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)compiler.getParserContextState().getVarOrInputType("total"));
    }

    public void testDateComparison() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("dt1 < dt2")));
    }

    public void testDynamicDeop() {
        Serializable s = MVEL.compileExpression("name");
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)s, new Foo()));
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)s, new Foo().getBar()));
    }

    public void testVirtProperty() {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("test", "foo");
        HashMap<String, HashMap<String, String>> vars = new HashMap<String, HashMap<String, String>>();
        vars.put("mp", testMap);
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeExpression((Object)MVEL.compileExpression("mp.test = 'bar'; mp.test"), vars));
    }

    public void testMapPropertyCreateCondensed() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("map = new java.util.HashMap(); map['test'] = 'foo'; map['test'];"));
    }

    public void testClassLiteral() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)this.test("java.lang.String"));
    }

    public void testDeepMethod() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("foo.bar.testList.add(new String()); foo.bar.testList == empty"));
    }

    public void testArrayAccessorAssign() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("a = {'f00', 'bar'}; a[0] = 'foo'; a[0]"));
    }

    public void testListAccessorAssign() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("a = new java.util.ArrayList(); a.add('foo'); a.add('BAR'); a[1] = 'bar'; a[1]"));
    }

    public void testBracketInString() {
        this.test("System.out.println('1)your guess was:');");
    }

    public void testNesting() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("new String(new String(new String(\"foo\")));"));
    }

    public void testDeepPropertyAdd() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("foo.countTest+ 10"));
    }

    public void testDeepAssignmentIncrement() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("foo.countTest += 5; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    public void testDeepAssignmentWithBlock() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("with (foo) { countTest += 5 }; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    public void testTypeCast() {
        CoreConfidenceTests.assertEquals((Object)"10", (Object)this.test("(String) 10"));
    }

    public void testMapAccessSemantics() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)CoreConfidenceTests.testCompiledSimple("innermap['test']", outermap));
    }

    public void testMapBindingSemantics() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        MVEL.setProperty(outermap, "innermap['test']", "bar");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)CoreConfidenceTests.testCompiledSimple("innermap['test']", outermap));
    }

    public void testSetSemantics() {
        Bar bar = new Bar();
        Foo foo = new Foo();
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.getProperty("name", bar));
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.getProperty("name", foo));
    }

    public void testMapBindingSemantics2() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        Serializable s = MVEL.compileSetExpression("innermap['test']");
        MVEL.executeSetExpression(s, outermap, "bar");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)CoreConfidenceTests.testCompiledSimple("innermap['test']", outermap));
    }

    public void testDynamicImports() {
        Class<?> clazz;
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("java.util");
        ExpressionCompiler compiler = new ExpressionCompiler("HashMap");
        CompiledExpression s = compiler.compile(ctx);
        try {
            clazz = Class.forName("java.util.HashMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)MVEL.executeExpression(s));
        compiler = new ExpressionCompiler("map = new HashMap(); map.size()");
        s = compiler.compile(ctx);
        CoreConfidenceTests.assertEquals((Object)new Integer(0), (Object)MVEL.executeExpression((Object)s, new DefaultLocalVariableResolverFactory()));
    }

    public void testDynamicImportsWithIdentifierSameAsClassWithDiffCase() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("org.mvel.tests.main.res");
        ctx.setStrictTypeEnforcement(false);
        ExpressionCompiler compiler = new ExpressionCompiler("bar.add(\"hello\")");
        CompiledExpression s = compiler.compile(ctx);
    }

    public void testTypedAssignment() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)this.test("java.util.Map map = new java.util.HashMap(); map.put('conan', 'foobar'); map['conan'];"));
    }

    public void testFQCNwithStaticInList() {
        CoreConfidenceTests.assertEquals((Object)new Integer(Integer.MIN_VALUE), (Object)this.test("list = [java.lang.Integer.MIN_VALUE]; list[0]"));
    }

    public void testPrecedenceOrder() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("5 > 6 && 2 < 1 || 10 > 9")));
    }

    public void testDifferentImplSameCompile() {
        Serializable compiled = MVEL.compileExpression("a.funMap.hello");
        HashMap<String, Base> testMap = new HashMap<String, Base>();
        int i = 0;
        while (i < 100) {
            Base b = new Base();
            b.funMap.put("hello", "dog");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)compiled, testMap));
            b = new Base();
            b.funMap.put("hello", "cat");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"cat", (Object)MVEL.executeExpression((Object)compiled, testMap));
            ++i;
        }
    }

    public void testInterfaceMethodCallWithSpace() {
        Serializable compiled = MVEL.compileExpression("drools.retract (cheese)");
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)compiled, map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testInterfaceMethodCallWithMacro() {
        HashMap<String, Macro> macros = new HashMap<String, Macro>(1);
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        Serializable compiled = MVEL.compileExpression(MVEL.parseMacros("retract(cheese)", macros));
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)compiled, map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testToList() {
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        List list = (List)this.test(text);
        CoreConfidenceTests.assertSame((Object)"dog", list.get(0));
        CoreConfidenceTests.assertEquals((Object)"hello", list.get(1));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), list.get(2));
        Map map = (Map)list.get(3);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("key1"));
        List nestedList = (List)map.get("cat");
        CoreConfidenceTests.assertEquals((Object)new Integer(14), nestedList.get(0));
        CoreConfidenceTests.assertEquals((Object)"car", nestedList.get(1));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), nestedList.get(2));
        nestedList = (List)list.get(4);
        CoreConfidenceTests.assertEquals((Object)new Integer(42), nestedList.get(0));
        map = (Map)nestedList.get(1);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("cat"));
    }

    public void testToListStrictMode() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        ParserContext ctx = new ParserContext();
        try {
            clazz3 = Class.forName("org.mvel.tests.main.AbstractTest$MiscTestClass");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addInput("misc", clazz3);
        try {
            clazz2 = Class.forName("org.mvel.tests.main.res.Foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addInput("foo", clazz2);
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addInput("c", clazz);
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        CompiledExpression expr = compiler.compile(ctx);
        List list = (List)MVEL.executeExpression((Object)expr, CoreConfidenceTests.createTestMap());
        CoreConfidenceTests.assertSame((Object)"dog", list.get(0));
        CoreConfidenceTests.assertEquals((Object)"hello", list.get(1));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), list.get(2));
        Map map = (Map)list.get(3);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("key1"));
        List nestedList = (List)map.get("cat");
        CoreConfidenceTests.assertEquals((Object)new Integer(14), nestedList.get(0));
        CoreConfidenceTests.assertEquals((Object)"car", nestedList.get(1));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), nestedList.get(2));
        nestedList = (List)list.get(4);
        CoreConfidenceTests.assertEquals((Object)new Integer(42), nestedList.get(0));
        map = (Map)nestedList.get(1);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("cat"));
    }

    public void testParsingStability1() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("( order.number == 1 || order.number == ( 1+1) || order.number == $id )"));
    }

    public void testParsingStability2() {
        Class<?> clazz;
        ExpressionCompiler compiler = new ExpressionCompiler("( dim.height == 1 || dim.height == ( 1+1) || dim.height == x )");
        HashMap<String, Object> imports = new HashMap<String, Object>();
        try {
            clazz = Class.forName("java.awt.Dimension");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        imports.put("java.awt.Dimension", clazz);
        ParserContext parserContext = new ParserContext(imports, null, "sourceFile");
        parserContext.setStrictTypeEnforcement(false);
        compiler.compile(parserContext);
    }

    public void testParsingStability3() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("!( [\"X\", \"Y\"] contains \"Y\" )"));
    }

    public void testParsingStability4() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("vv=\"Edson\"; !(vv ~= \"Mark\")"));
    }

    public void testConcatWithLineBreaks() {
        ExpressionCompiler parser = new ExpressionCompiler("\"foo\"+\n\"bar\"");
        ParserContext ctx = new ParserContext();
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("source.mv");
        CompiledExpression c = parser.compile(ctx);
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)MVEL.executeExpression(c));
    }

    public void testCalculateAge() {
        Calendar c1 = Calendar.getInstance();
        c1.set(1999, 0, 10);
        HashMap objectMap = new HashMap(1);
        HashMap<String, Date> propertyMap = new HashMap<String, Date>(1);
        propertyMap.put("GEBDAT", c1.getTime());
        objectMap.put("EV_VI_ANT1", propertyMap);
        CoreConfidenceTests.assertEquals((Object)"N", (Object)MVEL.eval("new org.mvel.tests.main.res.PDFFieldUtil().calculateAge(EV_VI_ANT1.GEBDAT) >= 25 ? 'Y' : 'N'", objectMap));
        CoreConfidenceTests.assertEquals((Object)"N", (Object)CoreConfidenceTests.testCompiledSimple("new org.mvel.tests.main.res.PDFFieldUtil().calculateAge(EV_VI_ANT1.GEBDAT) >= 25 ? 'Y' : 'N'", objectMap));
    }

    public void testMethodResolutionWithNullParameter() {
        AbstractTest.Context ctx = new AbstractTest.Context();
        ctx.setBean(new AbstractTest.Bean());
        HashMap vars = new HashMap();
        System.out.println("bean.today: " + MVEL.eval("bean.today", (Object)ctx, vars));
        System.out.println("formatDate(bean.today): " + MVEL.eval("formatDate(bean.today)", (Object)ctx, vars));
        System.out.println("formatString(bean.nullString): " + MVEL.eval("formatString(bean.nullString)", (Object)ctx, vars));
        System.out.println("bean.myDate = bean.nullDate: " + MVEL.eval("bean.myDate = bean.nullDate; return bean.nullDate;", (Object)ctx, vars));
        System.out.println("formatDate(bean.myDate): " + MVEL.eval("formatDate(bean.myDate)", (Object)ctx, vars));
        System.out.println(MVEL.eval("formatDate(bean.nullDate)", (Object)ctx, vars));
    }

    public void testCompileParserContextShouldNotLoopIndefinitelyOnValidJavaExpression() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        String expr = "\t\tSystem.out.println( message );\nm.setMessage( \"Goodbye cruel world\" );\nSystem.out.println(m.getStatus());\nm.setStatus( Message.GOODBYE );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        try {
            clazz3 = Class.forName("org.mvel.tests.main.AbstractTest$Message");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("Message", clazz3);
        context.addInput("System", Void.TYPE);
        try {
            clazz2 = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addInput("message", clazz2);
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addInput("m", clazz);
        compiler.compile(context);
    }

    public void testStaticNested() {
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)MVEL.eval("org.mvel.tests.main.AbstractTest$Message.GOODBYE", new HashMap()));
    }

    public void testStaticNestedWithImport() {
        Class<?> clazz;
        String expr = "Message.GOODBYE;\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        try {
            clazz = Class.forName("org.mvel.tests.main.AbstractTest$Message");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("Message", clazz);
        CompiledExpression compiledExpression = compiler.compile(context);
        CoreConfidenceTests.assertEquals((Object)new Integer(1), (Object)MVEL.executeExpression(compiledExpression));
    }

    public void testStaticNestedWithMethodCall() {
        Class<?> clazz;
        Class<?> clazz2;
        String expr = "item = new Item( \"Some Item\"); $msg.addItem( item ); return $msg";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        try {
            clazz2 = Class.forName("org.mvel.tests.main.AbstractTest$Message");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("Message", clazz2);
        try {
            clazz = Class.forName("org.mvel.tests.main.AbstractTest$Item");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("Item", clazz);
        CompiledExpression compiledExpression = compiler.compile(context);
        HashMap<String, AbstractTest.Message> vars = new HashMap<String, AbstractTest.Message>();
        vars.put("$msg", new AbstractTest.Message());
        AbstractTest.Message msg = (AbstractTest.Message)MVEL.executeExpression((Object)compiledExpression, vars);
        AbstractTest.Item item = (AbstractTest.Item)msg.getItems().get(0);
        CoreConfidenceTests.assertEquals((String)"Some Item", (String)item.getName());
    }

    public void testsequentialAccessorsThenMethodCall() {
        Class<?> clazz;
        String expr = "System.out.println(drools.workingMemory); drools.workingMemory.ruleBase.removeRule(\"org.drools.examples\", \"some rule\"); ";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(true);
        try {
            clazz = Class.forName("org.mvel.tests.main.res.KnowledgeHelper");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addInput("drools", clazz);
        RuleBaseImpl ruleBase = new RuleBaseImpl();
        WorkingMemoryImpl wm = new WorkingMemoryImpl(ruleBase);
        DefaultKnowledgeHelper drools = new DefaultKnowledgeHelper(wm);
        CompiledExpression compiledExpression = compiler.compile(context);
        HashMap<String, DefaultKnowledgeHelper> vars = new HashMap<String, DefaultKnowledgeHelper>();
        vars.put("drools", drools);
        MVEL.executeExpression((Object)compiledExpression, vars);
    }

    public void testPropertyVerfierShoudldNotLoopIndefinately() {
        Class<?> clazz;
        Class<?> clazz2;
        String expr = "\t\tmodel.latestHeadlines = $list;\nmodel.latestHeadlines.add( 0, (model.latestHeadlines[2]) );";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setVerifying(true);
        ParserContext pCtx = new ParserContext();
        try {
            clazz2 = Class.forName("java.util.List");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        pCtx.addInput("$list", clazz2);
        try {
            clazz = Class.forName("org.mvel.tests.main.AbstractTest$Model");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        pCtx.addInput("model", clazz);
        compiler.compile(pCtx);
    }

    public void testCompileWithNewInsideMethodCall() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        String expr = "     p.name = \"goober\";\n     System.out.println(p.name);\n     drools.insert(new Address(\"Latona\"));\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        try {
            clazz4 = Class.forName("org.mvel.tests.main.AbstractTest$Person");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("Person", clazz4);
        try {
            clazz3 = Class.forName("org.mvel.tests.main.AbstractTest$Address");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport("Address", clazz3);
        try {
            clazz2 = Class.forName("org.mvel.tests.main.AbstractTest$Person");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addInput("p", clazz2);
        try {
            clazz = Class.forName("org.mvel.tests.main.AbstractTest$Drools");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addInput("drools", clazz);
        compiler.compile(context);
    }

    public void testBug4() {
        AbstractTest.ClassA A = new AbstractTest.ClassA();
        AbstractTest.ClassB B = new AbstractTest.ClassB();
        System.out.println(MVEL.getProperty("date", A));
        System.out.println(MVEL.getProperty("date", B));
    }

    public void testInlineCollectionParser1() {
        CoreConfidenceTests.assertEquals((Object)"q", ((Map)this.test("['Person.age' : [1, 2, 3, 4],'Person.rating' : 'q']")).get("Person.rating"));
        CoreConfidenceTests.assertEquals((Object)"q", ((Map)this.test("['Person.age' : [1, 2, 3, 4], 'Person.rating' : 'q']")).get("Person.rating"));
    }

    public void testIndexer() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)MVEL.eval("import java.util.LinkedHashMap; LinkedHashMap map = new LinkedHashMap(); map.put('a', 'foo'); map.put('b', 'bar'); s = ''; foreach (key : map.keySet()) { System.out.println(map[key]); s += map[key]; }; return s;", new HashMap()));
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)CoreConfidenceTests.testCompiledSimple("import java.util.LinkedHashMap; LinkedHashMap map = new LinkedHashMap(); map.put('a', 'foo'); map.put('b', 'bar'); s = ''; foreach (key : map.keySet()) { System.out.println(map[key]); s += map[key]; }; return s;", new HashMap()));
    }

    public void testLateResolveOfClass() {
        Class<?> clazz;
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println(new Foo());");
        ParserContext ctx = new ParserContext();
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ctx.addImport(clazz);
        CompiledExpression s = compiler.compile(ctx);
        compiler.removeParserContext();
        System.out.println(MVEL.executeExpression(s));
    }

    public void testClassAliasing() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)this.test("Foo = String; new Foo('foobar')"));
    }

    public void testRandomExpression1() {
        CoreConfidenceTests.assertEquals((Object)"HelloWorld", (Object)this.test("if ((x15 = foo.bar) == foo.bar && x15 == foo.bar) { return 'HelloWorld'; } else { return 'GoodbyeWorld' } "));
    }

    public void testRandomExpression2() {
        CoreConfidenceTests.assertEquals((Object)new Integer(11), (Object)this.test("counterX = 0; foreach (item:{1,2,3,4,5,6,7,8,9,10}) { counterX++; }; return counterX + 1;"));
    }

    public void testRandomExpression3() {
        CoreConfidenceTests.assertEquals((Object)new Integer(0), (Object)this.test("counterX = 10; foreach (item:{1,1,1,1,1,1,1,1,1,1}) { counterX -= item; } return counterX;"));
    }

    public void testRandomExpression4() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("result = org.mvel.MVEL.eval('10 * 3'); result == (10 * 3);"));
    }

    public void testRandomExpression5() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("FooClassRef = foo.getClass(); fooInst = new FooClassRef(); name = org.mvel.MVEL.eval('name', fooInst); return name == 'dog'"));
    }

    public void testRandomExpression6() {
        CoreConfidenceTests.assertEquals((Object)new Integer(500), (Object)this.test("exprString = '250' + ' ' + '*' + ' ' + '2'; compiledExpr = org.mvel.MVEL.compileExpression(exprString); return org.mvel.MVEL.executeExpression(compiledExpr);"));
    }

    public void testRandomExpression7() {
        CoreConfidenceTests.assertEquals((Object)"FOOBAR", (Object)this.test("'foobar'.toUpperCase();"));
    }

    public void testRandomExpression8() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("'someString'.intern(); 'someString'.hashCode() == 'someString'.hashCode();"));
    }

    public void testRandomExpression9() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("_abc = 'someString'.hashCode(); _xyz = _abc + 1; _abc == _xyz"));
    }

    public void testRandomExpression10() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.test("(_abc = (_xyz = 'someString'.hashCode()) + 1); _abc == _xyz"));
    }

    public void testAddIntToMapWithMapSyntax() throws Throwable {
        this.outerMap = new HashMap<Object, Object>();
        this.innerMap = new HashMap<Object, Object>();
        this.outerMap.put("innerMap", this.innerMap);
        PropertyAccessor.set(this.outerMap, "innerMap['foo']", new Integer(42));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), (Object)this.innerMap.get("foo"));
    }

    public void testUpdateIntInMapWithMapSyntax() throws Throwable {
        this.outerMap = new HashMap<Object, Object>();
        this.innerMap = new HashMap<Object, Object>();
        this.outerMap.put("innerMap", this.innerMap);
        this.innerMap.put("foo", new Integer(21));
        PropertyAccessor.set(this.outerMap, "innerMap['foo']", new Integer(42));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), (Object)this.innerMap.get("foo"));
    }

    public void before() {
        HashMap<String, MyBean> map = new HashMap<String, MyBean>();
        MyBean bean = new MyBean();
        bean.setVar(4);
        map.put("bean", bean);
        this.context.put("map", map);
    }

    public void testDeepProperty() {
        this.before();
        Serializable compiled = MVEL.compileExpression("map.bean.var");
        Object obj = MVEL.executeExpression((Object)compiled, this.context);
        CoreConfidenceTests.assertEquals((Object)new Integer(4), (Object)obj);
    }

    public void testDeepProperty2() {
        this.before();
        Serializable compiled = MVEL.compileExpression("map.bean.getVar()");
        Object obj = MVEL.executeExpression((Object)compiled, this.context);
        CoreConfidenceTests.assertEquals((Object)new Integer(4), (Object)obj);
    }

    public void testNestedMethodCall() {
        ArrayList<TargetClass> elements = new ArrayList<TargetClass>();
        elements.add(new TargetClass());
        HashMap<String, ArrayList<TargetClass>> variableMap = new HashMap<String, ArrayList<TargetClass>>();
        variableMap.put("elements", elements);
        MVEL.eval("results = new java.util.ArrayList(); foreach (element : elements) { if( {5} contains element.targetValue.intValue()) { results.add(element); } }; results", variableMap);
    }

    public void testBooleanEvaluation() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("true||false||false"));
    }

    public void testBooleanEvaluation2() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("equalityCheck(1,1)||fun||ackbar"));
    }

    public void testFailing() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("os", "windows");
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.eval("os ~= 'windows|unix'", map)));
    }

    public void testSuccess() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("os", "windows");
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.eval("'windows' ~= 'windows|unix'", map)));
        CoreConfidenceTests.assertFalse((boolean)((Boolean)MVEL.eval("time ~= 'windows|unix'", new Date())));
    }

    public void testBooleanStrAppend() {
        CoreConfidenceTests.assertEquals((Object)"footrue", (Object)this.test("\"foo\" + true"));
    }

    public void testAssignPlus() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("xx0 = 5; xx0 += 4; xx0 + 1"));
    }

    public void testAssignDiv() {
        CoreConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.test("xx0 = 20; xx0 /= 10; xx0"));
    }

    public void testAssignMult() {
        CoreConfidenceTests.assertEquals((Object)new Integer(36), (Object)this.test("xx0 = 6; xx0 *= 6; xx0"));
    }

    public void testAssignSub() {
        CoreConfidenceTests.assertEquals((Object)new Integer(11), (Object)this.test("xx0 = 15; xx0 -= 4; xx0"));
    }

    public void testFail() {
        HashMap<String, JButton> map = new HashMap<String, JButton>();
        map.put("a", new JButton());
        map.put("b", new JButton());
        new JButton().setToolTipText("");
        System.out.println(CoreConfidenceTests.testCompiledSimple("if (a.text!=null) {\n    b.text = a.text;\n} else if (a.toolTipText!=null) { \n    b.text = a.toolTipText;\n} return b;", map));
    }

    public void testPass() {
        HashMap<String, JButton> map = new HashMap<String, JButton>();
        map.put("a", new JButton());
        map.put("b", new JButton());
        new JButton().setToolTipText("");
        System.out.println(CoreConfidenceTests.testCompiledSimple("if (a.text!=null) {\n    b.text = a.text;\n} if (a.text!=null && a.toolTipText!=null) { \n    b.text = a.toolTipText;\n}return b;", map));
        System.out.println(CoreConfidenceTests.testCompiledSimple("if (a.text!=null) {\n    b.text = a.text;\n} else if (a.text!=null && a.toolTipText!=null) { \n    b.text = a.toolTipText;\n}", map));
    }

    public void testCommentsInWith() {
        HashMap<String, JFrame> map = new HashMap<String, JFrame>();
        map.put("f", new JFrame());
        System.out.println(MVEL.eval("with (f) {\ntitle = 'blah', // setting title\nalwaysOnTop = false \n}", map));
    }

    public void testStaticWithExplicitParam() {
        PojoStatic pojo = new PojoStatic("10");
        MVEL.eval("org.mvel.tests.main.res.AStatic.Process('10')", (Object)pojo, new HashMap());
    }

    public void testSimpleExpression() {
        PojoStatic pojo = new PojoStatic("10");
        MVEL.eval("value!= null", (Object)pojo, new HashMap());
    }

    public void testStaticWithExpressionParam() {
        PojoStatic pojo = new PojoStatic("10");
        CoreConfidenceTests.assertEquals((Object)"java.lang.String", (Object)MVEL.eval("org.mvel.tests.main.res.AStatic.Process(value.getClass().getName().toString())", pojo));
    }

    public void testStringIndex() {
        CoreConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.test("a = 'foobar'; a[4] == 'a'"));
    }

    public void testArrayConstructionSupport1() {
        CoreConfidenceTests.assertTrue((boolean)(this.test("new String[5]") instanceof String[]));
    }

    public void testArrayConstructionSupport2() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("xStr = new String[5]; xStr.size() == 5")));
    }

    public void testArrayConstructionSupport3() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("xStr = new String[5][5]; xStr[4][0] = 'foo'; xStr[4][0]"));
    }

    public void testArrayConstructionSupport4() {
        CoreConfidenceTests.assertEquals((Object)new Integer(10), (Object)this.test("xStr = new String[5][10]; xStr[4][0] = 'foo'; xStr[4].length"));
    }

    public void testMethodInvocationWithCollectionElement() {
        this.context = new HashMap();
        this.context.put("pojo", new POJO());
        this.context.put("number", "1192800637980");
        Object result = MVEL.eval("pojo.function(pojo.dates[0].time)", this.context);
        CoreConfidenceTests.assertEquals((Object)String.valueOf(((POJO)this.context.get("pojo")).getDates().iterator().next().getTime()), (Object)result);
    }

    public void testNestedWithInList() {
        Class<?> clazz;
        Recipient recipient1 = new Recipient();
        recipient1.setName("userName1");
        recipient1.setEmail("user1@domain.com");
        Recipient recipient2 = new Recipient();
        recipient2.setName("userName2");
        recipient2.setEmail("user2@domain.com");
        ArrayList<Recipient> list = new ArrayList<Recipient>();
        list.add(recipient1);
        list.add(recipient2);
        String text = "array = [(with ( new Recipient() ) {name = 'userName1', email = 'user1@domain.com' }),(with ( new Recipient() ) {name = 'userName2', email = 'user2@domain.com' })];\n";
        ParserContext context = new ParserContext();
        try {
            clazz = Class.forName("org.mvel.tests.main.CoreConfidenceTests$Recipient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport(clazz);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        CompiledExpression execution = compiler.compile(context);
        List result = (List)MVEL.executeExpression(execution);
        CoreConfidenceTests.assertEquals(list, (Object)result);
    }

    public void testNestedWithInMethod() {
        Class<?> clazz;
        Class<?> clazz2;
        Recipient recipient1 = new Recipient();
        recipient1.setName("userName1");
        recipient1.setEmail("user1@domain.com");
        Recipients recipients = new Recipients();
        recipients.addRecipient(recipient1);
        String text = "recipients = new Recipients();\nrecipients.addRecipient( (with ( new Recipient() ) {name = 'userName1', email = 'user1@domain.com' }) );\nreturn recipients;\n";
        ParserContext context = new ParserContext();
        context = new ParserContext();
        try {
            clazz2 = Class.forName("org.mvel.tests.main.CoreConfidenceTests$Recipient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport(clazz2);
        try {
            clazz = Class.forName("org.mvel.tests.main.CoreConfidenceTests$Recipients");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport(clazz);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        CompiledExpression execution = compiler.compile(context);
        Recipients result = (Recipients)MVEL.executeExpression(execution);
        CoreConfidenceTests.assertEquals((Object)recipients, (Object)result);
    }

    public void testNestedWithInComplexGraph() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Recipients recipients = new Recipients();
        Recipient recipient1 = new Recipient();
        recipient1.setName("user1");
        recipient1.setEmail("user1@domain.com");
        recipients.addRecipient(recipient1);
        Recipient recipient2 = new Recipient();
        recipient2.setName("user2");
        recipient2.setEmail("user2@domain.com");
        recipients.addRecipient(recipient2);
        EmailMessage msg = new EmailMessage();
        msg.setRecipients(recipients);
        msg.setFrom("from@domain.com");
        String text = "(with ( new EmailMessage() ) { recipients = (with (new Recipients()) { recipients = [(with ( new Recipient() ) {name = 'user1', email = 'user1@domain.com'}), (with ( new Recipient() ) {name = 'user2', email = 'user2@domain.com'}) ] }),  from = 'from@domain.com' } )";
        ParserContext context = new ParserContext();
        context = new ParserContext();
        try {
            clazz3 = Class.forName("org.mvel.tests.main.CoreConfidenceTests$Recipient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport(clazz3);
        try {
            clazz2 = Class.forName("org.mvel.tests.main.CoreConfidenceTests$Recipients");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport(clazz2);
        try {
            clazz = Class.forName("org.mvel.tests.main.CoreConfidenceTests$EmailMessage");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addImport(clazz);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        CompiledExpression execution = compiler.compile(context);
        EmailMessage result = (EmailMessage)MVEL.executeExpression(execution);
        CoreConfidenceTests.assertEquals((Object)msg, (Object)result);
    }

    public void testSubEvaluation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EV_BER_BER_NR", "12345");
        map.put("EV_BER_BER_PRIV", Boolean.FALSE);
        CoreConfidenceTests.assertEquals((Object)"12345", (Object)MVEL.eval("EV_BER_BER_NR + ((EV_BER_BER_PRIV != empty && EV_BER_BER_PRIV == true) ? \"/PRIVAT\" : '')", map));
        map.put("EV_BER_BER_PRIV", Boolean.TRUE);
        CoreConfidenceTests.assertEquals((Object)"12345/PRIVAT", (Object)CoreConfidenceTests.testCompiledSimple("EV_BER_BER_NR + ((EV_BER_BER_PRIV != empty && EV_BER_BER_PRIV == true) ? \"/PRIVAT\" : '')", map));
    }

    public void testNestedMethod1() {
        Vector<String> vectorA = new Vector<String>();
        Vector vectorB = new Vector();
        vectorA.add("Foo");
        HashMap map = new HashMap();
        map.put("vecA", vectorA);
        map.put("vecB", vectorB);
        CoreConfidenceTests.testCompiledSimple("vecB.add(vecA.remove(0)); vecA.add('Foo');", map);
        CoreConfidenceTests.assertEquals((Object)"Foo", vectorB.get(0));
    }

    public void testNegativeArraySizeBug() throws Exception {
        String expressionString1 = "results = new java.util.ArrayList(); foreach (element : elements) { if( ( {30, 214, 158, 31, 95, 223, 213, 86, 159, 34, 32, 96, 224, 160, 85, 201, 29, 157, 100, 146, 82, 203, 194, 145, 140, 81, 27, 166, 212, 38, 28, 94, 168, 23, 87, 150, 35, 149, 193, 33, 132, 206, 93, 196, 24, 88, 195, 36, 26, 154, 167, 108, 204, 74, 46, 25, 153, 202, 79, 207, 143, 43, 16, 80, 198, 208, 144, 41, 97, 142, 83, 18, 162, 103, 155, 98, 44, 17, 205, 77, 156, 141, 165, 102, 84, 37, 101, 222, 40, 104, 99, 177, 182, 22, 180, 21, 137, 221, 179, 78, 42, 178, 19, 183, 139, 218, 219, 39, 220, 20, 184, 217, 138, 62, 190, 171, 123, 113, 59, 118, 225, 124, 169, 60, 117, 1} contains element.attribute ) ) { results.add(element); } }; results";
        String expressionString2 = "results = new java.util.ArrayList(); foreach (element : elements) { if( ( {30, 214, 158, 31, 95, 223, 213, 86, 159, 34, 32, 96, 224, 160, 85, 201, 29, 157, 100, 146, 82, 203, 194, 145, 140, 81, 27, 166, 212, 38, 28, 94, 168, 23, 87, 150, 35, 149, 193, 33, 132, 206, 93, 196, 24, 88, 195, 36, 26, 154, 167, 108, 204, 74, 46, 25, 153, 202, 79, 207, 143, 43, 16, 80, 198, 208, 144, 41, 97, 142, 83, 18, 162, 103, 155, 98, 44, 17, 205, 77, 156, 141, 165, 102, 84, 37, 101, 222, 40, 104, 99, 177, 182, 22, 180, 21, 137, 221, 179, 78, 42, 178, 19, 183, 139, 218, 219, 39, 220, 20, 184, 217, 138, 62, 190, 171, 123, 113, 59, 118, 225, 124, 169, 60, 117, 1, 61, 189, 122, 68, 58, 119, 63, 226, 3, 172} contains element.attribute ) ) { results.add(element); } }; results";
        ArrayList<Target> targets = new ArrayList<Target>();
        targets.add(new Target(1));
        targets.add(new Target(999));
        HashMap<String, ArrayList<Target>> vars = new HashMap<String, ArrayList<Target>>();
        vars.put("elements", targets);
        CoreConfidenceTests.assertEquals((int)1, (int)((List)MVEL.eval(expressionString1, vars)).size());
        CoreConfidenceTests.assertEquals((int)1, (int)((List)MVEL.eval(expressionString2, vars)).size());
        CoreConfidenceTests.assertEquals((int)1, (int)((List)CoreConfidenceTests.testCompiledSimple(expressionString1, vars)).size());
        CoreConfidenceTests.assertEquals((int)1, (int)((List)CoreConfidenceTests.testCompiledSimple(expressionString2, vars)).size());
    }

    public void testSetExpressions1() {
        HashMap myMap = new HashMap();
        Serializable fooExpr = MVEL.compileSetExpression("foo");
        MVEL.executeSetExpression(fooExpr, myMap, "blah");
        CoreConfidenceTests.assertEquals((Object)"blah", myMap.get("foo"));
        MVEL.executeSetExpression(fooExpr, myMap, "baz");
        CoreConfidenceTests.assertEquals((Object)"baz", myMap.get("foo"));
    }

    public void testInlineCollectionNestedObjectCreation() {
        Map m = (Map)this.test("['Person.age' : [1, 2, 3, 4], 'Person.rating' : ['High', 'Low'], 'Person.something' : (new String('foo').toUpperCase())]");
        CoreConfidenceTests.assertEquals((Object)"FOO", m.get("Person.something"));
    }

    public void testEgressType() {
        Class<?> clazz;
        Class<?> clazz2;
        ExpressionCompiler compiler = new ExpressionCompiler("( $cheese )");
        ParserContext context = new ParserContext();
        try {
            clazz2 = Class.forName("org.mvel.tests.main.res.Cheese");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        context.addInput("$cheese", clazz2);
        CompiledExpression expr = compiler.compile(context);
        try {
            clazz = Class.forName("org.mvel.tests.main.res.Cheese");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CoreConfidenceTests.assertEquals(clazz, (Object)expr.getKnownEgressType());
    }

    public void testDuplicateVariableDeclaration() {
        ExpressionCompiler compiler = new ExpressionCompiler("String x = \"abc\"; Integer x = new Integer( 10 );");
        ParserContext context = new ParserContext();
        try {
            CompiledExpression expr = compiler.compile(context);
            CoreConfidenceTests.fail((String)"Compilation must fail with duplicate variable declaration exception.");
        }
        catch (CompileException compileException) {
            // empty catch block
        }
    }

    public static class EmailMessage {
        private Recipients recipients;
        private String from;

        public Recipients getRecipients() {
            return this.recipients;
        }

        public void setRecipients(Recipients recipients) {
            this.recipients = recipients;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.recipients == null ? 0 : this.recipients.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmailMessage other = (EmailMessage)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.recipients == null ? other.recipients != null : !this.recipients.equals(other.recipients));
        }
    }

    public class MyBean {
        int var;

        public int getVar() {
            return this.var;
        }

        public void setVar(int var) {
            this.var = var;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class POJO {
        private Set<Date> dates = new HashSet<Date>();

        public POJO() {
            this.dates.add(new Date());
        }

        public Set<Date> getDates() {
            return this.dates;
        }

        public void setDates(Set<Date> dates) {
            this.dates = dates;
        }

        public String function(long num) {
            return String.valueOf(num);
        }
    }

    public static class Recipient {
        private String name;
        private String email;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Recipient other = (Recipient)obj;
            if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Recipients {
        private List<Recipient> list = Collections.EMPTY_LIST;

        public void setRecipients(List<Recipient> recipients) {
            this.list = recipients;
        }

        public boolean addRecipient(Recipient recipient) {
            if (this.list == Collections.EMPTY_LIST) {
                this.list = new ArrayList<Recipient>();
            }
            if (!this.list.contains(recipient)) {
                this.list.add(recipient);
                return true;
            }
            return false;
        }

        public boolean removeRecipient(Recipient recipient) {
            return this.list.remove(recipient);
        }

        public List<Recipient> getRecipients() {
            return this.list;
        }

        public Recipient[] toArray() {
            return this.list.toArray(new Recipient[this.list.size()]);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Recipients other = (Recipients)obj;
            return !(this.list == null ? other.list != null : !this.list.equals(other.list));
        }
    }

    public static final class Target {
        private int _attribute;

        public Target(int attribute_) {
            this._attribute = attribute_;
        }

        public int getAttribute() {
            return this._attribute;
        }
    }

    public static class TargetClass {
        private short _targetValue = (short)5;

        public short getTargetValue() {
            return this._targetValue;
        }
    }
}

