/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import org.mvel2.CompileException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.LocalVariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionVariableResolverFactory
extends BaseVariableResolverFactory
implements LocalVariableResolverFactory {
    public FunctionVariableResolverFactory(VariableResolverFactory nextFactory, String[] indexedVariables, Object[] parameters) {
        this.nextFactory = nextFactory;
        this.indexedVariableNames = indexedVariables;
        this.indexedVariableResolvers = new VariableResolver[indexedVariables.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.indexedVariableResolvers[i] = new SimpleValueResolver(parameters[i]);
        }
    }

    @Override
    public boolean isResolveable(String name) {
        for (String s : this.indexedVariableNames) {
            if (!name.equals(s)) continue;
            return true;
        }
        return this.variableResolvers != null && this.variableResolvers.containsKey(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        VariableResolver resolver = this.getVariableResolver(name);
        if (resolver == null) {
            int idx = this.increaseRegisterTableSize();
            this.indexedVariableNames[idx] = name;
            this.indexedVariableResolvers[idx] = new SimpleValueResolver(value);
            return this.indexedVariableResolvers[idx];
        }
        resolver.setValue(value);
        return resolver;
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr;
        VariableResolver variableResolver = vr = this.variableResolvers != null ? (VariableResolver)this.variableResolvers.get(name) : null;
        if (vr != null && vr.getType() != null) {
            throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        return this.createIndexedVariable(this.variableIndexOf(name), name, value);
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value) {
        if (this.indexedVariableResolvers[index] != null) {
            this.indexedVariableResolvers[index].setValue(value);
        } else {
            this.indexedVariableResolvers[index] = new SimpleValueResolver(value);
        }
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> type) {
        if (this.indexedVariableResolvers[index] != null) {
            this.indexedVariableResolvers[index].setValue(value);
        } else {
            this.indexedVariableResolvers[index] = new SimpleValueResolver(value);
        }
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index) {
        if (this.indexedVariableResolvers[index] == null) {
            this.indexedVariableResolvers[index] = super.getVariableResolver(this.indexedVariableNames[index]);
            return this.indexedVariableResolvers[index];
        }
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        int idx = this.variableIndexOf(name);
        if (idx != -1) {
            if (this.indexedVariableResolvers[idx] == null) {
                this.indexedVariableResolvers[idx] = super.getVariableResolver(name);
            }
            return this.indexedVariableResolvers[idx];
        }
        return super.getVariableResolver(name);
    }

    @Override
    public boolean isIndexedFactory() {
        return true;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableIndexOf(name) != -1;
    }

    private int increaseRegisterTableSize() {
        String[] oldNames = this.indexedVariableNames;
        VariableResolver[] oldResolvers = this.indexedVariableResolvers;
        int newLength = oldNames.length + 1;
        this.indexedVariableNames = new String[newLength];
        this.indexedVariableResolvers = new VariableResolver[newLength];
        for (int i = 0; i < oldNames.length; ++i) {
            this.indexedVariableNames[i] = oldNames[i];
            this.indexedVariableResolvers[i] = oldResolvers[i];
        }
        return newLength - 1;
    }
}

