/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.dynamic;

import org.mvel2.ParserContext;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.Accessor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.optimizers.dynamic.DynamicAccessor;
import org.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicGetAccessor
implements DynamicAccessor {
    private char[] property;
    private long stamp;
    private int type;
    private int runcount;
    private boolean opt = false;
    private ParserContext context;
    private Accessor _safeAccessor;
    private Accessor _accessor;

    public DynamicGetAccessor(ParserContext context, char[] property, int type, Accessor _accessor) {
        this._safeAccessor = this._accessor = _accessor;
        this.type = type;
        this.property = property;
        this.context = context;
        this.stamp = System.currentTimeMillis();
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                return this.optimize(ctx, elCtx, variableFactory);
            }
            this.runcount = 0;
            this.stamp = System.currentTimeMillis();
        }
        return this._accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        ++this.runcount;
        return this._accessor.setValue(ctx, elCtx, variableFactory, value);
    }

    private Object optimize(Object ctx, Object elCtx, VariableResolverFactory variableResolverFactory) {
        if (DynamicOptimizer.classLoader.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        AccessorOptimizer ao = OptimizerFactory.getAccessorCompiler("ASM");
        switch (this.type) {
            case 0: {
                this._accessor = ao.optimizeAccessor(this.context, this.property, ctx, elCtx, variableResolverFactory, false, null);
                return ao.getResultOptPass();
            }
            case 3: {
                this._accessor = ao.optimizeObjectCreation(this.context, this.property, ctx, elCtx, variableResolverFactory);
                return this._accessor.getValue(ctx, elCtx, variableResolverFactory);
            }
            case 2: {
                this._accessor = ao.optimizeCollection(AbstractParser.getCurrentThreadParserContext(), ctx, null, this.property, ctx, elCtx, variableResolverFactory);
                return this._accessor.getValue(ctx, elCtx, variableResolverFactory);
            }
        }
        return null;
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public long getStamp() {
        return this.stamp;
    }

    public int getRuncount() {
        return this.runcount;
    }

    public Class getKnownEgressType() {
        return this._safeAccessor.getKnownEgressType();
    }
}

